/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public enum RelationshipConnection {
    START_PREV{

        @Override
        public long get(RelationshipRecord rel) {
            return rel.isFirstInFirstChain() ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : rel.getFirstPrevRel();
        }

        @Override
        public long getRaw(RelationshipRecord rel) {
            return rel.getFirstPrevRel();
        }

        @Override
        public void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setFirstPrevRel(id);
            rel.setFirstInFirstChain(isFirst);
        }

        @Override
        public RelationshipConnection otherSide() {
            return START_NEXT;
        }

        @Override
        public long compareNode(RelationshipRecord rel) {
            return rel.getFirstNode();
        }

        @Override
        public RelationshipConnection start() {
            return this;
        }

        @Override
        public RelationshipConnection end() {
            return END_PREV;
        }

        @Override
        public boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInFirstChain();
        }
    }
    ,
    START_NEXT{

        @Override
        public long get(RelationshipRecord rel) {
            return rel.getFirstNextRel();
        }

        @Override
        public long getRaw(RelationshipRecord rel) {
            return rel.getFirstNextRel();
        }

        @Override
        public void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setFirstNextRel(id);
        }

        @Override
        public RelationshipConnection otherSide() {
            return START_PREV;
        }

        @Override
        public long compareNode(RelationshipRecord rel) {
            return rel.getFirstNode();
        }

        @Override
        public RelationshipConnection start() {
            return this;
        }

        @Override
        public RelationshipConnection end() {
            return END_NEXT;
        }

        @Override
        public boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInFirstChain();
        }
    }
    ,
    END_PREV{

        @Override
        public long get(RelationshipRecord rel) {
            return rel.isFirstInSecondChain() ? (long)Record.NO_NEXT_RELATIONSHIP.intValue() : rel.getSecondPrevRel();
        }

        @Override
        public long getRaw(RelationshipRecord rel) {
            return rel.getSecondPrevRel();
        }

        @Override
        public void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setSecondPrevRel(id);
            rel.setFirstInSecondChain(isFirst);
        }

        @Override
        public RelationshipConnection otherSide() {
            return END_NEXT;
        }

        @Override
        public long compareNode(RelationshipRecord rel) {
            return rel.getSecondNode();
        }

        @Override
        public RelationshipConnection start() {
            return START_PREV;
        }

        @Override
        public RelationshipConnection end() {
            return this;
        }

        @Override
        public boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInSecondChain();
        }
    }
    ,
    END_NEXT{

        @Override
        public long get(RelationshipRecord rel) {
            return rel.getSecondNextRel();
        }

        @Override
        public long getRaw(RelationshipRecord rel) {
            return rel.getSecondNextRel();
        }

        @Override
        public void set(RelationshipRecord rel, long id, boolean isFirst) {
            rel.setSecondNextRel(id);
        }

        @Override
        public RelationshipConnection otherSide() {
            return END_PREV;
        }

        @Override
        public long compareNode(RelationshipRecord rel) {
            return rel.getSecondNode();
        }

        @Override
        public RelationshipConnection start() {
            return START_NEXT;
        }

        @Override
        public RelationshipConnection end() {
            return this;
        }

        @Override
        public boolean isFirstInChain(RelationshipRecord rel) {
            return rel.isFirstInSecondChain();
        }
    };


    public abstract long get(RelationshipRecord var1);

    public abstract long getRaw(RelationshipRecord var1);

    public abstract boolean isFirstInChain(RelationshipRecord var1);

    public abstract void set(RelationshipRecord var1, long var2, boolean var4);

    public abstract long compareNode(RelationshipRecord var1);

    public abstract RelationshipConnection otherSide();

    public abstract RelationshipConnection start();

    public abstract RelationshipConnection end();
}

