/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.batchimport.cache.LongArray;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

public class RelationshipCounter {
    public static final Incrementer MANUAL_INCREMENTER = (array, index) -> array.set(index, array.get(index) + 1L);
    private static final StrayRelationship IGNORE_STRAY_RELATIONSHIP = (s, t, e) -> {};
    private static final int START = 0;
    private static final int END = 1;
    private static final int SIDES = 2;
    private final NodeLabelsLookup nodeLabelsLookup;
    private final int highLabelId;
    private final long highRelationshipTypeId;
    private final Incrementer incrementer;
    private final long sideSize;
    private final LongArray wildcardCounts;
    private final LongArray labelsCounts;

    public RelationshipCounter(NodeLabelsLookup nodeLabelsLookup, int highLabelId, int highRelationshipTypeId, LongArray wildcardCounts, LongArray labelsCounts, Incrementer incrementer) {
        this.nodeLabelsLookup = nodeLabelsLookup;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.incrementer = incrementer;
        this.sideSize = RelationshipCounter.sideSize(highLabelId, highRelationshipTypeId);
        this.wildcardCounts = wildcardCounts;
        this.labelsCounts = labelsCounts;
    }

    public void process(RelationshipRecord relationship) {
        this.process(relationship, IGNORE_STRAY_RELATIONSHIP);
    }

    public void process(RelationshipRecord relationship, StrayRelationship strayRelationshipReporter) {
        this.process(relationship, strayRelationshipReporter, true, true);
    }

    public void process(RelationshipRecord relationship, StrayRelationship strayRelationshipReporter, boolean processStartNode, boolean processEndNode) {
        this.processRelationshipTypeCounts(relationship, strayRelationshipReporter);
        this.processRelationshipNodeCounts(relationship, strayRelationshipReporter, processStartNode, processEndNode);
    }

    public void processRelationshipNodeCounts(RelationshipRecord relationship, StrayRelationship strayRelationshipReporter, boolean processStartNode, boolean processEndNode) {
        int type = relationship.getType();
        if (processStartNode) {
            for (int labelId : this.nodeLabelsLookup.nodeLabels(relationship.getFirstNode())) {
                if (labelId == -1) break;
                this.increment(this.labelsCounts, labelId, -1, 0L, strayRelationshipReporter);
                this.increment(this.labelsCounts, labelId, type, 0L, strayRelationshipReporter);
            }
        }
        if (processEndNode) {
            for (int labelId : this.nodeLabelsLookup.nodeLabels(relationship.getSecondNode())) {
                if (labelId == -1) break;
                this.increment(this.labelsCounts, labelId, -1, 1L, strayRelationshipReporter);
                this.increment(this.labelsCounts, labelId, type, 1L, strayRelationshipReporter);
            }
        }
    }

    public void processRelationshipTypeCounts(RelationshipRecord relationship, StrayRelationship strayRelationshipReporter) {
        int type = relationship.getType();
        this.incrementer.increment(this.wildcardCounts, this.highRelationshipTypeId);
        if (this.isValidRelationshipTypeId(type)) {
            this.incrementer.increment(this.wildcardCounts, type);
        } else {
            strayRelationshipReporter.report(-1, type, -1);
        }
    }

    private long arrayIndex(int labelId, long relationshipTypeId, long side) {
        return side * this.sideSize + ((long)labelId * (this.highRelationshipTypeId + 1L) + relationshipTypeId);
    }

    private void increment(LongArray counts, int labelId, int relationshipTypeId, long side, StrayRelationship strayRelationshipReporter) {
        if (this.isValidLabelId(labelId) && this.isValidRelationshipTypeId(relationshipTypeId)) {
            long index = this.arrayIndex(this.labelPos(labelId), this.relationshipTypePos(relationshipTypeId), side);
            this.incrementer.increment(counts, index);
        } else {
            int startLabelId = side == 0L ? labelId : -1;
            int endLabelId = side == 0L ? -1 : labelId;
            strayRelationshipReporter.report(startLabelId, relationshipTypeId, endLabelId);
        }
    }

    public static long wildcardCountsLength(long highRelationshipTypeId) {
        return highRelationshipTypeId + 1L;
    }

    public static long labelsCountsLength(long highLabelId, long highRelationshipTypeId) {
        return RelationshipCounter.sideSize(highLabelId, highRelationshipTypeId) * 2L;
    }

    private static long sideSize(long highLabelId, long highRelationshipTypeId) {
        return (highLabelId + 1L) * (highRelationshipTypeId + 1L);
    }

    public long startLabelCount(int labelId, int typeId) {
        return this.labelsCounts.get(this.arrayIndex(this.labelPos(labelId), this.relationshipTypePos(typeId), 0L));
    }

    public long endLabelCount(int labelId, int typeId) {
        return this.labelsCounts.get(this.arrayIndex(this.labelPos(labelId), this.relationshipTypePos(typeId), 1L));
    }

    private void setStartLabelCount(int labelId, int typeId, long count) {
        this.labelsCounts.set(this.arrayIndex(this.labelPos(labelId), this.relationshipTypePos(typeId), 0L), count);
    }

    private void setEndLabelCount(int labelId, int typeId, long count) {
        this.labelsCounts.set(this.arrayIndex(this.labelPos(labelId), this.relationshipTypePos(typeId), 1L), count);
    }

    private long relationshipTypePos(int typeId) {
        return typeId == -1 ? this.highRelationshipTypeId : (long)typeId;
    }

    private int labelPos(int labelId) {
        return labelId == -1 ? this.highLabelId : labelId;
    }

    public boolean isValid(int startLabelId, int relationshipTypeId, int endLabelId) {
        return this.isValidLabelId(startLabelId) && this.isValidRelationshipTypeId(relationshipTypeId) && this.isValidLabelId(endLabelId);
    }

    private boolean isValidLabelId(int labelId) {
        return labelId == -1 || labelId >= 0 && labelId < this.highLabelId;
    }

    private boolean isValidRelationshipTypeId(int relationshipTypeId) {
        return relationshipTypeId == -1 || relationshipTypeId >= 0 && (long)relationshipTypeId < this.highRelationshipTypeId;
    }

    public long get(int startLabelId, int relationshipTypeId, int endLabelId) {
        if (startLabelId == -1 && endLabelId == -1) {
            return this.wildcardCounts.get(this.relationshipTypePos(relationshipTypeId));
        }
        if (startLabelId == -1) {
            return this.endLabelCount(endLabelId, relationshipTypeId);
        }
        if (endLabelId == -1) {
            return this.startLabelCount(startLabelId, relationshipTypeId);
        }
        throw new UnsupportedOperationException("Either start or end label expected to by ANY and the other a real id, was start:" + startLabelId + ", end:" + endLabelId);
    }

    public void set(int startLabelId, int relationshipTypeId, int endLabelId, long count) {
        if (startLabelId == -1 && endLabelId == -1) {
            this.wildcardCounts.set(this.relationshipTypePos(relationshipTypeId), count);
        } else if (startLabelId == -1) {
            this.setEndLabelCount(endLabelId, relationshipTypeId, count);
        } else {
            this.setStartLabelCount(startLabelId, relationshipTypeId, count);
        }
    }

    public static interface NodeLabelsLookup {
        public int[] nodeLabels(long var1);
    }

    public static interface Incrementer {
        public void increment(LongArray var1, long var2);
    }

    public static interface StrayRelationship {
        public void report(int var1, int var2, int var3);
    }
}

