/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.Predicate;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordAccessSet;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;

public class RelationshipGroupGetter {
    private final IdSequence idGenerator;
    private final CursorContext cursorContext;

    public RelationshipGroupGetter(IdSequence idGenerator, CursorContext cursorContext) {
        this.idGenerator = idGenerator;
        this.cursorContext = cursorContext;
    }

    public RelationshipGroupPosition getRelationshipGroup(NodeRecord node, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, RelationshipGroupMonitor monitor) {
        return this.getRelationshipGroup(Record.NULL_REFERENCE.longValue(), node.getNextRel(), type, relGroupRecords, monitor);
    }

    public RelationshipGroupPosition getRelationshipGroup(long prevGroupId, long startingGroupId, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, RelationshipGroupMonitor monitor) {
        long groupId = startingGroupId;
        long previousGroupId = prevGroupId;
        RecordAccess.RecordProxy<RelationshipGroupRecord, Object> previous = null;
        while (!Record.isNull(groupId)) {
            RecordAccess.RecordProxy<RelationshipGroupRecord, Object> current = relGroupRecords.getOrLoad(groupId, null);
            RelationshipGroupRecord record = current.forReadingData();
            monitor.visit(record);
            record.setPrev(previousGroupId);
            if (record.getType() == type) {
                return new RelationshipGroupPosition(previous, current);
            }
            if (record.getType() > type) {
                return new RelationshipGroupPosition(previous, null);
            }
            previousGroupId = groupId;
            groupId = record.getNext();
            previous = current;
        }
        return new RelationshipGroupPosition(previous, null);
    }

    public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> getOrCreateRelationshipGroup(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
        return this.getOrCreateRelationshipGroup(nodeChange, type, relGroupRecords, Record.NULL_REFERENCE.longValue(), nodeChange.forReadingLinkage().getNextRel());
    }

    public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> getOrCreateRelationshipGroup(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords, long prevGroupId, long startingGroupId) {
        RelationshipGroupPosition existingGroup = this.getRelationshipGroup(prevGroupId, startingGroupId, type, relGroupRecords, RelationshipGroupMonitor.EMPTY);
        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> change = existingGroup.group();
        if (change == null) {
            NodeRecord node = nodeChange.forReadingLinkage();
            assert (node.isDense()) : "Node " + String.valueOf(node) + " should have been dense at this point";
            long id = this.idGenerator.nextId(this.cursorContext);
            change = relGroupRecords.create(id, type, this.cursorContext);
            RelationshipGroupRecord record = change.forChangingData();
            record.setInUse(true);
            record.setCreated();
            record.setOwningNode(node.getId());
            RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPreviousChange = existingGroup.closestPrevious();
            if (closestPreviousChange != null) {
                RelationshipGroupRecord closestPrevious = closestPreviousChange.forChangingLinkage();
                if (!Record.isNull(closestPrevious.getNext())) {
                    relGroupRecords.getOrLoad(closestPrevious.getNext(), null).forChangingLinkage().setPrev(id);
                }
                record.setNext(closestPrevious.getNext());
                record.setPrev(closestPrevious.getId());
                closestPrevious.setNext(id);
            } else {
                node = nodeChange.forChangingLinkage();
                long firstGroupId = node.getNextRel();
                if (!Record.isNull(firstGroupId)) {
                    RelationshipGroupRecord previousFirstRecord = relGroupRecords.getOrLoad(firstGroupId, type).forReadingData();
                    record.setNext(previousFirstRecord.getId());
                    previousFirstRecord.setPrev(id);
                }
                node.setNextRel(id);
            }
        }
        return change;
    }

    static void deleteGroup(RecordAccess.RecordProxy<NodeRecord, Void> nodeChange, RelationshipGroupRecord group, GroupLookup groupLookup) {
        long previous = group.getPrev();
        long next = group.getNext();
        if (Record.isNull(previous)) {
            nodeChange.forChangingLinkage().setNextRel(next);
        } else {
            groupLookup.group(previous).forChangingLinkage().setNext(next);
        }
        if (!Record.isNull(next)) {
            groupLookup.group(next).forReadingLinkage().setPrev(previous);
        }
        group.setInUse(false);
    }

    static boolean groupIsEmpty(RelationshipGroupRecord group) {
        return Record.isNull(group.getFirstOut()) && Record.isNull(group.getFirstIn()) && Record.isNull(group.getFirstLoop());
    }

    public static boolean deleteEmptyGroups(RecordAccess.RecordProxy<NodeRecord, Void> nodeProxy, Predicate<RelationshipGroupRecord> canDeleteGroup, GroupLookup groupLookup) {
        long groupId = nodeProxy.forReadingLinkage().getNextRel();
        long previousGroupId = Record.NULL_REFERENCE.longValue();
        boolean anyDeleted = false;
        while (!Record.isNull(groupId)) {
            RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> current = groupLookup.group(groupId);
            RelationshipGroupRecord group = current.forReadingData();
            group.setPrev(previousGroupId);
            if (group.inUse() && RelationshipGroupGetter.groupIsEmpty(group) && canDeleteGroup.test(group)) {
                group = current.forChangingData();
                RelationshipGroupGetter.deleteGroup(nodeProxy, group, groupLookup);
                anyDeleted = true;
            } else {
                previousGroupId = groupId;
            }
            groupId = group.getNext();
        }
        return anyDeleted;
    }

    static interface RelationshipGroupMonitor {
        public static final RelationshipGroupMonitor EMPTY = g -> {};

        public void visit(RelationshipGroupRecord var1);
    }

    public record RelationshipGroupPosition(RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious, RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group) {
    }

    static interface GroupLookup {
        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group(long var1);
    }

    static class DirectGroupLookup
    implements GroupLookup {
        final RecordAccessSet recordChanges;
        final CursorContext cursorContext;

        DirectGroupLookup(RecordAccessSet recordChanges, CursorContext cursorContext) {
            this.recordChanges = recordChanges;
            this.cursorContext = cursorContext;
        }

        @Override
        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group(long groupId) {
            return this.recordChanges.getRelGroupRecords().getOrLoad(groupId, null);
        }
    }
}

