/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.indexcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.indexcommand.IndexUpdatesState;
import org.neo4j.internal.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.internal.recordstorage.RecordState;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class IndexRecordState
implements RecordState,
IndexUpdatesState {
    private final IndexCommandSerialization serialization;
    private final List<TokenIndexEntryUpdate> tokenIndexUpdates = new ArrayList<TokenIndexEntryUpdate>();
    private final Map<IndexUpdatesState.IndexEntityPair, ValueIndexEntryUpdate> valueIndexUpdates = new HashMap<IndexUpdatesState.IndexEntityPair, ValueIndexEntryUpdate>();

    public IndexRecordState(IndexCommandSerialization serialization) {
        this.serialization = serialization;
    }

    @Override
    public void extractCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        int tokenIndexCommandsSize;
        int valueIndexCommandsSize = this.valueIndexUpdates.size();
        if (valueIndexCommandsSize + (tokenIndexCommandsSize = this.tokenIndexUpdates.size()) == 0) {
            return;
        }
        memoryTracker.allocateHeap((long)valueIndexCommandsSize * ValueIndexUpdateCommand.SHALLOW_SIZE);
        memoryTracker.allocateHeap((long)tokenIndexCommandsSize * TokenIndexUpdateCommand.SHALLOW_SIZE);
        this.extractValueCommands(target, memoryTracker);
        this.extractTokenCommands(target, memoryTracker);
    }

    private void extractTokenCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        try (HeapTrackingArrayList tokenIndexIndexCommands = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);){
            for (TokenIndexEntryUpdate update : this.tokenIndexUpdates) {
                tokenIndexIndexCommands.add((Object)new TokenIndexUpdateCommand(this.serialization, update.indexKey().getId(), update.getEntityId(), update.removed(), update.added()));
            }
            tokenIndexIndexCommands.sort((Comparator)IndexComamdComparator.INDEX_COMMANDS_COMPARATOR);
            target.addAll((Collection<StorageCommand>)tokenIndexIndexCommands);
        }
    }

    private void extractValueCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        try (HeapTrackingArrayList valueIndexCommands = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);){
            for (ValueIndexEntryUpdate update : this.valueIndexUpdates.values()) {
                Value[] before = null;
                if (update.updateMode() == UpdateMode.CHANGED) {
                    before = update.beforeValues();
                }
                valueIndexCommands.add((Object)new ValueIndexUpdateCommand(this.serialization, update.updateMode(), update.indexKey().getId(), update.getEntityId(), before, update.values()));
            }
            valueIndexCommands.sort((Comparator)IndexComamdComparator.INDEX_COMMANDS_COMPARATOR);
            target.addAll((Collection<StorageCommand>)valueIndexCommands);
        }
    }

    public void addTokenUpdate(TokenIndexEntryUpdate tokenIndexUpdate) {
        this.tokenIndexUpdates.add(tokenIndexUpdate);
    }

    public void putValueUpdate(IndexUpdatesState.IndexEntityPair key, ValueIndexEntryUpdate update) {
        this.valueIndexUpdates.put(key, update);
    }

    public ValueIndexEntryUpdate getValueUpdate(IndexUpdatesState.IndexEntityPair key) {
        return this.valueIndexUpdates.get(key);
    }

    public void close() throws Exception {
    }

    private static class IndexComamdComparator
    implements Comparator<IndexUpdateCommand<?>> {
        static final IndexComamdComparator INDEX_COMMANDS_COMPARATOR = new IndexComamdComparator();

        private IndexComamdComparator() {
        }

        @Override
        public int compare(IndexUpdateCommand o1, IndexUpdateCommand o2) {
            int result = Long.compare(o1.getIndexId(), o2.getIndexId());
            if (result != 0) {
                return result;
            }
            return Long.compare(o1.getEntityId(), o2.getEntityId());
        }
    }
}

