/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.configuration.Config;
import org.neo4j.function.Predicates;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.InconsistentDataReadException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.IntStoreHeader;
import org.neo4j.kernel.impl.store.IntStoreHeaderFormat;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.RecordChainCycleDetectedException;
import org.neo4j.kernel.impl.store.RecordSubscriber;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public abstract class AbstractDynamicStore
extends CommonAbstractStore<DynamicRecord, IntStoreHeader> {
    public AbstractDynamicStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, String typeDescriptor, int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat, boolean readOnly, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(fileSystem, path, idFile, conf, idType, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, typeDescriptor, recordFormat, new DynamicStoreHeaderFormat(dataSizeFromConfiguration, recordFormat), readOnly, databaseName, openOptions);
    }

    public static void allocateRecordsFromBytes(Collection<DynamicRecord> recordList, byte[] src, DynamicRecordAllocator dynamicRecordAllocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        Objects.requireNonNull(src);
        int dataSize = dynamicRecordAllocator.getRecordDataSize();
        int payloadSize = src.length;
        int lastBlockSize = payloadSize % dataSize;
        long fullBlockSize = DynamicRecord.SHALLOW_SIZE + HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + dataSize));
        int numberOfFullBlocks = payloadSize / dataSize;
        long totalSize = (long)numberOfFullBlocks * fullBlockSize;
        if (lastBlockSize != 0) {
            totalSize += DynamicRecord.SHALLOW_SIZE + HeapEstimator.alignObjectSize((long)(HeapEstimator.ARRAY_HEADER_BYTES + lastBlockSize));
        }
        memoryTracker.allocateHeap(totalSize);
        DynamicRecord nextRecord = dynamicRecordAllocator.nextRecord(cursorContext);
        int srcOffset = 0;
        do {
            DynamicRecord record = nextRecord;
            record.setStartRecord(srcOffset == 0);
            if (payloadSize - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                nextRecord = dynamicRecordAllocator.nextRecord(cursorContext);
                record.setNextBlock(nextRecord.getId());
                srcOffset += dataSize;
            } else {
                data = new byte[payloadSize - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextRecord = null;
                record.setNextBlock(Record.NO_NEXT_BLOCK.intValue());
            }
            recordList.add(record);
            assert (record.getData() != null);
        } while (nextRecord != null);
    }

    public static byte[] getFullByteArrayFromHeavyRecords(Iterable<DynamicRecord> records, PropertyType propertyType) {
        return AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, propertyType).data();
    }

    static HeavyRecordData readFullByteArrayFromHeavyRecords(Iterable<DynamicRecord> records, PropertyType propertyType) {
        int offset;
        byte[] header = null;
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        int totalSize = 0;
        int i = 0;
        for (DynamicRecord record : records) {
            offset = 0;
            if (i++ == 0) {
                header = propertyType.readDynamicRecordHeader(record.getData());
                offset = header.length;
            }
            byteList.add(record.getData());
            totalSize += record.getData().length - offset;
        }
        byte[] bArray = new byte[totalSize];
        assert (header != null) : "header should be non-null since records should not be empty: " + Iterables.toString(records, (String)", ");
        int sourceOffset = header.length;
        offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, sourceOffset, bArray, offset, currentArray.length - sourceOffset);
            offset += currentArray.length - sourceOffset;
            sourceOffset = 0;
        }
        return new HeavyRecordData(header, bArray);
    }

    @Override
    public String toString() {
        return super.toString() + "[fileName:" + String.valueOf(this.storageFile.getFileName()) + ", blockSize:" + this.getRecordDataSize() + "]";
    }

    HeavyRecordData readFullByteArray(Iterable<DynamicRecord> records, PropertyType propertyType, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        for (DynamicRecord record : records) {
            this.ensureHeavy(record, storeCursors, memoryTracker);
        }
        return AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, propertyType);
    }

    List<DynamicRecord> getRecords(long firstId, RecordLoad mode, boolean guardForCycles, PageCursor pageCursor, MemoryTracker memoryTracker) throws InvalidRecordException {
        ArrayList<DynamicRecord> list = new ArrayList<DynamicRecord>();
        this.streamRecords(firstId, mode, guardForCycles, pageCursor, list::add, memoryTracker);
        return list;
    }

    public void streamRecords(long firstId, RecordLoad mode, boolean guardForCycles, PageCursor cursor, RecordSubscriber<DynamicRecord> subscriber, MemoryTracker memoryTracker) {
        if (Record.NULL_REFERENCE.is(firstId)) {
            return;
        }
        LongPredicate cycleGuard = guardForCycles ? AbstractDynamicStore.createRecordCycleGuard() : Predicates.ALWAYS_FALSE_LONG;
        long id = firstId;
        MutableLongSet seenRecordIds = null;
        int count = 0;
        do {
            memoryTracker.allocateHeap(DynamicRecord.SHALLOW_SIZE);
            DynamicRecord record = new DynamicRecord(-1L);
            if (cycleGuard.test(id)) {
                throw this.newCycleDetectedException(firstId, id);
            }
            this.getRecordByCursor(id, record, mode, cursor, memoryTracker);
            if (!subscriber.onRecord(record)) {
                return;
            }
            id = record.getNextBlock();
            if (++count < 100000) continue;
            if (seenRecordIds == null) {
                seenRecordIds = LongSets.mutable.empty();
            }
            if (seenRecordIds.add(id)) continue;
            throw new InconsistentDataReadException("Chain cycle detected while reading chain in store %s starting at id:%d", this, firstId);
        } while (!Record.NULL_REFERENCE.is(id));
    }

    private static LongPredicate createRecordCycleGuard() {
        MutableLongSet observedSet = LongSets.mutable.empty();
        return id -> !observedSet.add(id);
    }

    private RecordChainCycleDetectedException newCycleDetectedException(long firstId, long conflictingId) {
        return new RecordChainCycleDetectedException("Cycle detected in DynamicRecord chain starting at id " + firstId + ", and finding id " + conflictingId + " twice in the chain.");
    }

    private static class DynamicStoreHeaderFormat
    extends IntStoreHeaderFormat {
        DynamicStoreHeaderFormat(int dataSizeFromConfiguration, RecordFormat<DynamicRecord> recordFormat) {
            super(dataSizeFromConfiguration + recordFormat.getRecordHeaderSize());
        }

        @Override
        public void writeHeader(PageCursor cursor) {
            if (this.header < 1 || this.header > 65535) {
                throw new IllegalArgumentException("Illegal block size[" + this.header + "], limit is 65535");
            }
            super.writeHeader(cursor);
        }
    }

    record HeavyRecordData(byte[] header, byte[] data) {
    }
}

