/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.charset.StandardCharsets;
import org.neo4j.internal.codec.ShortStringCodec;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.util.BitBuffer;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

public class LongerShortString {
    private static final int HEADER_SIZE = 39;
    private static final int REMOVE_LARGE_ENCODINGS_MASK = ~ShortStringCodec.bitMask((ShortStringCodec[])new ShortStringCodec[]{ShortStringCodec.ALPHANUM, ShortStringCodec.ALPHASYM, ShortStringCodec.URI, ShortStringCodec.EUROPEAN});

    public static boolean encode(int keyId, String string, PropertyBlock target, int payloadSize) {
        int dataLength = string.length();
        if (dataLength > LongerShortString.maxLength(ShortStringCodec.NUMERICAL, payloadSize) || dataLength > 63) {
            return false;
        }
        byte[] data = new byte[dataLength];
        int codecs = ShortStringCodec.prepareEncode((String)string, (byte[])data, (int)dataLength, (boolean)false);
        if (dataLength > LongerShortString.maxLength(ShortStringCodec.ALPHANUM, payloadSize)) {
            codecs &= REMOVE_LARGE_ENCODINGS_MASK;
        }
        if (codecs != 0 && LongerShortString.tryEncode(codecs, keyId, target, payloadSize, data, dataLength)) {
            return true;
        }
        return LongerShortString.encodeWithCharSet(keyId, string, target, payloadSize, dataLength);
    }

    private static boolean encodeWithCharSet(int keyId, String string, PropertyBlock target, int payloadSize, int stringLength) {
        int maxBytes = PropertyType.getPayloadSize();
        if (stringLength <= maxBytes - 5) {
            return LongerShortString.encodeLatin1(keyId, string, target) || LongerShortString.encodeUTF8(keyId, string, target, payloadSize);
        }
        return false;
    }

    private static boolean tryEncode(int encodings, int keyId, PropertyBlock target, int payloadSize, byte[] data, int length) {
        for (ShortStringCodec codec : ShortStringCodec.CODECS) {
            if ((codec.bitMask() & encodings) == 0 || !LongerShortString.doEncode(keyId, data, target, payloadSize, length, codec)) continue;
            return true;
        }
        return false;
    }

    private static void writeHeader(BitBuffer bits, int keyId, int encoding, int stringLength) {
        bits.put(keyId, 24).put(PropertyType.SHORT_STRING.intValue(), 4).put(encoding, 5).put(stringLength, 6);
    }

    public static TextValue decode(PropertyBlock block) {
        return LongerShortString.decode(block.getValueBlocks(), 0);
    }

    public static TextValue decode(long[] blocks, int offset) {
        long firstLong = blocks[offset];
        if ((firstLong & 0xFFFFFF0FFFFFFFFFL) == 0L) {
            return Values.EMPTY_STRING;
        }
        int codecId = (int)((firstLong & 0x1F0000000L) >>> 28);
        int stringLength = (int)((firstLong & 0x7E00000000L) >>> 33);
        if (codecId == 0) {
            return LongerShortString.decodeUTF8(blocks, offset, stringLength);
        }
        if (codecId == 10) {
            return LongerShortString.decodeLatin1(blocks, offset, stringLength);
        }
        ShortStringCodec table = ShortStringCodec.codecById((int)codecId);
        assert (table != null) : "We only decode LongerShortStrings after we have consistently read the PropertyBlock data from the page cache. Thus, we should never have an invalid encoding header here.";
        if (table.needsChars()) {
            char[] result = new char[stringLength];
            LongerShortString.decode(result, blocks, offset, table);
            return Values.stringValue((String)new String(result));
        }
        byte[] result = new byte[stringLength];
        LongerShortString.decode(result, blocks, offset, table);
        return Values.utf8Value((byte[])result);
    }

    private static void decode(byte[] result, long[] blocks, int offset, ShortStringCodec table) {
        int block = offset;
        int maskShift = 39;
        long baseMask = table.mask();
        for (int i = 0; i < result.length; ++i) {
            byte codePoint = (byte)(blocks[block] >>> maskShift & baseMask);
            if ((maskShift += table.bitsPerCharacter()) >= 64 && block + 1 < blocks.length) {
                codePoint = (byte)((long)codePoint | (blocks[++block] & baseMask >>> table.bitsPerCharacter() - (maskShift %= 64)) << table.bitsPerCharacter() - maskShift);
            }
            result[i] = table.decTranslate(codePoint);
        }
    }

    private static void decode(char[] result, long[] blocks, int offset, ShortStringCodec table) {
        int block = offset;
        int maskShift = 39;
        long baseMask = table.mask();
        for (int i = 0; i < result.length; ++i) {
            byte codePoint = (byte)(blocks[block] >>> maskShift & baseMask);
            if ((maskShift += table.bitsPerCharacter()) >= 64 && block + 1 < blocks.length) {
                codePoint = (byte)((long)codePoint | (blocks[++block] & baseMask >>> table.bitsPerCharacter() - (maskShift %= 64)) << table.bitsPerCharacter() - maskShift);
            }
            result[i] = (char)(table.decTranslate(codePoint) & 0xFF);
        }
    }

    private static BitBuffer newBits(ShortStringCodec codec, int length) {
        return BitBuffer.bits((int)(LongerShortString.calculateNumberOfBlocksUsed(codec, length) * 8));
    }

    private static BitBuffer newBitsForStep8(int length) {
        return BitBuffer.bits((int)(LongerShortString.calculateNumberOfBlocksUsedForStep8(length) << 3));
    }

    private static boolean encodeLatin1(int keyId, String string, PropertyBlock target) {
        int length = string.length();
        BitBuffer bits = LongerShortString.newBitsForStep8(length);
        LongerShortString.writeHeader(bits, keyId, 10, length);
        if (!LongerShortString.writeLatin1Characters(string, bits)) {
            return false;
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    public static boolean writeLatin1Characters(String string, BitBuffer bits) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0100') {
                return false;
            }
            bits.put((int)c, 8);
        }
        return true;
    }

    private static boolean encodeUTF8(int keyId, String string, PropertyBlock target, int payloadSize) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > payloadSize - 3 - 2) {
            return false;
        }
        BitBuffer bits = LongerShortString.newBitsForStep8(length);
        LongerShortString.writeHeader(bits, keyId, 0, length);
        for (byte value : bytes) {
            bits.put(value);
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    private static int maxLength(ShortStringCodec codec, int payloadSize) {
        return ((payloadSize << 3) - 24 - 4 - 4 - 6) / codec.bitsPerCharacter();
    }

    private static boolean doEncode(int keyId, byte[] data, PropertyBlock target, int payloadSize, int length, ShortStringCodec codec) {
        if (length > LongerShortString.maxLength(codec, payloadSize)) {
            return false;
        }
        BitBuffer bits = LongerShortString.newBits(codec, length);
        LongerShortString.writeHeader(bits, keyId, codec.id(), length);
        if (length > 0) {
            LongerShortString.translateData(bits, data, length, codec.bitsPerCharacter(), codec);
        }
        target.setValueBlocks(bits.getLongs());
        return true;
    }

    private static void translateData(BitBuffer bits, byte[] data, int length, int step, ShortStringCodec codec) {
        for (int i = 0; i < length; ++i) {
            bits.put(codec.encTranslate(data[i]), step);
        }
    }

    private static TextValue decodeLatin1(long[] blocks, int offset, int stringLength) {
        char[] result = new char[stringLength];
        int block = offset;
        int maskShift = 39;
        for (int i = 0; i < result.length; ++i) {
            char codePoint = (char)(blocks[block] >>> maskShift & 0xFFL);
            if ((maskShift += 8) >= 64) {
                codePoint = (char)((long)codePoint | (blocks[++block] & (long)(255 >>> 8 - (maskShift %= 64))) << 8 - maskShift);
            }
            result[i] = codePoint;
        }
        return Values.stringValue((String)new String(result));
    }

    private static TextValue decodeUTF8(long[] blocks, int offset, int stringLength) {
        byte[] result = new byte[stringLength];
        int block = offset;
        int maskShift = 39;
        for (int i = 0; i < result.length; ++i) {
            byte codePoint = (byte)(blocks[block] >>> maskShift);
            if ((maskShift += 8) >= 64) {
                codePoint = (byte)((long)codePoint | (blocks[++block] & (long)(255 >>> 8 - (maskShift %= 64))) << 8 - maskShift);
            }
            result[i] = codePoint;
        }
        return Values.utf8Value((byte[])result);
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int codecId = (int)((firstBlock & 0x1F0000000L) >> 28);
        int length = (int)((firstBlock & 0x7E00000000L) >> 33);
        if (codecId == 0 || codecId == 10) {
            return LongerShortString.calculateNumberOfBlocksUsedForStep8(length);
        }
        ShortStringCodec codec = ShortStringCodec.codecById((int)codecId);
        if (codec == null) {
            return -1;
        }
        return LongerShortString.calculateNumberOfBlocksUsed(codec, length);
    }

    public static int calculateNumberOfBlocksUsedForStep8(int length) {
        return LongerShortString.totalBits(length << 3);
    }

    public static int calculateNumberOfBlocksUsed(ShortStringCodec codec, int length) {
        return LongerShortString.totalBits(length * codec.bitsPerCharacter());
    }

    private static int totalBits(int bitsForCharacters) {
        int bitsInTotal = 39 + bitsForCharacters;
        return (bitsInTotal - 1 >> 6) + 1;
    }
}

