/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.FeatureUnsupportedOnStoreFormatException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.InconsistentDataReadException;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.internal.recordstorage.RecordPropertyCursor;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.PropertyValueRecordSizeCalculator;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.string.UTF8;
import org.neo4j.util.BitBuffer;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.TemporalValueWriterAdapter;

public class PropertyStore
extends CommonAbstractStore<PropertyRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "PropertyStore";
    private final DynamicStringStore stringStore;
    private final PropertyKeyTokenStore propertyKeyTokenStore;
    private final DynamicArrayStore arrayStore;

    public PropertyStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config configuration, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, DynamicStringStore stringPropertyStore, PropertyKeyTokenStore propertyKeyTokenStore, DynamicArrayStore arrayPropertyStore, RecordFormats recordFormats, boolean readOnly, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(fileSystem, path, idFile, configuration, RecordIdType.PROPERTY, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, TYPE_DESCRIPTOR, recordFormats.property(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, readOnly, databaseName, openOptions);
        this.stringStore = stringPropertyStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.arrayStore = arrayPropertyStore;
    }

    public DynamicStringStore getStringStore() {
        return this.stringStore;
    }

    public DynamicArrayStore getArrayStore() {
        return this.arrayStore;
    }

    public PropertyKeyTokenStore getPropertyKeyTokenStore() {
        return this.propertyKeyTokenStore;
    }

    @Override
    public void updateRecord(PropertyRecord record, IdUpdateListener idUpdateListener, PageCursor cursor, CursorContext cursorContext, StoreCursors storeCursors) {
        this.updatePropertyBlocks(record, idUpdateListener, cursorContext, storeCursors);
        super.updateRecord(record, idUpdateListener, cursor, cursorContext, storeCursors);
    }

    private void updatePropertyBlocks(PropertyRecord record, IdUpdateListener idUpdateListener, CursorContext cursorContext, StoreCursors storeCursors) {
        if (record.inUse()) {
            for (PropertyBlock block : record.propertyBlocks()) {
                if (block.isLight() || !block.getValueRecords().get(0).isCreated()) continue;
                this.updateDynamicRecords(block.getValueRecords(), idUpdateListener, cursorContext, storeCursors);
            }
        }
        this.updateDynamicRecords(record.getDeletedRecords(), idUpdateListener, cursorContext, storeCursors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDynamicRecords(List<DynamicRecord> records, IdUpdateListener idUpdateListener, CursorContext cursorContext, StoreCursors storeCursors) {
        PageCursor stringCursor = null;
        PageCursor arrayCursor = null;
        try {
            for (DynamicRecord valueRecord : records) {
                PropertyType recordType = valueRecord.getType();
                if (recordType == PropertyType.STRING) {
                    if (stringCursor == null) {
                        stringCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.DYNAMIC_STRING_STORE_CURSOR);
                    }
                    this.stringStore.updateRecord(valueRecord, idUpdateListener, stringCursor, cursorContext, storeCursors);
                    continue;
                }
                if (recordType == PropertyType.ARRAY) {
                    if (arrayCursor == null) {
                        arrayCursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR);
                    }
                    this.arrayStore.updateRecord(valueRecord, idUpdateListener, arrayCursor, cursorContext, storeCursors);
                    continue;
                }
                throw new InvalidRecordException("Unknown dynamic record" + String.valueOf(valueRecord));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{stringCursor, arrayCursor});
            throw throwable;
        }
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{stringCursor, arrayCursor});
    }

    @Override
    public void ensureHeavy(PropertyRecord record, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long heapBefore = memoryTracker.estimatedHeapMemory();
        for (PropertyBlock block : record.propertyBlocks()) {
            this.ensureHeavy(block, storeCursors, memoryTracker);
        }
        record.heavyHeapSize = memoryTracker.estimatedHeapMemory() - heapBefore;
    }

    @Override
    public void ensureHeavy(PropertyBlock block, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (!block.isLight()) {
            return;
        }
        PropertyType type = block.getType();
        AbstractDynamicStore dynamicStore = this.dynamicStoreForValueType(type);
        if (dynamicStore != null) {
            PageCursor cursorForType = this.dynamicStoreCursorForType(storeCursors, type);
            List<DynamicRecord> dynamicRecords = dynamicStore.getRecords(block.getSingleValueLong(), RecordLoad.NORMAL, false, cursorForType, memoryTracker);
            for (DynamicRecord dynamicRecord : dynamicRecords) {
                dynamicRecord.setType(type.intValue());
            }
            block.setValueRecords(dynamicRecords);
        }
    }

    private PageCursor dynamicStoreCursorForType(StoreCursors storeCursors, PropertyType type) {
        return switch (type) {
            case PropertyType.ARRAY -> storeCursors.readCursor((CursorType)RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR);
            case PropertyType.STRING -> storeCursors.readCursor((CursorType)RecordCursorTypes.DYNAMIC_STRING_STORE_CURSOR);
            default -> throw new IllegalArgumentException("Unsupported type of dynamic property " + String.valueOf((Object)type));
        };
    }

    private AbstractDynamicStore dynamicStoreForValueType(PropertyType type) {
        return switch (type) {
            case PropertyType.ARRAY -> this.arrayStore;
            case PropertyType.STRING -> this.stringStore;
            default -> null;
        };
    }

    public Value getValue(PropertyBlock propertyBlock, StoreCursors cursors, MemoryTracker memoryTracker) {
        return propertyBlock.getType().value(propertyBlock, this, cursors, memoryTracker);
    }

    private static void allocateStringRecords(Collection<DynamicRecord> target, byte[] chars, DynamicRecordAllocator allocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        AbstractDynamicStore.allocateRecordsFromBytes(target, chars, allocator, cursorContext, memoryTracker);
    }

    private static void allocateArrayRecords(Collection<DynamicRecord> target, Object array, DynamicRecordAllocator allocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        DynamicArrayStore.allocateRecords(target, array, allocator, cursorContext, memoryTracker);
    }

    public static void encodeValue(PropertyBlock block, int keyId, Value value, DynamicRecordAllocator stringAllocator, DynamicRecordAllocator arrayAllocator, CursorContext cursorContext, MemoryTracker memoryTracker, String storeFormat) {
        if (value instanceof ArrayValue) {
            Object asObject = value.asObject();
            if (ShortArray.encode(keyId, asObject, block, PropertyType.getPayloadSize())) {
                return;
            }
            HeapTrackingArrayList arrayRecords = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);
            PropertyStore.allocateArrayRecords((Collection<DynamicRecord>)arrayRecords, asObject, arrayAllocator, cursorContext, memoryTracker);
            PropertyStore.setSingleBlockValue(block, keyId, PropertyType.ARRAY, ((DynamicRecord)Iterables.first((Iterable)arrayRecords)).getId());
            for (DynamicRecord valueRecord : arrayRecords) {
                valueRecord.setType(PropertyType.ARRAY.intValue());
            }
            block.setValueRecords((List<DynamicRecord>)arrayRecords);
        } else {
            value.writeTo((ValueWriter)new PropertyBlockValueWriter(block, keyId, stringAllocator, cursorContext, memoryTracker, storeFormat));
        }
    }

    public PageCursor openStringPageCursor(long reference, CursorContext cursorContext) {
        return this.stringStore.openPageCursorForReading(reference, cursorContext);
    }

    public PageCursor openArrayPageCursor(long reference, CursorContext cursorContext) {
        return this.arrayStore.openPageCursorForReading(reference, cursorContext);
    }

    public void loadString(long reference, RecordPropertyCursor propertyCursor, PageCursor page, RecordLoad loadMode, MemoryTracker memoryTracker) {
        PropertyStore.readDynamic(this.stringStore, reference, propertyCursor, page, loadMode, memoryTracker);
    }

    public void loadArray(long reference, RecordPropertyCursor propertyCursor, PageCursor page, RecordLoad loadMode, MemoryTracker memoryTracker) {
        PropertyStore.readDynamic(this.arrayStore, reference, propertyCursor, page, loadMode, memoryTracker);
    }

    private static void readDynamic(AbstractDynamicStore store, long reference, RecordPropertyCursor propertyCursor, PageCursor page, RecordLoad loadMode, MemoryTracker memoryTracker) {
        ByteBuffer buffer = propertyCursor.getOrCreateClearBuffer();
        DynamicRecord record = (DynamicRecord)store.newRecord();
        MutableLongSet seenDynamicIds = null;
        long firstReference = reference;
        int count = 0;
        do {
            store.getRecordByCursor(reference, record, loadMode, page, memoryTracker);
            reference = record.getNextBlock();
            byte[] data = record.getData();
            if (buffer.remaining() < data.length) {
                buffer = propertyCursor.growBuffer(data.length);
            }
            buffer.put(data, 0, data.length);
            memoryTracker.releaseHeap((long)data.length);
            if (++count < 100000) continue;
            if (seenDynamicIds == null) {
                seenDynamicIds = LongSets.mutable.empty();
            }
            if (seenDynamicIds.add(reference)) continue;
            throw new InconsistentDataReadException("Chain cycle detected in dynamic property value store %s starting at id:%d", store, firstReference);
        } while (reference != -1L);
    }

    public static void setSingleBlockValue(PropertyBlock block, int keyId, PropertyType type, long longValue) {
        block.setSingleBlock(PropertyStore.singleBlockLongValue(keyId, type, longValue));
    }

    public static long singleBlockLongValue(int keyId, PropertyType type, long longValue) {
        return (long)keyId | (long)type.intValue() << 24 | longValue << 28;
    }

    public static byte[] encodeString(String string) {
        return UTF8.encode((String)string);
    }

    public static String decodeString(byte[] byteArray) {
        return UTF8.decode((byte[])byteArray);
    }

    TextValue getTextValueFor(PropertyBlock propertyBlock, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        this.ensureHeavy(propertyBlock, storeCursors, memoryTracker);
        return this.getTextValueFor(propertyBlock.getValueRecords(), storeCursors, memoryTracker);
    }

    public TextValue getTextValueFor(Collection<DynamicRecord> dynamicRecords, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        AbstractDynamicStore.HeavyRecordData source = this.stringStore.readFullByteArray(dynamicRecords, PropertyType.STRING, storeCursors, memoryTracker);
        return Values.utf8Value((byte[])source.data());
    }

    Value getArrayFor(PropertyBlock propertyBlock, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        this.ensureHeavy(propertyBlock, storeCursors, memoryTracker);
        return this.getArrayFor(propertyBlock.getValueRecords(), storeCursors, memoryTracker);
    }

    public Value getArrayFor(Collection<DynamicRecord> records, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return this.arrayStore.getArrayFor(records, storeCursors, memoryTracker);
    }

    @Override
    public String toString() {
        return super.toString() + "[blocksPerRecord:" + PropertyType.getPayloadSizeLongs() + "]";
    }

    @Override
    public PropertyRecord newRecord() {
        return new PropertyRecord(-1L);
    }

    public PropertyValueRecordSizeCalculator newValueEncodedSizeCalculator() {
        return new PropertyValueRecordSizeCalculator(this);
    }

    public ArrayValue readArrayFromBuffer(ByteBuffer buffer) {
        if (buffer.limit() <= 0) {
            throw new IllegalStateException("Given buffer is empty");
        }
        byte typeId = buffer.get();
        if (typeId == PropertyType.STRING.intValue()) {
            int arrayLength = buffer.getInt();
            String[] result = new String[arrayLength];
            for (int i = 0; i < arrayLength; ++i) {
                int byteLength = buffer.getInt();
                result[i] = UTF8.decode((byte[])buffer.array(), (int)buffer.position(), (int)byteLength);
                buffer.position(buffer.position() + byteLength);
            }
            return Values.stringArray((String[])result);
        }
        if (typeId == PropertyType.GEOMETRY.intValue()) {
            GeometryType.GeometryHeader header = GeometryType.GeometryHeader.fromArrayHeaderByteBuffer(buffer);
            byte[] byteArray = new byte[buffer.limit() - buffer.position()];
            buffer.get(byteArray);
            return GeometryType.decodeGeometryArray(header, byteArray);
        }
        if (typeId == PropertyType.TEMPORAL.intValue()) {
            TemporalType.TemporalHeader header = TemporalType.TemporalHeader.fromArrayHeaderByteBuffer(buffer);
            byte[] byteArray = new byte[buffer.limit() - buffer.position()];
            buffer.get(byteArray);
            return TemporalType.decodeTemporalArray(header, byteArray);
        }
        ShortArray type = ShortArray.typeOf(typeId);
        byte bitsUsedInLastByte = buffer.get();
        byte requiredBits = buffer.get();
        if (requiredBits == 0) {
            return type.createEmptyArray();
        }
        if (type == ShortArray.BYTE && requiredBits == 8) {
            byte[] byteArray = new byte[buffer.limit() - buffer.position()];
            buffer.get(byteArray);
            return Values.byteArray((byte[])byteArray);
        }
        BitBuffer bits = BitBuffer.bitsFromBytes((byte[])buffer.array(), (int)buffer.position());
        int length = ((buffer.limit() - buffer.position()) * 8 - (8 - bitsUsedInLastByte)) / requiredBits;
        return type.createArray(length, bits, requiredBits);
    }

    private static class PropertyBlockValueWriter
    extends TemporalValueWriterAdapter<IllegalArgumentException> {
        private final PropertyBlock block;
        private final int keyId;
        private final DynamicRecordAllocator stringAllocator;
        private final CursorContext cursorContext;
        private final MemoryTracker memoryTracker;
        private final String storeFormat;

        PropertyBlockValueWriter(PropertyBlock block, int keyId, DynamicRecordAllocator stringAllocator, CursorContext cursorContext, MemoryTracker memoryTracker, String storeFormat) {
            this.block = block;
            this.keyId = keyId;
            this.stringAllocator = stringAllocator;
            this.cursorContext = cursorContext;
            this.memoryTracker = memoryTracker;
            this.storeFormat = storeFormat;
        }

        public void writeNull() throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot write null values to the property store");
        }

        public void writeBoolean(boolean value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.BOOL, value ? 1L : 0L);
        }

        public void writeInteger(byte value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.BYTE, value);
        }

        public void writeInteger(short value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.SHORT, value);
        }

        public void writeInteger(int value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.INT, value);
        }

        public void writeInteger(long value) throws IllegalArgumentException {
            long keyAndType = (long)this.keyId | (long)PropertyType.LONG.intValue() << 24;
            if (ShortArray.LONG.getRequiredBits(value) <= 35) {
                this.block.setSingleBlock(keyAndType | 0x10000000L | value << 29);
            } else {
                this.block.setValueBlocks(new long[]{keyAndType, value});
            }
        }

        public void writeFloatingPoint(float value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.FLOAT, Float.floatToRawIntBits(value));
        }

        public void writeFloatingPoint(double value) throws IllegalArgumentException {
            this.block.setValueBlocks(new long[]{(long)this.keyId | (long)PropertyType.DOUBLE.intValue() << 24, Double.doubleToRawLongBits(value)});
        }

        public void writeString(String value) throws IllegalArgumentException {
            if (LongerShortString.encode(this.keyId, value, this.block, PropertyType.getPayloadSize())) {
                return;
            }
            byte[] encodedString = PropertyStore.encodeString(value);
            HeapTrackingArrayList valueRecords = HeapTrackingCollections.newArrayList((int)(encodedString.length / this.stringAllocator.getRecordDataSize() + 1), (MemoryTracker)this.memoryTracker);
            PropertyStore.allocateStringRecords((Collection<DynamicRecord>)valueRecords, encodedString, this.stringAllocator, this.cursorContext, this.memoryTracker);
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.STRING, ((DynamicRecord)Iterables.first((Iterable)valueRecords)).getId());
            for (DynamicRecord valueRecord : valueRecords) {
                valueRecord.setType(PropertyType.STRING.intValue());
            }
            this.block.setValueRecords((List<DynamicRecord>)valueRecords);
        }

        public void writeString(char value) throws IllegalArgumentException {
            PropertyStore.setSingleBlockValue(this.block, this.keyId, PropertyType.CHAR, value);
        }

        public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void endArray() throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void writeByteArray(byte[] value) throws IllegalArgumentException {
            throw new IllegalArgumentException("Cannot persist arrays to property store using ValueWriter");
        }

        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IllegalArgumentException {
            this.block.setValueBlocks(GeometryType.encodePoint(this.keyId, crs, coordinate));
        }

        public void writeDuration(long months, long days, long seconds, int nanos) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeDuration(this.keyId, months, days, seconds, nanos));
        }

        public void writeDate(long epochDay) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeDate(this.keyId, epochDay));
        }

        public void writeLocalTime(long nanoOfDay) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeLocalTime(this.keyId, nanoOfDay));
        }

        public void writeTime(long nanosOfDayUTC, int offsetSeconds) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeTime(this.keyId, nanosOfDayUTC, offsetSeconds));
        }

        public void writeLocalDateTime(long epochSecond, int nano) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeLocalDateTime(this.keyId, epochSecond, nano));
        }

        public void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeDateTime(this.keyId, epochSecondUTC, (long)nano, offsetSeconds));
        }

        public void writeDateTime(long epochSecondUTC, int nano, String zoneId) throws IllegalArgumentException {
            this.block.setValueBlocks(TemporalType.encodeDateTime(this.keyId, epochSecondUTC, (long)nano, zoneId));
        }

        public void writeInt8Vector(byte[] values) throws RuntimeException {
            throw FeatureUnsupportedOnStoreFormatException.vectorsUnsupportedInRecordFormat((String)this.storeFormat);
        }

        public void writeInt16Vector(short[] values) throws RuntimeException {
            throw FeatureUnsupportedOnStoreFormatException.vectorsUnsupportedInRecordFormat((String)this.storeFormat);
        }

        public void writeInt32Vector(int[] values) throws RuntimeException {
            throw FeatureUnsupportedOnStoreFormatException.vectorsUnsupportedInRecordFormat((String)this.storeFormat);
        }

        public void writeInt64Vector(long[] values) throws RuntimeException {
            throw FeatureUnsupportedOnStoreFormatException.vectorsUnsupportedInRecordFormat((String)this.storeFormat);
        }

        public void writeFloat32Vector(float[] values) throws RuntimeException {
            throw FeatureUnsupportedOnStoreFormatException.vectorsUnsupportedInRecordFormat((String)this.storeFormat);
        }

        public void writeFloat64Vector(double[] values) throws RuntimeException {
            throw FeatureUnsupportedOnStoreFormatException.vectorsUnsupportedInRecordFormat((String)this.storeFormat);
        }
    }
}

