/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.util.BitBuffer;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum ShortArray {
    BOOLEAN(PropertyType.BOOL, 1, (Class)Boolean.class, (Class)Boolean.TYPE){

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            return 1;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (boolean value : (boolean[])array) {
                    result.put(value ? 1 : 0, 1);
                }
            } else {
                Boolean[] booleanArray = (Boolean[])array;
                int n = booleanArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean value = booleanArray[i];
                    result.put(value ? 1 : 0, 1);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_BOOLEAN_ARRAY;
            }
            boolean[] result = new boolean[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getByte(requiredBits) != 0;
            }
            return Values.booleanArray((boolean[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_BOOLEAN_ARRAY;
        }
    }
    ,
    BYTE(PropertyType.BYTE, 8, (Class)Byte.class, (Class)Byte.TYPE){

        int getRequiredBits(byte value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (byte value : (byte[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Byte[] byteArray = (Byte[])array;
                int n = byteArray.length;
                for (int i = 0; i < n; ++i) {
                    byte value = byteArray[i];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (byte b : (byte[])array) {
                    result.put(b, requiredBits);
                }
            } else {
                Byte[] byteArray = (Byte[])array;
                int n = byteArray.length;
                for (int i = 0; i < n; ++i) {
                    byte b = byteArray[i];
                    result.put(b, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_BYTE_ARRAY;
            }
            byte[] result = new byte[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getByte(requiredBits);
            }
            return Values.byteArray((byte[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_BYTE_ARRAY;
        }
    }
    ,
    SHORT(PropertyType.SHORT, 16, (Class)Short.class, (Class)Short.TYPE){

        int getRequiredBits(short value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (short value : (short[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Short[] shortArray = (Short[])array;
                int n = shortArray.length;
                for (int i = 0; i < n; ++i) {
                    short value = shortArray[i];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (short value : (short[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Short[] shortArray = (Short[])array;
                int n = shortArray.length;
                for (int i = 0; i < n; ++i) {
                    short value = shortArray[i];
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_SHORT_ARRAY;
            }
            short[] result = new short[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getShort(requiredBits);
            }
            return Values.shortArray((short[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_SHORT_ARRAY;
        }
    }
    ,
    CHAR(PropertyType.CHAR, 16, (Class)Character.class, (Class)Character.TYPE){

        int getRequiredBits(char value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (char value : (char[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Character[] characterArray = (Character[])array;
                int n = characterArray.length;
                for (int i = 0; i < n; ++i) {
                    char value = characterArray[i].charValue();
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (char value : (char[])array) {
                    result.put((int)value, requiredBits);
                }
            } else {
                Character[] characterArray = (Character[])array;
                int n = characterArray.length;
                for (int i = 0; i < n; ++i) {
                    char value = characterArray[i].charValue();
                    result.put((int)value, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_CHAR_ARRAY;
            }
            char[] result = new char[length];
            for (int i = 0; i < length; ++i) {
                result[i] = (char)bits.getShort(requiredBits);
            }
            return Values.charArray((char[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_CHAR_ARRAY;
        }
    }
    ,
    INT(PropertyType.INT, 32, (Class)Integer.class, (Class)Integer.TYPE){

        int getRequiredBits(int value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (int value : (int[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Integer[] integerArray = (Integer[])array;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int value = integerArray[i];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (int value : (int[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Integer[] integerArray = (Integer[])array;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int value = integerArray[i];
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_INT_ARRAY;
            }
            int[] result = new int[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getInt(requiredBits);
            }
            return Values.intArray((int[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_INT_ARRAY;
        }
    }
    ,
    LONG(PropertyType.LONG, 64, (Class)Long.class, (Class)Long.TYPE){

        @Override
        public int getRequiredBits(long value) {
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & value) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (long value : (long[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Long[] longArray = (Long[])array;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long value = longArray[i];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (long value : (long[])array) {
                    result.put(value, requiredBits);
                }
            } else {
                Long[] longArray = (Long[])array;
                int n = longArray.length;
                for (int i = 0; i < n; ++i) {
                    long value = longArray[i];
                    result.put(value, requiredBits);
                }
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_LONG_ARRAY;
            }
            long[] result = new long[length];
            for (int i = 0; i < length; ++i) {
                result[i] = bits.getLong(requiredBits);
            }
            return Values.longArray((long[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_LONG_ARRAY;
        }
    }
    ,
    FLOAT(PropertyType.FLOAT, 32, (Class)Float.class, (Class)Float.TYPE){

        int getRequiredBits(float value) {
            int v = Float.floatToIntBits(value);
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & (long)v) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (float value : (float[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Float[] floatArray = (Float[])array;
                int n = floatArray.length;
                for (int i = 0; i < n; ++i) {
                    float value = floatArray[i].floatValue();
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (float value : (float[])array) {
                    result.put(Float.floatToIntBits(value), requiredBits);
                }
            } else {
                Float[] floatArray = (Float[])array;
                int n = floatArray.length;
                for (int i = 0; i < n; ++i) {
                    float value = floatArray[i].floatValue();
                    result.put(Float.floatToIntBits(value), requiredBits);
                }
            }
        }

        @Override
        public void writeAll(Object array, byte[] result, int offset) {
            if (ShortArray.isPrimitive(array)) {
                float[] values = (float[])array;
                for (int i = 0; i < values.length; ++i) {
                    this.writeFloat(values[i], result, offset + i * 4);
                }
            } else {
                Float[] values = (Float[])array;
                for (int i = 0; i < values.length; ++i) {
                    this.writeFloat(values[i].floatValue(), result, offset + i * 4);
                }
            }
        }

        private void writeFloat(float floaValue, byte[] result, int offset) {
            long value = Float.floatToIntBits(floaValue);
            for (int b = 0; b < 4; ++b) {
                result[offset + b] = (byte)(value >> b * 8 & 0xFFL);
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_FLOAT_ARRAY;
            }
            float[] result = new float[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Float.intBitsToFloat(bits.getInt(requiredBits));
            }
            return Values.floatArray((float[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_FLOAT_ARRAY;
        }
    }
    ,
    DOUBLE(PropertyType.DOUBLE, 64, (Class)Double.class, (Class)Double.TYPE){

        int getRequiredBits(double value) {
            long v = Double.doubleToLongBits(value);
            long mask = 1L << this.maxBits - 1;
            int i = this.maxBits;
            while (i > 0) {
                if ((mask & v) != 0L) {
                    return i;
                }
                --i;
                mask >>= 1;
            }
            return 1;
        }

        @Override
        int getRequiredBits(Object array, int arrayLength) {
            int highest = 1;
            if (ShortArray.isPrimitive(array)) {
                for (double value : (double[])array) {
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            } else {
                Double[] doubleArray = (Double[])array;
                int n = doubleArray.length;
                for (int i = 0; i < n; ++i) {
                    double value = doubleArray[i];
                    highest = Math.max(this.getRequiredBits(value), highest);
                }
            }
            return highest;
        }

        @Override
        public void writeAll(Object array, int length, int requiredBits, BitBuffer result) {
            if (ShortArray.isPrimitive(array)) {
                for (double value : (double[])array) {
                    result.put(Double.doubleToLongBits(value), requiredBits);
                }
            } else {
                Double[] doubleArray = (Double[])array;
                int n = doubleArray.length;
                for (int i = 0; i < n; ++i) {
                    double value = doubleArray[i];
                    result.put(Double.doubleToLongBits(value), requiredBits);
                }
            }
        }

        @Override
        public void writeAll(Object array, byte[] result, int offset) {
            if (ShortArray.isPrimitive(array)) {
                double[] values = (double[])array;
                for (int i = 0; i < values.length; ++i) {
                    this.writeDouble(values[i], result, offset + i * 8);
                }
            } else {
                Double[] values = (Double[])array;
                for (int i = 0; i < values.length; ++i) {
                    this.writeDouble(values[i], result, offset + i * 8);
                }
            }
        }

        private void writeDouble(double doubleValue, byte[] result, int offset) {
            long value = Double.doubleToLongBits(doubleValue);
            for (int b = 0; b < 8; ++b) {
                result[offset + b] = (byte)(value >> b * 8 & 0xFFL);
            }
        }

        @Override
        public ArrayValue createArray(int length, BitBuffer bits, int requiredBits) {
            if (length == 0) {
                return Values.EMPTY_DOUBLE_ARRAY;
            }
            double[] result = new double[length];
            for (int i = 0; i < length; ++i) {
                result[i] = Double.longBitsToDouble(bits.getLong(requiredBits));
            }
            return Values.doubleArray((double[])result);
        }

        @Override
        public ArrayValue createEmptyArray() {
            return Values.EMPTY_DOUBLE_ARRAY;
        }
    };

    private static final ShortArray[] TYPES;
    private static final Map<Class<?>, ShortArray> all;
    final int maxBits;
    private final Class<?> boxedClass;
    private final Class<?> primitiveClass;
    private final PropertyType type;

    private static boolean isPrimitive(Object array) {
        return array.getClass().getComponentType().isPrimitive();
    }

    private ShortArray(PropertyType type, int maxBits, Class<?> boxedClass, Class<?> primitiveClass) {
        this.type = type;
        this.maxBits = maxBits;
        this.boxedClass = boxedClass;
        this.primitiveClass = primitiveClass;
    }

    public int intValue() {
        return this.type.intValue();
    }

    public abstract ArrayValue createArray(int var1, BitBuffer var2, int var3);

    public static boolean encode(int keyId, Object array, PropertyBlock target, int payloadSizeInBytes) {
        int arrayLength = Array.getLength(array);
        if (arrayLength > 63) {
            return false;
        }
        ShortArray type = ShortArray.typeOf(array);
        if (type == null) {
            return false;
        }
        int requiredBits = type.calculateRequiredBitsForArray(array, arrayLength);
        if (!ShortArray.willFit(requiredBits, arrayLength, payloadSizeInBytes)) {
            return false;
        }
        int numberOfBytes = ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits) * 8;
        if (BitBuffer.requiredLongs((int)numberOfBytes) > PropertyType.getPayloadSizeLongs()) {
            return false;
        }
        BitBuffer result = BitBuffer.bits((int)numberOfBytes);
        ShortArray.writeHeader(keyId, type, arrayLength, requiredBits, result);
        type.writeAll(array, arrayLength, requiredBits, result);
        target.setValueBlocks(result.getLongs());
        return true;
    }

    private static void writeHeader(int keyId, ShortArray type, int arrayLength, int requiredBits, BitBuffer result) {
        result.put(keyId, 24);
        result.put(PropertyType.SHORT_ARRAY.intValue(), 4);
        result.put(type.type.intValue(), 4);
        result.put(arrayLength, 6);
        result.put(requiredBits, 6);
    }

    public static Value decode(PropertyBlock block) {
        BitBuffer bits = BitBuffer.bitsFromLongs((long[])Arrays.copyOf(block.getValueBlocks(), block.getValueBlocks().length));
        return ShortArray.decode(bits);
    }

    public static Value decode(BitBuffer bits) {
        bits.getInt(24);
        bits.getByte(4);
        byte typeId = bits.getByte(4);
        byte arrayLength = bits.getByte(6);
        int requiredBits = bits.getByte(6);
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        ShortArray type = ShortArray.typeOf(typeId);
        return type.createArray(arrayLength, bits, requiredBits);
    }

    private static boolean willFit(int requiredBits, int arrayLength, int payloadSizeInBytes) {
        int totalBitsRequired = requiredBits * arrayLength;
        int maxBits = payloadSizeInBytes * 8 - 24 - 4 - 4 - 6 - 6;
        return totalBitsRequired <= maxBits;
    }

    public int calculateRequiredBitsForArray(Object array, int arrayLength) {
        if (arrayLength == 0) {
            return 0;
        }
        return this.getRequiredBits(array, arrayLength);
    }

    public int getRequiredBits(long value) {
        int highest = 1;
        long mask = 1L;
        int i = 1;
        while (i <= this.maxBits) {
            if ((mask & value) != 0L) {
                highest = i;
            }
            ++i;
            mask <<= 1;
        }
        return highest;
    }

    abstract int getRequiredBits(Object var1, int var2);

    public static ShortArray typeOf(byte typeId) {
        return TYPES[typeId - 1];
    }

    public static ShortArray typeOf(Object array) {
        return all.get(array.getClass().getComponentType());
    }

    public static int calculateNumberOfBlocksUsed(long firstBlock) {
        int highInt = (int)(firstBlock >>> 32);
        int arrayLength = highInt & 0x3F;
        int requiredBits = (highInt >>>= 6) & 0x3F;
        if (requiredBits == 0) {
            requiredBits = 64;
        }
        return ShortArray.calculateNumberOfBlocksUsed(arrayLength, requiredBits);
    }

    public static int calculateNumberOfBlocksUsed(int arrayLength, int requiredBits) {
        int bitsForItems = arrayLength * requiredBits;
        int totalBits = 44 + bitsForItems;
        return (totalBits - 1) / 64 + 1;
    }

    public abstract void writeAll(Object var1, int var2, int var3, BitBuffer var4);

    public void writeAll(Object array, byte[] result, int offset) {
        throw new IllegalStateException("Types that skip bit compaction should implement this method");
    }

    public abstract ArrayValue createEmptyArray();

    static {
        TYPES = ShortArray.values();
        all = new IdentityHashMap(TYPES.length * 2);
        for (ShortArray shortArray : TYPES) {
            all.put(shortArray.primitiveClass, shortArray);
            all.put(shortArray.boxedClass, shortArray);
        }
    }
}

