/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.cursor;

import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.cursor.AbstractCachedStoreCursors;
import org.neo4j.storageengine.api.cursor.CursorType;

public class CachedStoreCursors
extends AbstractCachedStoreCursors {
    private final NeoStores neoStores;

    public CachedStoreCursors(NeoStores neoStores, CursorContext cursorContext) {
        super(cursorContext, RecordCursorTypes.MAX_TYPE + 1);
        this.neoStores = neoStores;
    }

    public PageCursor writeCursor(CursorType type) {
        return switch (CachedStoreCursors.cast(type)) {
            default -> throw new MatchException(null, null);
            case RecordCursorTypes.NODE_CURSOR -> this.neoStores.getNodeStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.GROUP_CURSOR -> this.neoStores.getRelationshipGroupStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.SCHEMA_CURSOR -> this.neoStores.getSchemaStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.RELATIONSHIP_CURSOR -> this.neoStores.getRelationshipStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.PROPERTY_CURSOR -> this.neoStores.getPropertyStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR -> this.neoStores.getPropertyStore().getArrayStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_STRING_STORE_CURSOR -> this.neoStores.getPropertyStore().getStringStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_LABEL_STORE_CURSOR -> this.neoStores.getNodeStore().getDynamicLabelStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_REL_TYPE_TOKEN_CURSOR -> this.neoStores.getRelationshipTypeTokenStore().getNameStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.REL_TYPE_TOKEN_CURSOR -> this.neoStores.getRelationshipTypeTokenStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_PROPERTY_KEY_TOKEN_CURSOR -> this.neoStores.getPropertyKeyTokenStore().getNameStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR -> this.neoStores.getPropertyKeyTokenStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_LABEL_TOKEN_CURSOR -> this.neoStores.getLabelTokenStore().getNameStore().openPageCursorForWriting(0L, this.cursorContext);
            case RecordCursorTypes.LABEL_TOKEN_CURSOR -> this.neoStores.getLabelTokenStore().openPageCursorForWriting(0L, this.cursorContext);
        };
    }

    protected PageCursor createReadCursor(CursorType type) {
        return switch (CachedStoreCursors.cast(type)) {
            default -> throw new MatchException(null, null);
            case RecordCursorTypes.NODE_CURSOR -> this.neoStores.getNodeStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.GROUP_CURSOR -> this.neoStores.getRelationshipGroupStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.SCHEMA_CURSOR -> this.neoStores.getSchemaStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.RELATIONSHIP_CURSOR -> this.neoStores.getRelationshipStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.PROPERTY_CURSOR -> this.neoStores.getPropertyStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_ARRAY_STORE_CURSOR -> this.neoStores.getPropertyStore().getArrayStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_STRING_STORE_CURSOR -> this.neoStores.getPropertyStore().getStringStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_LABEL_STORE_CURSOR -> this.neoStores.getNodeStore().getDynamicLabelStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_REL_TYPE_TOKEN_CURSOR -> this.neoStores.getRelationshipTypeTokenStore().getNameStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.REL_TYPE_TOKEN_CURSOR -> this.neoStores.getRelationshipTypeTokenStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_PROPERTY_KEY_TOKEN_CURSOR -> this.neoStores.getPropertyKeyTokenStore().getNameStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR -> this.neoStores.getPropertyKeyTokenStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.DYNAMIC_LABEL_TOKEN_CURSOR -> this.neoStores.getLabelTokenStore().getNameStore().openPageCursorForReading(0L, this.cursorContext);
            case RecordCursorTypes.LABEL_TOKEN_CURSOR -> this.neoStores.getLabelTokenStore().openPageCursorForReading(0L, this.cursorContext);
        };
    }

    private static RecordCursorTypes cast(CursorType type) {
        if (type instanceof RecordCursorTypes) {
            return (RecordCursorTypes)type;
        }
        throw new IllegalArgumentException(String.format("%s(%s) is of incorrect type. Expected %s.", type, type.getClass().getSimpleName(), RecordCursorTypes.class.getSimpleName()));
    }
}

