/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.standard;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.format.BaseOneByteHeaderRecordFormat;
import org.neo4j.kernel.impl.store.format.BaseRecordFormat;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;

public class DynamicRecordFormat
extends BaseOneByteHeaderRecordFormat<DynamicRecord> {
    public static final int RECORD_HEADER_SIZE = 8;

    public DynamicRecordFormat() {
        this(false);
    }

    public DynamicRecordFormat(boolean pageAligned) {
        super(INT_STORE_HEADER_READER, 8, 16, 36, pageAligned);
    }

    @Override
    public DynamicRecord newRecord() {
        return new DynamicRecord(-1L);
    }

    @Override
    public void read(DynamicRecord record, PageCursor cursor, RecordLoad mode, int recordSize, int recordsPerPage, MemoryTracker memoryTracker) {
        boolean inUse;
        byte firstByte = cursor.getByte();
        boolean isStartRecord = (firstByte & 0x80) == 0;
        boolean bl = inUse = (firstByte & 0x10) != 0;
        if (mode.shouldLoad(inUse)) {
            int dataSize = recordSize - this.getRecordHeaderSize();
            int nrOfBytes = (cursor.getByte() & 0xFF) << 16 | (cursor.getByte() & 0xFF) << 8 | cursor.getByte() & 0xFF;
            if (nrOfBytes > dataSize) {
                cursor.setCursorException(DynamicRecordFormat.payloadTooBigErrorMessage(record, recordSize, nrOfBytes));
                return;
            }
            long nextBlock = (long)cursor.getInt() & 0xFFFFFFFFL;
            long nextModifier = ((long)firstByte & 0xFL) << 32;
            long longNextBlock = BaseRecordFormat.longFromIntAndMod(nextBlock, nextModifier);
            record.initialize(inUse, isStartRecord, longNextBlock, -1);
            DynamicRecordFormat.readData(record, cursor, nrOfBytes, memoryTracker);
            if (longNextBlock != (long)Record.NO_NEXT_BLOCK.intValue() && nrOfBytes != dataSize) {
                cursor.setCursorException(DynamicRecordFormat.illegalBlockSizeMessage(record, dataSize));
            }
        } else {
            record.setInUse(inUse);
        }
    }

    public static String payloadTooBigErrorMessage(DynamicRecord record, int recordSize, int nrOfBytes) {
        return String.format("DynamicRecord[%s] claims to have a payload of %s bytes, which is larger than the record size of %s bytes.", record.getId(), nrOfBytes, recordSize);
    }

    private static String illegalBlockSizeMessage(DynamicRecord record, int dataSize) {
        return String.format("Next block set[%d] current block illegal size[%d/%d]", record.getNextBlock(), record.getLength(), dataSize);
    }

    public static void readData(DynamicRecord record, PageCursor cursor, int len, MemoryTracker memoryTracker) {
        byte[] data = DynamicRecordFormat.prepareRecordDataArray(record, len, memoryTracker);
        cursor.getBytes(data);
    }

    private static byte[] prepareRecordDataArray(DynamicRecord record, int length, MemoryTracker memoryTracker) {
        byte[] data = record.getData();
        if (data != null && data.length == length) {
            return data;
        }
        memoryTracker.allocateHeap((long)length);
        byte[] newData = new byte[length];
        record.setData(newData);
        return newData;
    }

    @Override
    public void write(DynamicRecord record, PageCursor cursor, int recordSize, int recordsPerPage) {
        if (record.inUse()) {
            long nextBlock = record.getNextBlock();
            int highNextBlockBits = nextBlock == (long)Record.NO_NEXT_BLOCK.intValue() ? 0 : (int)((nextBlock & 0xF00000000L) >> 32);
            byte firstByte = (byte)(0x10 | (record.isStartRecord() ? 0 : 128) | highNextBlockBits);
            int recordLength = record.getLength();
            assert (recordLength < 0xFFFFFF);
            cursor.putByte(firstByte);
            cursor.putByte((byte)(recordLength >> 16 & 0xFF));
            cursor.putByte((byte)(recordLength >> 8 & 0xFF));
            cursor.putByte((byte)(recordLength & 0xFF));
            cursor.putInt((int)nextBlock);
            cursor.putBytes(record.getData());
        } else {
            cursor.putByte(Record.NOT_IN_USE.byteValue());
        }
    }

    @Override
    public long getNextRecordReference(DynamicRecord record) {
        return record.getNextBlock();
    }
}

