/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.configuration.Config;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.LegacyMetadataHandler;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.storageengine.api.MigrationStoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public class RecordStoreVersionCheck
implements StoreVersionCheck {
    private final PageCache pageCache;
    private final Path metaDataFile;
    private final Config config;
    private final String databaseName;

    public RecordStoreVersionCheck(PageCache pageCache, RecordDatabaseLayout databaseLayout, Config config) {
        this.pageCache = pageCache;
        this.metaDataFile = databaseLayout.metadataStore();
        this.databaseName = databaseLayout.getDatabaseName();
        this.config = config;
    }

    public boolean isCurrentStoreVersionFullySupported(CursorContext cursorContext) {
        StoreVersionIdentifier currentVersion;
        try {
            currentVersion = this.readVersion(cursorContext);
        }
        catch (Exception e) {
            return false;
        }
        return this.isStoreVersionFullySupported(currentVersion, cursorContext);
    }

    public boolean isStoreVersionFullySupported(StoreVersionIdentifier storeVersion, CursorContext cursorContext) {
        return RecordFormatSelector.selectForStoreVersionIdentifier(storeVersion).map(format -> !format.onlyForMigration()).orElse(false);
    }

    private StoreVersionIdentifier readVersion(CursorContext cursorContext) throws IOException {
        MetaDataStore.FieldAccess fieldAccess = MetaDataStore.getFieldAccess(this.pageCache, this.metaDataFile, this.databaseName, cursorContext);
        if (fieldAccess.isLegacyFieldValid()) {
            return fieldAccess.readStoreId();
        }
        return LegacyMetadataHandler.readMetadata44FromStore(this.pageCache, this.metaDataFile, this.databaseName, cursorContext).storeId();
    }

    public MigrationStoreVersionCheck.MigrationCheckResult getAndCheckMigrationTargetVersion(String formatFamily, CursorContext cursorContext) {
        RecordFormats formatToMigrateTo;
        RecordFormats formatToMigrateFrom;
        StoreVersionIdentifier currentVersion;
        try {
            currentVersion = this.readVersion(cursorContext);
            formatToMigrateFrom = RecordFormatSelector.selectForStoreVersionIdentifier(currentVersion).orElseThrow(() -> new IllegalArgumentException("Unknown store version '" + currentVersion.getStoreVersionUserString() + "'"));
        }
        catch (Exception e) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.STORE_VERSION_RETRIEVAL_FAILURE, null, null, e);
        }
        if (formatFamily == null) {
            formatFamily = formatToMigrateFrom.getFormatFamily().name();
        }
        if ((formatToMigrateTo = RecordFormatSelector.findLatestFormatInFamily(formatFamily, this.config)) == null) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_MIGRATION_PATH, currentVersion, null, null);
        }
        if (formatToMigrateTo.onlyForMigration()) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_TARGET_VERSION, currentVersion, this.versionIdentifier(formatToMigrateTo), null);
        }
        if (formatToMigrateFrom.equals(formatToMigrateTo)) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.NO_OP, currentVersion, this.versionIdentifier(formatToMigrateTo), null);
        }
        if (formatToMigrateFrom.getFormatFamily().isHigherThan(formatToMigrateTo.getFormatFamily())) {
            return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.UNSUPPORTED_MIGRATION_PATH, currentVersion, this.versionIdentifier(formatToMigrateTo), null);
        }
        return new MigrationStoreVersionCheck.MigrationCheckResult(MigrationStoreVersionCheck.MigrationOutcome.MIGRATION_POSSIBLE, currentVersion, this.versionIdentifier(formatToMigrateTo), null);
    }

    public StoreVersionIdentifier getCurrentVersion(CursorContext cursorContext) throws IOException, IllegalArgumentException, IllegalStateException {
        StoreVersionIdentifier currentVersion = this.readVersion(cursorContext);
        RecordFormats formatToMigrateFrom = RecordFormatSelector.selectForStoreVersionIdentifier(currentVersion).orElseThrow(() -> new IllegalArgumentException("Unknown store version '" + currentVersion.getStoreVersionUserString() + "'"));
        return this.versionIdentifier(formatToMigrateFrom);
    }

    public StoreVersionCheck.UpgradeCheckResult getAndCheckUpgradeTargetVersion(CursorContext cursorContext) {
        RecordFormats formatToUpgradeFrom;
        StoreVersionIdentifier currentVersion;
        try {
            currentVersion = this.readVersion(cursorContext);
            formatToUpgradeFrom = RecordFormatSelector.selectForStoreVersionIdentifier(currentVersion).orElseThrow(() -> new IllegalArgumentException("Unknown store version '" + currentVersion.getStoreVersionUserString() + "'"));
        }
        catch (Exception e) {
            return new StoreVersionCheck.UpgradeCheckResult(StoreVersionCheck.UpgradeOutcome.STORE_VERSION_RETRIEVAL_FAILURE, null, null, e);
        }
        RecordFormats formatToUpgradeTo = RecordFormatSelector.findLatestMinorVersion(formatToUpgradeFrom, this.config);
        if (formatToUpgradeTo.onlyForMigration()) {
            return new StoreVersionCheck.UpgradeCheckResult(StoreVersionCheck.UpgradeOutcome.UNSUPPORTED_TARGET_VERSION, currentVersion, formatToUpgradeTo.equals(formatToUpgradeFrom) ? currentVersion : this.versionIdentifier(formatToUpgradeTo), null);
        }
        if (formatToUpgradeFrom.equals(formatToUpgradeTo)) {
            return new StoreVersionCheck.UpgradeCheckResult(StoreVersionCheck.UpgradeOutcome.NO_OP, currentVersion, this.versionIdentifier(formatToUpgradeTo), null);
        }
        return new StoreVersionCheck.UpgradeCheckResult(StoreVersionCheck.UpgradeOutcome.UPGRADE_POSSIBLE, currentVersion, this.versionIdentifier(formatToUpgradeTo), null);
    }

    public String getIntroductionVersionFromVersion(StoreVersionIdentifier versionIdentifier) {
        return RecordFormatSelector.selectForStoreVersionIdentifier(versionIdentifier).orElseThrow(() -> new IllegalArgumentException("Unknown store version '" + versionIdentifier.getStoreVersionUserString() + "'")).introductionVersion();
    }

    public StoreVersionIdentifier findLatestVersion(String format) {
        return this.versionIdentifier(RecordFormatSelector.findLatestFormatInFamily(format, this.config));
    }

    private StoreVersionIdentifier versionIdentifier(RecordFormats format) {
        return new StoreVersionIdentifier("record", format.getFormatFamily().name(), format.majorVersion(), format.minorVersion());
    }
}

