/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.stats;

import org.neo4j.io.pagecache.PageCursor;

class IndexStatisticsValue {
    static final int NUM_LONGS = 4;
    static final int SIZE = 256;
    static final int INDEX_SAMPLE_UNIQUE_VALUES = 0;
    static final int INDEX_SAMPLE_SIZE = 1;
    static final int INDEX_SAMPLE_UPDATES_COUNT = 2;
    static final int INDEX_SAMPLE_INDEX_SIZE = 3;
    static final int INDEX_USAGE_LAST_READ = 0;
    static final int INDEX_USAGE_READ_COUNT = 1;
    static final int INDEX_USAGE_TRACKED_SINCE = 2;
    final long[] data = new long[4];

    IndexStatisticsValue() {
    }

    void set(int dataIndex, long value) {
        this.data[dataIndex] = value;
    }

    long get(int dataIndex) {
        return this.data[dataIndex];
    }

    IndexStatisticsValue copy() {
        IndexStatisticsValue copy = new IndexStatisticsValue();
        System.arraycopy(this.data, 0, copy.data, 0, 4);
        return copy;
    }

    void write(PageCursor cursor) {
        for (int i = 0; i < 4; ++i) {
            cursor.putLong(this.data[i]);
        }
    }

    void read(PageCursor cursor) {
        for (int i = 0; i < 4; ++i) {
            this.data[i] = cursor.getLong();
        }
    }
}

