/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class HighestAppendBatch {
    private final AtomicReference<AppendBatchInfo> highest = new AtomicReference();

    public HighestAppendBatch(AppendBatchInfo appendBatchInfo) {
        this.highest.set(appendBatchInfo);
    }

    public void offer(long appendIndex, LogPosition logPositionAfter) {
        AppendBatchInfo high = this.highest.getAcquire();
        if (appendIndex < high.appendIndex()) {
            return;
        }
        AppendBatchInfo update = new AppendBatchInfo(appendIndex, logPositionAfter);
        while (!this.highest.weakCompareAndSetRelease(high, update)) {
            high = this.highest.getAcquire();
            if (high.appendIndex() < appendIndex) continue;
            return;
        }
    }

    public final void set(long appendIndex, LogPosition logPositionAfter) {
        this.highest.set(new AppendBatchInfo(appendIndex, logPositionAfter));
    }

    public AppendBatchInfo get() {
        return this.highest.get();
    }
}

