/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.transaction;

import java.util.Map;
import java.util.Optional;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.router.impl.transaction.RouterTransactionManager;
import org.neo4j.router.transaction.RouterTransaction;

public class TransactionLookup {
    private final RouterTransactionManager routerTransactionManager;
    private final TransactionManager maybeCompositeTransactionManager;

    public TransactionLookup(RouterTransactionManager routerTransactionManager, TransactionManager maybeCompositeTransactionManager) {
        this.routerTransactionManager = routerTransactionManager;
        this.maybeCompositeTransactionManager = maybeCompositeTransactionManager;
    }

    public Optional<Transaction> findTransactionContaining(InternalTransaction transaction) {
        Optional<RouterTransaction> routerTransaction = this.routerTransactionManager.findTransactionContaining(transaction);
        if (routerTransaction.isPresent()) {
            return routerTransaction.map(tx -> tx::setMetaData);
        }
        if (this.maybeCompositeTransactionManager != null) {
            return this.maybeCompositeTransactionManager.findTransactionContaining(transaction).map(tx -> arg_0 -> ((FabricTransaction)tx).setMetaData(arg_0));
        }
        return Optional.empty();
    }

    public static interface Transaction {
        public void setMetaData(Map<String, Object> var1);
    }
}

