/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.time.Duration;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.graphdb.config.Setting;

@PublicApi
public class FulltextSettings
implements SettingsDeclaration {
    private static final String DEFAULT_ANALYZER = "standard-no-stop-words";
    @Description(value="The name of the analyzer that the full-text indexes should use by default.")
    public static final Setting<String> fulltext_default_analyzer = SettingImpl.newBuilder((String)"db.index.fulltext.default_analyzer", (SettingValueParser)SettingValueParsers.STRING, (Object)"standard-no-stop-words").build();
    @Description(value="Whether or not full-text indexes should be eventually consistent by default or not.")
    public static final Setting<Boolean> eventually_consistent = SettingImpl.newBuilder((String)"db.index.fulltext.eventually_consistent", (SettingValueParser)SettingValueParsers.BOOL, (Object)false).build();
    @Description(value="The number of threads processing queued index updates for eventually consistent full-text indexes.")
    public static final Setting<Integer> eventually_consistent_apply_parallelism = SettingImpl.newBuilder((String)"db.index.fulltext.eventually_consistent_apply_parallelism", (SettingValueParser)SettingValueParsers.INT, (Object)1).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).build();
    @Description(value="How often an eventually consistent full-text index is refreshed (changes are guaranteed to be visible). If set to `0`, refresh is done by the threads applying eventually consistent full-text index updates.")
    public static final Setting<Duration> eventually_consistent_refresh_interval = SettingImpl.newBuilder((String)"db.index.fulltext.eventually_consistent_refresh_interval", (SettingValueParser)SettingValueParsers.DURATION, (Object)Duration.ofSeconds(0L)).build();
    @Description(value="The number of threads that can do full-text index refresh in parallel,i.e. the number of eventually consistent full-text indexes that can be refreshed in parallel.")
    public static final Setting<Integer> eventually_consistent_refresh_parallelism = SettingImpl.newBuilder((String)"db.index.fulltext.eventually_consistent_refresh_parallelism", (SettingValueParser)SettingValueParsers.INT, (Object)1).addConstraint(SettingConstraints.min((Comparable)Integer.valueOf(1))).build();
    @Description(value="The eventually_consistent mode of the full-text indexes works by queueing up index updates to be applied later in a background thread. This newBuilder sets an upper bound on how many index updates are allowed to be in this queue at any one point in time. When it is reached, the commit process will slow down and wait for the index update applier thread to make some more room in the queue.")
    public static final Setting<Integer> eventually_consistent_index_update_queue_max_length = SettingImpl.newBuilder((String)"db.index.fulltext.eventually_consistent_index_update_queue_max_length", (SettingValueParser)SettingValueParsers.INT, (Object)10000).addConstraint(SettingConstraints.range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(50000000))).build();
}

