/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.api.impl.index.AbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.schema.writer.LucenePartitionIndexWriter;
import org.neo4j.kernel.api.index.ValueIndexReader;

public class WritableDatabaseIndex<INDEX extends AbstractLuceneIndex<READER>, READER extends ValueIndexReader>
extends AbstractDatabaseIndex<INDEX, READER> {
    private final ReentrantLock commitCloseLock = new ReentrantLock();
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final boolean permanentlyReadOnly;

    public WritableDatabaseIndex(INDEX luceneIndex, DatabaseReadOnlyChecker readOnlyChecker, boolean permanentlyReadOnly) {
        super(luceneIndex);
        this.readOnlyChecker = readOnlyChecker;
        this.permanentlyReadOnly = permanentlyReadOnly;
    }

    @Override
    public void create() throws IOException {
        this.luceneIndex.create();
    }

    @Override
    public boolean isPermanentlyOnly() {
        return this.permanentlyReadOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.permanentlyReadOnly || this.readOnlyChecker.isReadOnly();
    }

    @Override
    public void drop() {
        this.commitCloseLock.lock();
        try {
            this.luceneIndex.drop();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.commitCloseLock.lock();
        try {
            this.commitLockedFlush();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    protected void commitLockedFlush() throws IOException {
        this.luceneIndex.flush(false);
    }

    @Override
    public void close() throws IOException {
        this.commitCloseLock.lock();
        try {
            this.commitLockedClose();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    protected void commitLockedClose() throws IOException {
        this.luceneIndex.close();
    }

    @Override
    public ResourceIterator<Path> snapshotFiles() throws IOException {
        this.commitCloseLock.lock();
        try {
            ResourceIterator<Path> resourceIterator = this.luceneIndex.snapshotFiles();
            return resourceIterator;
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public void maybeRefreshBlocking() throws IOException {
        this.luceneIndex.maybeRefreshBlocking();
    }

    public AbstractIndexPartition addNewPartition() throws IOException {
        return this.luceneIndex.addNewPartition();
    }

    @Override
    public void markAsOnline() throws IOException {
        this.commitCloseLock.lock();
        try {
            this.luceneIndex.markAsOnline();
        }
        finally {
            this.commitCloseLock.unlock();
        }
    }

    @Override
    public LucenePartitionIndexWriter getIndexWriter() {
        return this.luceneIndex.getIndexWriter(this);
    }

    public static boolean hasSinglePartition(List<AbstractIndexPartition> partitions) {
        return AbstractLuceneIndex.hasSinglePartition(partitions);
    }

    public static AbstractIndexPartition getFirstPartition(List<AbstractIndexPartition> partitions) {
        return AbstractLuceneIndex.getFirstPartition(partitions);
    }
}

