/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.LuceneDocumentRetrievalException;
import org.neo4j.kernel.api.impl.index.lucene.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10IndexSearcher;

class Lucene10AllDocumentsReader
implements LuceneAllDocumentsReader {
    private final Lucene10IndexSearcher searcher;
    private final IndexReader reader;

    Lucene10AllDocumentsReader(Lucene10IndexSearcher searcher) {
        this.searcher = searcher;
        this.reader = searcher.getIndexReader();
    }

    public long maxCount() {
        return this.reader.maxDoc();
    }

    public Iterator<LuceneDocument> iterator() {
        return this.documentIterator(this.iterateAllDocs());
    }

    @Override
    public Iterator<LuceneDocument> iterator(int from, int to) {
        return this.documentIterator(this.iterateDocs(from, to));
    }

    private Iterator<LuceneDocument> documentIterator(final DocIdSetIterator idIterator) {
        return new PrefetchingIterator<LuceneDocument>(){

            protected LuceneDocument fetchNextOrNull() {
                try {
                    int doc = idIterator.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        return null;
                    }
                    return Lucene10AllDocumentsReader.this.getDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneDocumentRetrievalException("Can't fetch document id from lucene index.", e);
                }
            }
        };
    }

    public void close() throws IOException {
    }

    private LuceneDocument getDocument(int docId) {
        try {
            return this.searcher.doc(docId);
        }
        catch (IOException e) {
            throw new LuceneDocumentRetrievalException("Can't retrieve document with id: " + docId + ".", docId, e);
        }
    }

    private DocIdSetIterator iterateAllDocs() {
        return this.filterRemovals(DocIdSetIterator.all((int)this.reader.maxDoc()));
    }

    private DocIdSetIterator iterateDocs(int from, int to) {
        return from == to ? DocIdSetIterator.empty() : this.filterRemovals(DocIdSetIterator.range((int)from, (int)to));
    }

    private DocIdSetIterator filterRemovals(DocIdSetIterator docs) {
        if (!this.reader.hasDeletions()) {
            return docs;
        }
        return new FilteredDocIdSetIterator(docs){
            private final Bits liveDocs;
            {
                this.liveDocs = MultiBits.getLiveDocs((IndexReader)Lucene10AllDocumentsReader.this.reader);
            }

            protected boolean match(int doc) {
                return this.liveDocs.get(doc);
            }
        };
    }
}

