/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Version;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10DirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10IndexWriter;

public class Lucene10Directory
implements LuceneDirectory {
    final Directory directory;

    public Lucene10Directory(Directory directory) {
        this.directory = directory;
    }

    @Override
    public String[] listAll() throws IOException {
        return this.directory.listAll();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.directory.deleteFile(name);
    }

    @Override
    public boolean indexExists() throws IOException {
        return DirectoryReader.indexExists((Directory)this.directory);
    }

    @Override
    public LuceneDirectoryReader open() throws IOException {
        return new Lucene10DirectoryReader(DirectoryReader.open((Directory)this.directory));
    }

    @Override
    public boolean checkIndexIsClean() throws IOException {
        try (CheckIndex checkIndex = new CheckIndex(this.directory);){
            CheckIndex.Status status = checkIndex.checkIndex();
            boolean bl = status.clean;
            return bl;
        }
    }

    @Override
    public boolean validVersion() throws IOException {
        int createdMajorVersion = (Integer)new CreatedMajorVersion().run();
        return Version.MIN_SUPPORTED_MAJOR <= createdMajorVersion && createdMajorVersion <= Version.LATEST.major;
    }

    @Override
    public boolean hasCommits() throws IOException {
        return this.indexExists() && SegmentInfos.readLatestCommit((Directory)this.directory) != null;
    }

    @Override
    public Collection<String> latestCommitFileNames() throws IOException {
        return ((IndexCommit)DirectoryReader.listCommits((Directory)this.directory).getLast()).getFileNames();
    }

    @Override
    public LuceneIndexWriter newWriter(LuceneIndexWriterConfig writerConfig) throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.directory, Lucene10Directory.convertConfig(writerConfig));
        return new Lucene10IndexWriter(indexWriter);
    }

    @Override
    public LuceneContext getLuceneContext() {
        return LuceneContext.LUCENE_10;
    }

    @Override
    public void close() throws IOException {
        this.directory.close();
    }

    byte[] readFile(String name) throws IOException {
        try (IndexInput in = this.directory.openInput(name, IOContext.DEFAULT);){
            byte[] bytes = new byte[Math.toIntExact(in.length())];
            in.readBytes(bytes, 0, bytes.length);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    private static IndexWriterConfig convertConfig(LuceneIndexWriterConfig config) {
        if (config.analyzerOnly) {
            return new IndexWriterConfig(config.analyzer);
        }
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(config.analyzer);
        if (config.RAMBufferSizeMB != null) {
            indexWriterConfig.setRAMBufferSizeMB(config.RAMBufferSizeMB.doubleValue());
        }
        if (config.maxBufferedDocs != null) {
            indexWriterConfig.setMaxBufferedDocs(config.maxBufferedDocs.intValue());
        }
        indexWriterConfig.setCommitOnClose(true);
        indexWriterConfig.setUseCompoundFile(true);
        indexWriterConfig.setMaxFullFlushMergeWaitMillis(0L);
        indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        if (config.codec != null) {
            indexWriterConfig.setCodec(config.codec);
        }
        if (config.useOnThreadConcurrentMergeScheduler) {
            indexWriterConfig.setMergeScheduler((MergeScheduler)new OnThreadConcurrentMergeScheduler());
        }
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(config.noCFSRatio);
        mergePolicy.setMinMergeMB(config.minMergeMB);
        mergePolicy.setMaxMergeMB(config.maxMergeMB);
        mergePolicy.setMergeFactor(config.mergeFactor);
        indexWriterConfig.setMergePolicy((MergePolicy)mergePolicy);
        return indexWriterConfig;
    }

    private final class CreatedMajorVersion
    extends SegmentInfos.FindSegmentsFile<Integer> {
        private CreatedMajorVersion() {
            super(Lucene10Directory.this.directory);
        }

        protected Integer doBody(String segmentFileName) throws IOException {
            try (IndexInput input = Lucene10Directory.this.directory.openInput(segmentFileName, IOContext.DEFAULT);){
                CodecUtil.readIndexHeader((IndexInput)input);
                input.readVInt();
                input.readVInt();
                input.readVInt();
                Integer n = input.readVInt();
                return n;
            }
        }
    }

    static class OnThreadConcurrentMergeScheduler
    extends MergeScheduler {
        OnThreadConcurrentMergeScheduler() {
        }

        public void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
            MergePolicy.OneMerge merge;
            while ((merge = this.nextMergeSynchronized(mergeSource)) != null) {
                mergeSource.merge(merge);
            }
        }

        private synchronized MergePolicy.OneMerge nextMergeSynchronized(MergeScheduler.MergeSource mergeSource) {
            return mergeSource.getNextMerge();
        }

        public void close() {
        }
    }
}

