/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSearcherManager;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10IndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10SearcherManager;

public class Lucene10DirectoryReader
implements LuceneDirectoryReader {
    private static final SearcherFactory SEARCHER_FACTORY = new SearcherFactory();
    private final DirectoryReader reader;

    public Lucene10DirectoryReader(DirectoryReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean isOnline() throws IOException {
        return "online".equals(this.reader.getIndexCommit().getUserData().get("status"));
    }

    @Override
    public LuceneSearcherManager newSearcherManager() throws IOException {
        SearcherManager searcherManager = new SearcherManager(this.reader, SEARCHER_FACTORY);
        return new Lucene10SearcherManager(searcherManager);
    }

    @Override
    public LuceneIndexSearcher newDirectSearcher() {
        return new Lucene10IndexSearcher(new IndexSearcher((IndexReader)this.reader));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

