/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocumentsFactory;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10Document;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10ReusableDocWithId;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10TrigramTokenStream;
import org.neo4j.kernel.api.impl.schema.vector.Neo4jVectorSimilarityFunction;
import org.neo4j.kernel.api.impl.schema.vector.VectorDocumentStructure;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class Lucene10DocumentsFactory
implements LuceneDocumentsFactory {
    public static final LuceneDocumentsFactory INSTANCE = new Lucene10DocumentsFactory();

    @Override
    public LuceneDocument newDocument() {
        return new Lucene10Document();
    }

    @Override
    public LuceneDocument reusableTextDocument(long id, Value ... values) {
        return Lucene10ReusableDocWithId.reusableTextDocument(id, values);
    }

    @Override
    public LuceneDocument reusableFulltextDocument(long id, String[] propertyNames, Value[] values) {
        return Lucene10ReusableDocWithId.reusableFulltextDocument(id, propertyNames, values);
    }

    @Override
    public LuceneDocument createTrigramDocument(long id, Value value) {
        Lucene10Document document = new Lucene10Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        if (value.valueGroup() == ValueGroup.TEXT) {
            Lucene10TrigramTokenStream tokenStream = new Lucene10TrigramTokenStream(value.asObject().toString());
            TrigramField valueField = new TrigramField("0", tokenStream);
            document.document.add((IndexableField)valueField);
        }
        return document;
    }

    @Override
    public LuceneDocument createVectorDocument(VectorDocumentStructure vectorDocumentStructure, long id, VectorCandidate candidate, Neo4jVectorSimilarityFunction similarityFunction) {
        float[] vector = similarityFunction.maybeToValidVector(candidate);
        if (vector == null) {
            return null;
        }
        Lucene10Document document = new Lucene10Document();
        document.addStringField("id", Long.toString(id), false);
        document.addNumericField("id", id);
        document.addKnnFloatVectorField(vectorDocumentStructure.vectorValueKeyFor(vector.length), vector, similarityFunction);
        return document;
    }

    private static class TrigramField
    extends Field {
        private static final FieldType TYPE = new FieldType();

        private TrigramField(String name, TokenStream tokenStream) {
            super(name, tokenStream, (IndexableFieldType)TYPE);
        }

        static {
            TYPE.setOmitNorms(true);
            TYPE.setIndexOptions(IndexOptions.DOCS);
            TYPE.setTokenized(true);
            TYPE.setStored(false);
            TYPE.freeze();
        }
    }
}

