/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.index.collector.ScoredEntityIterator;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.kernel.api.impl.index.lucene.LuceneAllDocumentsReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDocument;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexSearcher;
import org.neo4j.kernel.api.impl.index.lucene.LucenePartitionedSearch;
import org.neo4j.kernel.api.impl.index.lucene.LuceneQueryContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneSearcherManager;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10AllDocumentsReader;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10DocValuesCollector;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10Document;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10IndexSampler;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10PartitionedSearch;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10QueryContext;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10ScoredEntityResultCollector;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10SearcherManager;
import org.neo4j.kernel.api.impl.index.lucene.v10.Lucene10VectorResultCollector;
import org.neo4j.kernel.api.impl.schema.TaskCoordinator;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;

class Lucene10IndexSearcher
implements LuceneIndexSearcher {
    final IndexSearcher indexSearcher;
    private final ReferenceManager<IndexSearcher> referenceManager;

    Lucene10IndexSearcher(LuceneSearcherManager searcherManager) throws IOException {
        this.referenceManager = ((Lucene10SearcherManager)searcherManager).searcherManager;
        this.indexSearcher = (IndexSearcher)this.referenceManager.acquire();
        this.indexSearcher.setQueryCache(null);
    }

    Lucene10IndexSearcher(IndexSearcher indexSearcher) {
        this.referenceManager = null;
        this.indexSearcher = indexSearcher;
    }

    IndexReader getIndexReader() {
        return this.indexSearcher.getIndexReader();
    }

    @Override
    public LuceneDocument doc(int docId) throws IOException {
        return new Lucene10Document(this.indexSearcher.storedFields().document(docId));
    }

    @Override
    public IndexProgressor searchDocValues(LuceneQueryContext queryContext, String field, LuceneIndexSearcher.EntityConsumer entityConsumer) throws IOException {
        return (IndexProgressor)this.indexSearcher.search(Lucene10IndexSearcher.toInternal(queryContext), (CollectorManager)new DocValuesCollectorManager(c -> c.getIndexProgressor(field, entityConsumer)));
    }

    @Override
    public IndexProgressor searchDocValues(LuceneQueryContext queryContext, String field, IndexProgressor.EntityValueClient client) throws IOException {
        return (IndexProgressor)this.indexSearcher.search(Lucene10IndexSearcher.toInternal(queryContext), (CollectorManager)new DocValuesCollectorManager(c -> c.getIndexProgressor(field, client)));
    }

    @Override
    public ValuesIterator searchVectors(LuceneQueryContext queryContext, IndexQueryConstraints constraints) throws IOException {
        return (ValuesIterator)this.indexSearcher.search(Lucene10IndexSearcher.toInternal(queryContext), (CollectorManager)new VectorValuesCollectorManager(constraints));
    }

    @Override
    public List<LuceneDocument> searchTopN(LuceneQueryContext queryContext, int n) throws IOException {
        TopDocs search = this.indexSearcher.search(Lucene10IndexSearcher.toInternal(queryContext), n);
        ScoreDoc[] scoreDocs = search.scoreDocs;
        ArrayList<LuceneDocument> results = new ArrayList<LuceneDocument>(scoreDocs.length);
        for (ScoreDoc scoreDoc : scoreDocs) {
            results.add(this.doc(scoreDoc.doc));
        }
        return results;
    }

    @Override
    public int count(LuceneQueryContext queryContext) throws IOException {
        return this.indexSearcher.count(Lucene10IndexSearcher.toInternal(queryContext));
    }

    @Override
    public LuceneQueryContext newQueryContext() {
        return new Lucene10QueryContext();
    }

    @Override
    public LuceneQueryContext rewrite(LuceneQueryContext queryContext) throws IOException {
        Query rewrite;
        Query originalQuery = Lucene10IndexSearcher.toInternal(queryContext);
        if (originalQuery == (rewrite = this.indexSearcher.rewrite(originalQuery))) {
            return queryContext;
        }
        return Lucene10QueryContext.wrap(rewrite);
    }

    @Override
    public void close() throws IOException {
        if (this.referenceManager != null) {
            this.referenceManager.release((Object)this.indexSearcher);
        }
    }

    @Override
    public LucenePartitionedSearch newPartitionedSearcher(int size) {
        return new Lucene10PartitionedSearch(size);
    }

    @Override
    public LuceneAllDocumentsReader newAllDocumentsReader() {
        return new Lucene10AllDocumentsReader(this);
    }

    @Override
    public int numDocs() {
        return this.indexSearcher.getIndexReader().numDocs();
    }

    @Override
    public IndexSampler newIndexSampler(TaskCoordinator taskCoordinator, IndexSamplingConfig samplingConfig) {
        return new Lucene10IndexSampler(this, taskCoordinator, samplingConfig);
    }

    private static Query toInternal(LuceneQueryContext queryContext) {
        return ((Lucene10QueryContext)queryContext).build();
    }

    private static class DocValuesCollectorManager
    implements CollectorManager<Lucene10DocValuesCollector, IndexProgressor> {
        private final Function<Lucene10DocValuesCollector, IndexProgressor> progressFactory;

        public DocValuesCollectorManager(Function<Lucene10DocValuesCollector, IndexProgressor> progressFactory) {
            this.progressFactory = progressFactory;
        }

        public Lucene10DocValuesCollector newCollector() {
            return new Lucene10DocValuesCollector();
        }

        public IndexProgressor reduce(Collection<Lucene10DocValuesCollector> collectors) {
            List<IndexProgressor> list = collectors.stream().map(this.progressFactory).toList();
            return new IndexProgressor.ConcatenatingIndexProgressor(list);
        }
    }

    private static class VectorValuesCollectorManager
    implements CollectorManager<Lucene10VectorResultCollector, ValuesIterator> {
        private final IndexQueryConstraints constraints;

        private VectorValuesCollectorManager(IndexQueryConstraints constraints) {
            this.constraints = constraints;
        }

        public Lucene10VectorResultCollector newCollector() {
            return new Lucene10VectorResultCollector(this.constraints);
        }

        public ValuesIterator reduce(Collection<Lucene10VectorResultCollector> collectors) {
            return ScoredEntityIterator.mergeIterators(collectors.stream().map(Lucene10ScoredEntityResultCollector::iterator).toList());
        }
    }
}

