/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10.codec;

import org.apache.lucene.backward_codecs.lucene912.Lucene912Codec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.neo4j.kernel.api.impl.index.lucene.v10.codec.LuceneKnnScalarQuantizedVectorFormatV2;
import org.neo4j.kernel.api.impl.index.lucene.v10.codec.LuceneKnnVectorFormatV2;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;

public class VectorCodecV2
extends Lucene912Codec {
    private final KnnVectorsFormat vectorFormat;
    private final VectorIndexConfig config;

    public VectorCodecV2(VectorIndexConfig config) {
        this.config = config;
        int dimensions = config.dimensions().orElseGet(() -> config.version().maxDimensions());
        this.vectorFormat = config.quantizationEnabled() ? new LuceneKnnScalarQuantizedVectorFormatV2(dimensions, config.hnsw()) : new LuceneKnnVectorFormatV2(dimensions, config.hnsw());
    }

    public VectorIndexConfig getConfig() {
        return this.config;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        return this.vectorFormat;
    }
}

