/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v10.codec;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.lucene101.Lucene101Codec;
import org.neo4j.kernel.api.impl.index.lucene.v10.codec.LuceneKnnScalarQuantizedVectorFormatV2;
import org.neo4j.kernel.api.impl.index.lucene.v10.codec.LuceneKnnVectorFormatV2;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;

public class VectorCodecV3
extends FilterCodec {
    private static final String CODEC_NAME = "VectorCodecV3";
    private final KnnVectorsFormat vectorFormat;
    private final VectorIndexConfig config;

    public VectorCodecV3() {
        this(VectorIndexConfig.EMPTY);
    }

    public VectorCodecV3(VectorIndexConfig config) {
        super(CODEC_NAME, (Codec)new Lucene101Codec());
        this.config = config;
        int dimensions = config.dimensions().orElseGet(() -> config.version().maxDimensions());
        this.vectorFormat = config.quantizationEnabled() ? new LuceneKnnScalarQuantizedVectorFormatV2(dimensions, config.hnsw()) : new LuceneKnnVectorFormatV2(dimensions, config.hnsw());
    }

    public VectorIndexConfig getConfig() {
        return this.config;
    }

    public KnnVectorsFormat knnVectorsFormat() {
        return this.vectorFormat;
    }
}

