/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.kernel.api.impl.index.lucene.LuceneContext;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectory;
import org.neo4j.kernel.api.impl.index.lucene.LuceneDirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.LuceneIndexWriterConfig;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9DirectoryReader;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9IndexWriter;
import org.neo4j.kernel.api.impl.index.lucene.v9.Lucene9Utils;
import org.neo4j.kernel.api.impl.index.lucene.v9.codec.VectorCodecV1;
import org.neo4j.kernel.api.impl.index.lucene.v9.codec.VectorCodecV2;
import org.neo4j.shaded.lucene9.codecs.Codec;
import org.neo4j.shaded.lucene9.codecs.CodecUtil;
import org.neo4j.shaded.lucene9.index.CheckIndex;
import org.neo4j.shaded.lucene9.index.DirectoryReader;
import org.neo4j.shaded.lucene9.index.IndexCommit;
import org.neo4j.shaded.lucene9.index.IndexDeletionPolicy;
import org.neo4j.shaded.lucene9.index.IndexWriter;
import org.neo4j.shaded.lucene9.index.IndexWriterConfig;
import org.neo4j.shaded.lucene9.index.KeepOnlyLastCommitDeletionPolicy;
import org.neo4j.shaded.lucene9.index.LogByteSizeMergePolicy;
import org.neo4j.shaded.lucene9.index.MergePolicy;
import org.neo4j.shaded.lucene9.index.MergeScheduler;
import org.neo4j.shaded.lucene9.index.MergeTrigger;
import org.neo4j.shaded.lucene9.index.SegmentInfos;
import org.neo4j.shaded.lucene9.index.SnapshotDeletionPolicy;
import org.neo4j.shaded.lucene9.store.Directory;
import org.neo4j.shaded.lucene9.store.IOContext;
import org.neo4j.shaded.lucene9.store.IndexInput;
import org.neo4j.shaded.lucene9.util.Version;

public class Lucene9Directory
implements LuceneDirectory {
    final Directory directory;

    public Lucene9Directory(Directory directory) {
        this.directory = directory;
    }

    @Override
    public String[] listAll() throws IOException {
        return this.directory.listAll();
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.directory.deleteFile(name);
    }

    @Override
    public boolean indexExists() throws IOException {
        return DirectoryReader.indexExists((Directory)this.directory);
    }

    @Override
    public LuceneDirectoryReader open() throws IOException {
        return new Lucene9DirectoryReader(DirectoryReader.open((Directory)this.directory));
    }

    @Override
    public boolean checkIndexIsClean() throws IOException {
        try (CheckIndex checkIndex = new CheckIndex(this.directory);){
            CheckIndex.Status status = checkIndex.checkIndex();
            boolean bl = status.clean;
            return bl;
        }
    }

    @Override
    public boolean validVersion() throws IOException {
        int createdMajorVersion = (Integer)new CreatedMajorVersion().run();
        return Version.MIN_SUPPORTED_MAJOR <= createdMajorVersion && createdMajorVersion <= Version.LATEST.major;
    }

    @Override
    public boolean hasCommits() throws IOException {
        return this.indexExists() && SegmentInfos.readLatestCommit((Directory)this.directory) != null;
    }

    @Override
    public Collection<String> latestCommitFileNames() throws IOException {
        return ((IndexCommit)DirectoryReader.listCommits((Directory)this.directory).getLast()).getFileNames();
    }

    @Override
    public LuceneIndexWriter newWriter(LuceneIndexWriterConfig writerConfig) throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.directory, Lucene9Directory.convertConfig(writerConfig));
        return new Lucene9IndexWriter(indexWriter);
    }

    @Override
    public LuceneContext getLuceneContext() {
        return LuceneContext.LUCENE_9;
    }

    @Override
    public void close() throws IOException {
        this.directory.close();
    }

    byte[] readFile(String name) throws IOException {
        try (IndexInput in = this.directory.openInput(name, IOContext.DEFAULT);){
            byte[] bytes = new byte[Math.toIntExact(in.length())];
            in.readBytes(bytes, 0, bytes.length);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    private static IndexWriterConfig convertConfig(LuceneIndexWriterConfig config) {
        if (config.analyzerOnly) {
            return new IndexWriterConfig(Lucene9Utils.loadAnalyzer(config.analyzer));
        }
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Lucene9Utils.loadAnalyzer(config.analyzer));
        if (config.RAMBufferSizeMB != null) {
            indexWriterConfig.setRAMBufferSizeMB(config.RAMBufferSizeMB.doubleValue());
        }
        if (config.maxBufferedDocs != null) {
            indexWriterConfig.setMaxBufferedDocs(config.maxBufferedDocs.intValue());
        }
        indexWriterConfig.setCommitOnClose(true);
        indexWriterConfig.setUseCompoundFile(true);
        indexWriterConfig.setMaxFullFlushMergeWaitMillis(0L);
        indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        if (config.codec != null) {
            indexWriterConfig.setCodec(Lucene9Directory.loadCodec(config));
        }
        if (config.useOnThreadConcurrentMergeScheduler) {
            indexWriterConfig.setMergeScheduler((MergeScheduler)new OnThreadConcurrentMergeScheduler());
        }
        LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
        mergePolicy.setNoCFSRatio(config.noCFSRatio);
        mergePolicy.setMinMergeMB(config.minMergeMB);
        mergePolicy.setMaxMergeMB(config.maxMergeMB);
        mergePolicy.setMergeFactor(config.mergeFactor);
        indexWriterConfig.setMergePolicy((MergePolicy)mergePolicy);
        return indexWriterConfig;
    }

    private static Codec loadCodec(LuceneIndexWriterConfig config) {
        String codecClassName;
        org.apache.lucene.codecs.Codec oldCodec = config.codec;
        return switch (codecClassName = oldCodec.getClass().getName()) {
            case "org.neo4j.kernel.api.impl.index.lucene.v10.codec.VectorCodecV1" -> new VectorCodecV1(oldCodec.knnVectorsFormat().getMaxDimensions(""));
            case "org.neo4j.kernel.api.impl.index.lucene.v10.codec.VectorCodecV2" -> new VectorCodecV2(((org.neo4j.kernel.api.impl.index.lucene.v10.codec.VectorCodecV2)oldCodec).getConfig());
            default -> Codec.forName((String)config.codec.getName());
        };
    }

    private final class CreatedMajorVersion
    extends SegmentInfos.FindSegmentsFile<Integer> {
        private CreatedMajorVersion() {
            super(Lucene9Directory.this.directory);
        }

        protected Integer doBody(String segmentFileName) throws IOException {
            try (IndexInput input = Lucene9Directory.this.directory.openInput(segmentFileName, IOContext.DEFAULT);){
                CodecUtil.readIndexHeader((IndexInput)input);
                input.readVInt();
                input.readVInt();
                input.readVInt();
                Integer n = input.readVInt();
                return n;
            }
        }
    }

    static class OnThreadConcurrentMergeScheduler
    extends MergeScheduler {
        OnThreadConcurrentMergeScheduler() {
        }

        public void merge(MergeScheduler.MergeSource mergeSource, MergeTrigger trigger) throws IOException {
            MergePolicy.OneMerge merge;
            while ((merge = this.nextMergeSynchronized(mergeSource)) != null) {
                mergeSource.merge(merge);
            }
        }

        private synchronized MergePolicy.OneMerge nextMergeSynchronized(MergeScheduler.MergeSource mergeSource) {
            return mergeSource.getNextMerge();
        }

        public void close() {
        }
    }
}

