/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongFloatProcedure;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.kernel.api.impl.index.collector.ValuesIterator;
import org.neo4j.shaded.lucene9.index.LeafReader;
import org.neo4j.shaded.lucene9.index.LeafReaderContext;
import org.neo4j.shaded.lucene9.index.NumericDocValues;
import org.neo4j.shaded.lucene9.search.Collector;
import org.neo4j.shaded.lucene9.search.LeafCollector;
import org.neo4j.shaded.lucene9.search.Scorable;
import org.neo4j.shaded.lucene9.search.ScoreMode;

abstract class Lucene9ScoredEntityResultCollector
implements Collector {
    private static final int NO_LIMIT = -1;
    private final long limit;
    private final ScoredEntityPriorityQueue pq;
    private final LongPredicate exclusionFilter;

    protected Lucene9ScoredEntityResultCollector(IndexQueryConstraints constraints, LongPredicate exclusionFilter) {
        this.exclusionFilter = exclusionFilter;
        this.limit = Lucene9ScoredEntityResultCollector.getLimit(constraints);
        this.pq = new ScoredEntityPriorityQueue(this.limit == -1L);
    }

    public ValuesIterator iterator() {
        return this.pq.iterator();
    }

    protected abstract String entityIdFieldKey();

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new ScoredEntityLeafCollector(context, this.entityIdFieldKey(), this.pq, this.limit, this.exclusionFilter);
    }

    public ScoreMode scoreMode() {
        return this.limit == -1L ? ScoreMode.COMPLETE : ScoreMode.TOP_SCORES;
    }

    private static long getLimit(IndexQueryConstraints constraints) {
        long limit = constraints.limit().orElse(Integer.MAX_VALUE) + constraints.skip().orElse(0L);
        return limit < Integer.MAX_VALUE ? limit : -1L;
    }

    public static class ScoredEntityPriorityQueue {
        private static final int ROOT = 1;
        private static final int INITIAL_CAPACITY = 33;
        private final boolean maxQueue;
        private long[] entities;
        private float[] scores;
        private int size;

        public ScoredEntityPriorityQueue(boolean maxQueue) {
            this.maxQueue = maxQueue;
            this.entities = new long[33];
            this.scores = new float[33];
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void insert(long entityId, float score) {
            ++this.size;
            if (this.size == this.entities.length) {
                this.growCapacity();
            }
            this.entities[this.size] = entityId;
            this.scores[this.size] = score;
            this.liftTowardsRoot(this.size);
        }

        public float peekTopScore() {
            return this.scores[1];
        }

        public void removeTop(LongFloatProcedure receiver) {
            receiver.value(this.entities[1], this.scores[1]);
            this.removeTop();
        }

        public void removeTop() {
            this.swap(1, this.size);
            --this.size;
            this.pushTowardsBottom();
        }

        private void growCapacity() {
            this.entities = Arrays.copyOf(this.entities, this.entities.length * 2);
            this.scores = Arrays.copyOf(this.scores, this.scores.length * 2);
        }

        private void liftTowardsRoot(int index) {
            int parentIndex;
            while (index > 1 && this.subordinate(parentIndex = index >> 1, index)) {
                this.swap(index, parentIndex);
                index = parentIndex;
            }
        }

        private void pushTowardsBottom() {
            int child;
            int index = 1;
            while ((child = index << 1) <= this.size) {
                if (child < this.size && this.subordinate(child, child + 1)) {
                    ++child;
                }
                if (!this.subordinate(index, child)) break;
                this.swap(index, child);
                index = child;
            }
        }

        private boolean subordinate(int indexA, int indexB) {
            float scoreA = this.scores[indexA];
            float scoreB = this.scores[indexB];
            return this.maxQueue ? scoreA < scoreB : scoreA > scoreB;
        }

        private void swap(int indexA, int indexB) {
            long entity = this.entities[indexA];
            float score = this.scores[indexA];
            this.entities[indexA] = this.entities[indexB];
            this.scores[indexA] = this.scores[indexB];
            this.entities[indexB] = entity;
            this.scores[indexB] = score;
        }

        ValuesIterator iterator() {
            if (this.isEmpty()) {
                return ValuesIterator.EMPTY;
            }
            return this.maxQueue ? new ScoredEntityResultsMaxQueueIterator(this) : new ScoredEntityResultsMinQueueIterator(this);
        }
    }

    private static class ScoredEntityLeafCollector
    implements LeafCollector {
        private final ScoredEntityPriorityQueue pq;
        private final long limit;
        private final LongPredicate exclusionFilter;
        private final NumericDocValues values;
        private Scorable scorer;
        private float minCompetitiveScore;

        ScoredEntityLeafCollector(LeafReaderContext context, String entityIdFieldKey, ScoredEntityPriorityQueue pq, long limit, LongPredicate exclusionFilter) throws IOException {
            this.pq = pq;
            this.limit = limit;
            this.exclusionFilter = exclusionFilter;
            LeafReader reader = context.reader();
            this.values = reader.getNumericDocValues(entityIdFieldKey);
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
            this.minCompetitiveScore = 0.0f;
            this.updateMinCompetitiveScore(scorer);
        }

        public void collect(int doc) throws IOException {
            assert (this.scorer.docID() == doc);
            if (this.values.advanceExact(doc)) {
                long entityId = this.values.longValue();
                float score = this.scorer.score();
                if (this.exclusionFilter.test(entityId)) {
                    return;
                }
                if (this.limit == -1L) {
                    this.pq.insert(entityId, score);
                } else if ((long)this.pq.size() < this.limit) {
                    this.pq.insert(entityId, score);
                    this.updateMinCompetitiveScore(this.scorer);
                } else if (this.pq.peekTopScore() < score) {
                    this.pq.removeTop();
                    this.pq.insert(entityId, score);
                    this.updateMinCompetitiveScore(this.scorer);
                }
            } else {
                throw new RuntimeException("No document value for document id " + doc + ".");
            }
        }

        private void updateMinCompetitiveScore(Scorable scorer) throws IOException {
            float localMinScore;
            if (this.limit != -1L && (long)this.pq.size() >= this.limit && (localMinScore = Math.nextUp(this.pq.peekTopScore())) > this.minCompetitiveScore) {
                scorer.setMinCompetitiveScore(localMinScore);
                this.minCompetitiveScore = localMinScore;
            }
        }
    }

    public static class ScoredEntityResultsMinQueueIterator
    implements ValuesIterator,
    LongFloatProcedure {
        private final long[] entityIds;
        private final float[] scores;
        private int index;

        public ScoredEntityResultsMinQueueIterator(ScoredEntityPriorityQueue pq) {
            int size = pq.size();
            this.entityIds = new long[size];
            this.scores = new float[size];
            this.index = size - 1;
            while (!pq.isEmpty()) {
                pq.removeTop(this);
            }
        }

        @Override
        public int remaining() {
            return 0;
        }

        public long next() {
            if (this.hasNext()) {
                ++this.index;
                return this.current();
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return this.index < this.entityIds.length - 1;
        }

        @Override
        public long current() {
            return this.entityIds[this.index];
        }

        @Override
        public float currentScore() {
            return this.scores[this.index];
        }

        public void value(long entityId, float score) {
            this.entityIds[this.index] = entityId;
            this.scores[this.index] = score;
            --this.index;
        }
    }

    public static class ScoredEntityResultsMaxQueueIterator
    implements ValuesIterator,
    LongFloatProcedure {
        private final ScoredEntityPriorityQueue pq;
        private long currentEntity;
        private float currentScore;

        public ScoredEntityResultsMaxQueueIterator(ScoredEntityPriorityQueue pq) {
            this.pq = pq;
        }

        @Override
        public int remaining() {
            return 0;
        }

        @Override
        public float currentScore() {
            return this.currentScore;
        }

        public long next() {
            if (this.hasNext()) {
                this.pq.removeTop(this);
                return this.currentEntity;
            }
            throw new NoSuchElementException();
        }

        public boolean hasNext() {
            return !this.pq.isEmpty();
        }

        @Override
        public long current() {
            return this.currentEntity;
        }

        public void value(long entityId, float score) {
            this.currentEntity = entityId;
            this.currentScore = score;
        }
    }
}

