/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index.lucene.v9.codec;

import java.io.IOException;
import org.neo4j.kernel.api.impl.schema.vector.VectorIndexConfig;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsFormat;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsReader;
import org.neo4j.shaded.lucene9.codecs.KnnVectorsWriter;
import org.neo4j.shaded.lucene9.codecs.lucene99.Lucene99HnswScalarQuantizedVectorsFormat;
import org.neo4j.shaded.lucene9.index.SegmentReadState;
import org.neo4j.shaded.lucene9.index.SegmentWriteState;

public class LuceneKnnScalarQuantizedVectorFormatV2
extends KnnVectorsFormat {
    private static final String LUCENE_SCALAR_QUANTIZED_VECTOR_FORMAT_V2_NAME = "LuceneKnnScalarQuantizedVectorFormatV2";
    private final KnnVectorsFormat vectorsFormat;
    private final int maxDimensions;

    public LuceneKnnScalarQuantizedVectorFormatV2() {
        this(Integer.MAX_VALUE, VectorIndexConfig.HnswConfig.DUMMY);
    }

    public LuceneKnnScalarQuantizedVectorFormatV2(int maxDimensions, VectorIndexConfig.HnswConfig hnswConfig) {
        super(LUCENE_SCALAR_QUANTIZED_VECTOR_FORMAT_V2_NAME);
        this.maxDimensions = maxDimensions;
        this.vectorsFormat = new Lucene99HnswScalarQuantizedVectorsFormat(hnswConfig.M(), hnswConfig.efConstruction());
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.vectorsFormat.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.vectorsFormat.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return this.maxDimensions;
    }
}

