/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public abstract class TextIndexCapability
implements IndexCapability {
    private static final double COST_MULTIPLIER_TRIGRAM_GOOD = 0.9;
    private static final double COST_MULTIPLIER_TRIGRAM_BAD = 1.1;
    private static final double COST_MULTIPLIER_TEXT_GOOD = 0.95;
    private static final double COST_MULTIPLIER_TEXT_BAD = 1.05;

    private TextIndexCapability() {
    }

    public static TextIndexCapability trigram() {
        return new Trigram();
    }

    public static TextIndexCapability text() {
        return new Text();
    }

    protected abstract double costMultiplierBad();

    protected abstract double costMultiplierGood();

    public boolean supportsOrdering() {
        return false;
    }

    public boolean supportsReturningValues() {
        return false;
    }

    public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
        Preconditions.requireNonEmpty((Object[])valueCategories);
        Preconditions.requireNoNullElements((Object[])valueCategories);
        return valueCategories.length == 1 && valueCategories[0] == ValueCategory.TEXT;
    }

    public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
        if (queryType == IndexQuery.IndexQueryType.ALL_ENTRIES) {
            return true;
        }
        if (!this.areValueCategoriesAccepted(valueCategory)) {
            return false;
        }
        return TextIndexCapability.isIndexQueryTypeSupported(queryType);
    }

    private static boolean isIndexQueryTypeSupported(IndexQuery.IndexQueryType indexQueryType) {
        return switch (indexQueryType) {
            case IndexQuery.IndexQueryType.EXACT, IndexQuery.IndexQueryType.STRING_PREFIX, IndexQuery.IndexQueryType.STRING_CONTAINS, IndexQuery.IndexQueryType.STRING_SUFFIX -> true;
            default -> false;
        };
    }

    public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
        Preconditions.checkState((queryTypes.length == 1 ? 1 : 0) != 0, (String)"Does not support composite queries");
        IndexQuery.IndexQueryType queryType = queryTypes[0];
        return switch (queryType) {
            case IndexQuery.IndexQueryType.STRING_CONTAINS, IndexQuery.IndexQueryType.STRING_SUFFIX -> this.costMultiplierGood();
            case IndexQuery.IndexQueryType.EXACT, IndexQuery.IndexQueryType.STRING_PREFIX, IndexQuery.IndexQueryType.RANGE -> this.costMultiplierBad();
            case IndexQuery.IndexQueryType.ALL_ENTRIES -> 1.0;
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(queryType));
        };
    }

    public boolean supportPartitionedScan(IndexQuery ... queries) {
        Preconditions.requireNonEmpty((Object[])queries);
        Preconditions.requireNoNullElements((Object[])queries);
        return false;
    }

    private static class Trigram
    extends TextIndexCapability {
        private Trigram() {
        }

        @Override
        protected double costMultiplierBad() {
            return 1.1;
        }

        @Override
        protected double costMultiplierGood() {
            return 0.9;
        }
    }

    private static class Text
    extends TextIndexCapability {
        private Text() {
        }

        @Override
        protected double costMultiplierBad() {
            return 1.05;
        }

        @Override
        protected double costMultiplierGood() {
            return 0.95;
        }
    }
}

