/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema.fulltext;

import org.apache.lucene.analysis.Analyzer;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.impl.index.DatabaseIndex;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigBuilder;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigMode;
import org.neo4j.kernel.api.impl.index.builder.AbstractLuceneIndexBuilder;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndex;
import org.neo4j.kernel.api.impl.schema.fulltext.FulltextIndexReader;
import org.neo4j.kernel.api.impl.schema.fulltext.IndexUpdateSink;
import org.neo4j.kernel.api.impl.schema.fulltext.NullIndexUpdateSink;
import org.neo4j.kernel.api.impl.schema.fulltext.WritableFulltextDatabaseIndex;
import org.neo4j.logging.LogProvider;
import org.neo4j.token.api.TokenHolder;

public class FulltextIndexBuilder
extends AbstractLuceneIndexBuilder<FulltextIndexBuilder> {
    private final IndexDescriptor descriptor;
    private final TokenHolder propertyKeyTokenHolder;
    private final Analyzer analyzer;
    private final String[] propertyNames;
    private boolean populating;
    private IndexUpdateSink indexUpdateSink = NullIndexUpdateSink.INSTANCE;
    private final Config config;

    private FulltextIndexBuilder(IndexDescriptor descriptor, Config config, DatabaseReadOnlyChecker readOnlyChecker, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames, LogProvider logProvider) {
        super(readOnlyChecker, logProvider);
        this.config = config;
        this.descriptor = descriptor;
        this.analyzer = analyzer;
        this.propertyNames = propertyNames;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
    }

    public static FulltextIndexBuilder create(IndexDescriptor descriptor, Config config, DatabaseReadOnlyChecker readOnlyChecker, TokenHolder propertyKeyTokenHolder, Analyzer analyzer, String[] propertyNames, LogProvider logProvider) {
        return new FulltextIndexBuilder(descriptor, config, readOnlyChecker, propertyKeyTokenHolder, analyzer, propertyNames, logProvider);
    }

    FulltextIndexBuilder withPopulatingMode(boolean isPopulating) {
        this.populating = isPopulating;
        return this;
    }

    FulltextIndexBuilder withIndexUpdateSink(IndexUpdateSink indexUpdateSink) {
        this.indexUpdateSink = indexUpdateSink;
        return this;
    }

    public DatabaseIndex<FulltextIndexReader> build() {
        IndexWriterConfigMode mode = this.populating ? IndexWriterConfigMode.TEXT_POPULATION : IndexWriterConfigMode.TEXT;
        IndexWriterConfigBuilder writerConfigBuilder = new IndexWriterConfigBuilder(mode, this.config).withAnalyzer(this.analyzer);
        WritableIndexPartitionFactory partitionFactory = new WritableIndexPartitionFactory(writerConfigBuilder::build);
        FulltextIndex fulltextIndex = new FulltextIndex(this.storageBuilder.build(), partitionFactory, this.descriptor, this.propertyKeyTokenHolder, this.config, this.analyzer, this.propertyNames, this.logProvider);
        return new WritableFulltextDatabaseIndex(this.indexUpdateSink, fulltextIndex, this.readOnlyChecker, this.permanentlyReadOnly);
    }
}

