/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.interpreted.pipes;

import java.io.Serializable;
import java.util.Comparator;
import org.neo4j.cypher.internal.frontend.helpers.SeqCombiner$;
import org.neo4j.cypher.internal.logical.plans.Bound;
import org.neo4j.cypher.internal.logical.plans.CompositeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.ExistenceQueryExpression;
import org.neo4j.cypher.internal.logical.plans.IndexOrder;
import org.neo4j.cypher.internal.logical.plans.IndexOrderAscending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderDescending$;
import org.neo4j.cypher.internal.logical.plans.IndexOrderNone$;
import org.neo4j.cypher.internal.logical.plans.InequalitySeekRange;
import org.neo4j.cypher.internal.logical.plans.ManyQueryExpression;
import org.neo4j.cypher.internal.logical.plans.MinMaxOrdering;
import org.neo4j.cypher.internal.logical.plans.PointBoundingBoxRange;
import org.neo4j.cypher.internal.logical.plans.PointDistanceRange;
import org.neo4j.cypher.internal.logical.plans.PrefixRange;
import org.neo4j.cypher.internal.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.logical.plans.RangeBetween;
import org.neo4j.cypher.internal.logical.plans.RangeGreaterThan;
import org.neo4j.cypher.internal.logical.plans.RangeLessThan;
import org.neo4j.cypher.internal.logical.plans.RangeQueryExpression;
import org.neo4j.cypher.internal.logical.plans.SingleQueryExpression;
import org.neo4j.cypher.internal.runtime.CompositeValueIndexCursor$;
import org.neo4j.cypher.internal.runtime.CypherRow;
import org.neo4j.cypher.internal.runtime.IsList$;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.InequalitySeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.PointBoundingBoxSeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.PointDistanceSeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.PrefixSeekRangeExpression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.IndexSeekMode;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.LockingUniqueIndexSeek$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.NonLockingSeek$;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.makeValueNeoSafe$;
import org.neo4j.cypher.internal.util.AssertionRunner;
import org.neo4j.cypher.operations.CypherTypeValueMapper;
import org.neo4j.exceptions.CypherTypeException;
import org.neo4j.exceptions.InternalException;
import org.neo4j.internal.kernel.api.IndexReadSession;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.RelationshipValueIndexCursor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CRSCalculator;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uea\u0002\b\u0010!\u0003\r\tA\b\u0005\u0006K\u0001!\tA\n\u0005\u0006U\u00011\ta\u000b\u0005\u0006a\u00011\t!\r\u0005\u0006\u0005\u00021\ta\u0011\u0005\u0006\u0015\u0002!\tb\u0013\u0005\u0006_\u0002!\t\u0002\u001d\u0005\u0006s\u0002!IA\u001f\u0005\u0006s\u0002!Ia \u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013Aq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005-\u0004\u0001\"\u0005\u0002n!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d%!E#oi&$\u00180\u00138eKb\u001cV-Z6fe*\u0011\u0001#E\u0001\u0006a&\u0004Xm\u001d\u0006\u0003%M\t1\"\u001b8uKJ\u0004(/\u001a;fI*\u0011A#F\u0001\beVtG/[7f\u0015\t1r#\u0001\u0005j]R,'O\\1m\u0015\tA\u0012$\u0001\u0004dsBDWM\u001d\u0006\u00035m\tQA\\3pi)T\u0011\u0001H\u0001\u0004_J<7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001(!\t\u0001\u0003&\u0003\u0002*C\t!QK\\5u\u0003%Ig\u000eZ3y\u001b>$W-F\u0001-!\tic&D\u0001\u0010\u0013\tysBA\u0007J]\u0012,\u0007pU3fW6{G-Z\u0001\nm\u0006dW/Z#yaJ,\u0012A\r\t\u0004gaRT\"\u0001\u001b\u000b\u0005U2\u0014!\u00029mC:\u001c(BA\u001c\u0016\u0003\u001dawnZ5dC2L!!\u000f\u001b\u0003\u001fE+XM]=FqB\u0014Xm]:j_:\u0004\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u007fE\t\u0001bY8n[\u0006tGm]\u0005\u0003\u0003r\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003-\u0001(o\u001c9feRL\u0018\nZ:\u0016\u0003\u0011\u00032\u0001I#H\u0013\t1\u0015EA\u0003BeJ\f\u0017\u0010\u0005\u0002!\u0011&\u0011\u0011*\t\u0002\u0004\u0013:$\u0018!C5oI\u0016D8+Z3l)\u0019aUKW0eSB\u0011QjU\u0007\u0002\u001d*\u0011q\nU\u0001\u0004CBL'BA)S\u0003\u0019YWM\u001d8fY*\u0011a#G\u0005\u0003):\u0013ACT8eKZ\u000bG.^3J]\u0012,\u0007pQ;sg>\u0014\b\"\u0002,\u0006\u0001\u00049\u0016!B:uCR,\u0007CA\u0017Y\u0013\tIvB\u0001\u0006Rk\u0016\u0014\u0018p\u0015;bi\u0016DQaW\u0003A\u0002q\u000bQ!\u001b8eKb\u0004\"!T/\n\u0005ys%\u0001E%oI\u0016D(+Z1e'\u0016\u001c8/[8o\u0011\u0015\u0001W\u00011\u0001b\u0003-qW-\u001a3t-\u0006dW/Z:\u0011\u0005\u0001\u0012\u0017BA2\"\u0005\u001d\u0011un\u001c7fC:DQ!Z\u0003A\u0002\u0019\f!\"\u001b8eKb|%\u000fZ3s!\t\u0019t-\u0003\u0002ii\tQ\u0011J\u001c3fq>\u0013H-\u001a:\t\u000b),\u0001\u0019A6\u0002\u0017\t\f7/Z\"p]R,\u0007\u0010\u001e\t\u0003Y6l\u0011aE\u0005\u0003]N\u0011\u0011bQ=qQ\u0016\u0014(k\\<\u0002+I,G.\u0019;j_:\u001c\b.\u001b9J]\u0012,\u0007pU3fWR1\u0011\u000f^;wob\u0004\"!\u0014:\n\u0005Mt%\u0001\b*fY\u0006$\u0018n\u001c8tQ&\u0004h+\u00197vK&sG-\u001a=DkJ\u001cxN\u001d\u0005\u0006-\u001a\u0001\ra\u0016\u0005\u00067\u001a\u0001\r\u0001\u0018\u0005\u0006A\u001a\u0001\r!\u0019\u0005\u0006K\u001a\u0001\rA\u001a\u0005\u0006U\u001a\u0001\ra[\u0001\u000e_J$WM]3e\u0007V\u00148o\u001c:\u0015\u00071[H\u0010C\u0003f\u000f\u0001\u0007a\rC\u0003~\u000f\u0001\u0007a0A\u0004dkJ\u001cxN]:\u0011\u0007\u0001*E\nF\u0003r\u0003\u0003\t\u0019\u0001C\u0003f\u0011\u0001\u0007a\r\u0003\u0004~\u0011\u0001\u0007\u0011Q\u0001\t\u0004A\u0015\u000b\u0018\u0001\u0003\"Z?Z\u000bE*V#\u0016\u0005\u0005-\u0001#B\u001a\u0002\u000e\u0005E\u0011bAA\bi\tqQ*\u001b8NCb|%\u000fZ3sS:<\u0007\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\tgR|'/\u00192mK*\u0019\u00111D\r\u0002\rY\fG.^3t\u0013\u0011\ty\"!\u0006\u0003\u000bY\u000bG.^3\u0002'\r|W\u000e];uK&sG-\u001a=Rk\u0016\u0014\u0018.Z:\u0015\r\u0005\u0015\u0012QJA(!\u0019\t9#!\f\u000225\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\t\u0013AC2pY2,7\r^5p]&!\u0011qFA\u0015\u0005\r\u0019V-\u001d\t\u0007\u0003g\t\u0019%a\u0012\u000f\t\u0005U\u0012q\b\b\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013bAA!C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003\u000bR1!!\u0011\"!\ri\u0015\u0011J\u0005\u0004\u0003\u0017r%A\u0005)s_B,'\u000f^=J]\u0012,\u00070U;fefDQA\u0016\u0006A\u0002]Cq!!\u0015\u000b\u0001\u0004\t\u0019&A\u0002s_^\u00042\u0001\\A+\u0013\r\t9f\u0005\u0002\f%\u0016\fG-\u00192mKJ{w/A\nd_6\u0004X\u000f^3SC:<W-U;fe&,7\u000f\u0006\u0006\u0002^\u0005}\u0013\u0011MA2\u0003O\u0002b!a\n\u0002.\u0005\u001d\u0003\"\u0002,\f\u0001\u00049\u0006bBA)\u0017\u0001\u0007\u00111\u000b\u0005\u0007\u0003KZ\u0001\u0019\u0001\u001e\u0002\u0019I\fgnZ3Xe\u0006\u0004\b/\u001a:\t\r\u0005%4\u00021\u0001H\u0003)\u0001(o\u001c9feRL\u0018\nZ\u0001\u0014G>l\u0007/\u001e;f\u000bb\f7\r^)vKJLWm\u001d\u000b\u0007\u0003_\n\t)a!\u0011\r\u0005\u001d\u0012QFA9!\u0019\t\u0019$a\u0011\u0002tA!\u0011QOA>\u001d\ri\u0015qO\u0005\u0004\u0003sr\u0015A\u0005)s_B,'\u000f^=J]\u0012,\u00070U;fefLA!! \u0002\u0000\tqQ\t_1diB\u0013X\rZ5dCR,'bAA=\u001d\")a\u000b\u0004a\u0001/\"9\u0011\u0011\u000b\u0007A\u0002\u0005M\u0013aF2p[B,H/Z\"p[B|7/\u001b;f#V,'/[3t)\u0019\tI)!%\u0002\u0014R1\u0011QLAF\u0003\u001fCa!!$\u000e\u0001\u0004\u0011\u0014aD9vKJLX\t\u001f9sKN\u001c\u0018n\u001c8\t\r\u0005%T\u00021\u0001H\u0011\u00151V\u00021\u0001X\u0011\u001d\t\t&\u0004a\u0001\u0003'\u0002")
public interface EntityIndexSeeker {
    public void org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$_setter_$org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE_$eq(MinMaxOrdering<Value> var1);

    public IndexSeekMode indexMode();

    public QueryExpression<Expression> valueExpr();

    public int[] propertyIds();

    public static /* synthetic */ NodeValueIndexCursor indexSeek$(EntityIndexSeeker $this, QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        return $this.indexSeek(state, index, needsValues, indexOrder, baseContext);
    }

    default public NodeValueIndexCursor indexSeek(QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        IndexSeekMode indexSeekMode = this.indexMode();
        if (NonLockingSeek$.MODULE$.equals(indexSeekMode)) {
            Seq<scala.collection.immutable.Seq<PropertyIndexQuery>> indexQueries = this.computeIndexQueries(state, (ReadableRow)baseContext);
            if (indexQueries.size() == 1) {
                return state.query().nodeIndexSeek(index, needsValues, indexOrder, (scala.collection.immutable.Seq)indexQueries.head());
            }
            return this.orderedCursor(indexOrder, (NodeValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> {
                boolean bl;
                QueryContext queryContext;
                block3: {
                    block2: {
                        queryContext = state.query();
                        if (needsValues) break block2;
                        IndexOrder indexOrder = indexOrder;
                        IndexOrderNone$ indexOrderNone$ = IndexOrderNone$.MODULE$;
                        if (!(indexOrder == null ? indexOrderNone$ != null : !indexOrder.equals(indexOrderNone$))) break block3;
                    }
                    bl = true;
                    return queryContext.nodeIndexSeek(index, bl, indexOrder, query);
                }
                bl = false;
                return queryContext.nodeIndexSeek(index, bl, indexOrder, query);
            })).toArray(ClassTag$.MODULE$.apply(NodeValueIndexCursor.class)));
        }
        if (LockingUniqueIndexSeek$.MODULE$.equals(indexSeekMode)) {
            Seq<scala.collection.immutable.Seq<PropertyIndexQuery.ExactPredicate>> indexQueries = this.computeExactQueries(state, (ReadableRow)baseContext);
            if (indexQueries.size() == 1) {
                return state.query().nodeLockingUniqueIndexSeek(index.reference(), (scala.collection.immutable.Seq)indexQueries.head());
            }
            return this.orderedCursor(indexOrder, (NodeValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> state.query().nodeLockingUniqueIndexSeek(index.reference(), query))).toArray(ClassTag$.MODULE$.apply(NodeValueIndexCursor.class)));
        }
        throw new MatchError((Object)indexSeekMode);
    }

    public static /* synthetic */ RelationshipValueIndexCursor relationshipIndexSeek$(EntityIndexSeeker $this, QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        return $this.relationshipIndexSeek(state, index, needsValues, indexOrder, baseContext);
    }

    default public RelationshipValueIndexCursor relationshipIndexSeek(QueryState state, IndexReadSession index, boolean needsValues, IndexOrder indexOrder, CypherRow baseContext) {
        IndexSeekMode indexSeekMode = this.indexMode();
        if (NonLockingSeek$.MODULE$.equals(indexSeekMode)) {
            Seq<scala.collection.immutable.Seq<PropertyIndexQuery>> indexQueries = this.computeIndexQueries(state, (ReadableRow)baseContext);
            if (indexQueries.size() == 1) {
                return state.query().relationshipIndexSeek(index, needsValues, indexOrder, (scala.collection.immutable.Seq)indexQueries.head());
            }
            return this.orderedCursor(indexOrder, (RelationshipValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> {
                boolean bl;
                QueryContext queryContext;
                block3: {
                    block2: {
                        queryContext = state.query();
                        if (needsValues) break block2;
                        IndexOrder indexOrder = indexOrder;
                        IndexOrderNone$ indexOrderNone$ = IndexOrderNone$.MODULE$;
                        if (!(indexOrder == null ? indexOrderNone$ != null : !indexOrder.equals(indexOrderNone$))) break block3;
                    }
                    bl = true;
                    return queryContext.relationshipIndexSeek(index, bl, indexOrder, query);
                }
                bl = false;
                return queryContext.relationshipIndexSeek(index, bl, indexOrder, query);
            })).toArray(ClassTag$.MODULE$.apply(RelationshipValueIndexCursor.class)));
        }
        if (LockingUniqueIndexSeek$.MODULE$.equals(indexSeekMode)) {
            Seq<scala.collection.immutable.Seq<PropertyIndexQuery.ExactPredicate>> indexQueries = this.computeExactQueries(state, (ReadableRow)baseContext);
            if (indexQueries.size() == 1) {
                return state.query().relationshipLockingUniqueIndexSeek(index.reference(), (scala.collection.immutable.Seq)indexQueries.head());
            }
            return this.orderedCursor(indexOrder, (RelationshipValueIndexCursor[])((IterableOnceOps)indexQueries.map((Function1 & Serializable)query -> state.query().relationshipLockingUniqueIndexSeek(index.reference(), query))).toArray(ClassTag$.MODULE$.apply(RelationshipValueIndexCursor.class)));
        }
        throw new MatchError((Object)indexSeekMode);
    }

    private NodeValueIndexCursor orderedCursor(IndexOrder indexOrder, NodeValueIndexCursor[] cursors) {
        IndexOrder indexOrder2 = indexOrder;
        if (IndexOrderNone$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.unordered(cursors);
        }
        if (IndexOrderAscending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.ascending(cursors);
        }
        if (IndexOrderDescending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.descending(cursors);
        }
        throw new MatchError((Object)indexOrder2);
    }

    private RelationshipValueIndexCursor orderedCursor(IndexOrder indexOrder, RelationshipValueIndexCursor[] cursors) {
        IndexOrder indexOrder2 = indexOrder;
        if (IndexOrderNone$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.unordered(cursors);
        }
        if (IndexOrderAscending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.ascending(cursors);
        }
        if (IndexOrderDescending$.MODULE$.equals(indexOrder2)) {
            return CompositeValueIndexCursor$.MODULE$.descending(cursors);
        }
        throw new MatchError((Object)indexOrder2);
    }

    public MinMaxOrdering<Value> org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE();

    public static /* synthetic */ Seq computeIndexQueries$(EntityIndexSeeker $this, QueryState state, ReadableRow row) {
        return $this.computeIndexQueries(state, row);
    }

    default public Seq<scala.collection.immutable.Seq<PropertyIndexQuery>> computeIndexQueries(QueryState state, ReadableRow row) {
        QueryExpression<Expression> queryExpression = this.valueExpr();
        if (queryExpression instanceof RangeQueryExpression) {
            RangeQueryExpression rangeQueryExpression = (RangeQueryExpression)queryExpression;
            Expression rangeWrapper = (Expression)rangeQueryExpression.expression();
            if (AssertionRunner.ASSERTIONS_ENABLED && this.propertyIds().length != 1) {
                throw new AssertionError((Object)"assertion failed");
            }
            return (Seq)this.computeRangeQueries(state, row, rangeWrapper, BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.propertyIds())))).map((Function1 & Serializable)x$1 -> new .colon.colon(x$1, (List)Nil$.MODULE$));
        }
        if (queryExpression instanceof CompositeQueryExpression) {
            CompositeQueryExpression compositeQueryExpression = (CompositeQueryExpression)queryExpression;
            scala.collection.immutable.Seq exprs = compositeQueryExpression.inner();
            if (AssertionRunner.ASSERTIONS_ENABLED && exprs.lengthCompare(this.propertyIds().length) != 0) {
                throw new AssertionError((Object)"assertion failed");
            }
            scala.collection.immutable.Seq indexQueries = (scala.collection.immutable.Seq)((IterableOps)exprs.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(this.propertyIds()))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    QueryExpression expr = (QueryExpression)tuple2._1();
                    int propId = tuple2._2$mcI$sp();
                    return this.computeCompositeQueries(state, row, (QueryExpression<Expression>)expr, propId);
                }
                throw new MatchError((Object)tuple2);
            });
            return SeqCombiner$.MODULE$.combine((Iterable)indexQueries);
        }
        if (queryExpression instanceof ExistenceQueryExpression) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"An ExistenceQueryExpression shouldn't be found outside of a CompositeQueryExpression");
        }
        return this.computeExactQueries(state, row);
    }

    public static /* synthetic */ Seq computeRangeQueries$(EntityIndexSeeker $this, QueryState state, ReadableRow row, Expression rangeWrapper, int propertyId) {
        return $this.computeRangeQueries(state, row, rangeWrapper, propertyId);
    }

    default public Seq<PropertyIndexQuery> computeRangeQueries(QueryState state, ReadableRow row, Expression rangeWrapper, int propertyId) {
        Expression expression = rangeWrapper;
        if (expression instanceof PrefixSeekRangeExpression) {
            PrefixSeekRangeExpression prefixSeekRangeExpression = (PrefixSeekRangeExpression)expression;
            PrefixRange<Expression> range = prefixSeekRangeExpression.range();
            Expression expr2 = (Expression)range.prefix();
            AnyValue anyValue = expr2.apply(row, state);
            if (anyValue instanceof TextValue) {
                TextValue textValue = (TextValue)anyValue;
                return Predef$.MODULE$.wrapRefArray((Object[])new PropertyIndexQuery.StringPrefixPredicate[]{PropertyIndexQuery.stringPrefix((int)propertyId, (TextValue)textValue)});
            }
            return Nil$.MODULE$;
        }
        if (expression instanceof InequalitySeekRangeExpression) {
            InequalitySeekRangeExpression inequalitySeekRangeExpression = (InequalitySeekRangeExpression)expression;
            InequalitySeekRange<Expression> innerRange = inequalitySeekRangeExpression.range();
            Option option = innerRange.flatMapBounds((Function1 & Serializable)expr -> makeValueNeoSafe$.MODULE$.safeOrEmpty(expr.apply(row, state)));
            if (None$.MODULE$.equals(option)) {
                return Nil$.MODULE$;
            }
            if (option instanceof Some) {
                InequalitySeekRange range;
                Some some = (Some)option;
                InequalitySeekRange valueRange = (InequalitySeekRange)some.value();
                Map groupedRanges = valueRange.groupBy((Function1 & Serializable)bound -> ((Value)bound.endPoint()).valueGroup());
                if (groupedRanges.size() > 1) {
                    return Nil$.MODULE$;
                }
                Tuple2 tuple2 = (Tuple2)groupedRanges.head();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ValueGroup valueGroup = (ValueGroup)tuple2._1();
                InequalitySeekRange range2 = (InequalitySeekRange)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)valueGroup, (Object)range2);
                ValueGroup valueGroup2 = (ValueGroup)tuple22._1();
                InequalitySeekRange inequalitySeekRange = range = (InequalitySeekRange)tuple22._2();
                if (inequalitySeekRange instanceof RangeLessThan) {
                    RangeLessThan rangeLessThan = (RangeLessThan)inequalitySeekRange;
                    return Option$.MODULE$.option2Iterable(rangeLessThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).map((Function1 & Serializable)limit -> PropertyIndexQuery.range((int)propertyId, null, (boolean)false, (Value)((Value)limit.endPoint()), (boolean)limit.isInclusive()))).toSeq();
                }
                if (inequalitySeekRange instanceof RangeGreaterThan) {
                    RangeGreaterThan rangeGreaterThan = (RangeGreaterThan)inequalitySeekRange;
                    return Option$.MODULE$.option2Iterable(rangeGreaterThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).map((Function1 & Serializable)limit -> PropertyIndexQuery.range((int)propertyId, (Value)((Value)limit.endPoint()), (boolean)limit.isInclusive(), null, (boolean)false))).toSeq();
                }
                if (inequalitySeekRange instanceof RangeBetween) {
                    RangeBetween rangeBetween = (RangeBetween)inequalitySeekRange;
                    RangeGreaterThan rangeGreaterThan = rangeBetween.greaterThan();
                    RangeLessThan rangeLessThan = rangeBetween.lessThan();
                    Bound greaterThanLimit = (Bound)rangeGreaterThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).get();
                    Bound lessThanLimit = (Bound)rangeLessThan.limit(this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE()).get();
                    int compare = Values.COMPARATOR.compare((Value)greaterThanLimit.endPoint(), (Value)lessThanLimit.endPoint());
                    if (compare < 0) {
                        return new .colon.colon((Object)PropertyIndexQuery.range((int)propertyId, (Value)((Value)greaterThanLimit.endPoint()), (boolean)greaterThanLimit.isInclusive(), (Value)((Value)lessThanLimit.endPoint()), (boolean)lessThanLimit.isInclusive()), (List)Nil$.MODULE$);
                    }
                    if (compare == 0 && greaterThanLimit.isInclusive() && lessThanLimit.isInclusive()) {
                        return new .colon.colon((Object)PropertyIndexQuery.exact((int)propertyId, (Object)lessThanLimit.endPoint()), (List)Nil$.MODULE$);
                    }
                    return Nil$.MODULE$;
                }
                throw new MatchError((Object)inequalitySeekRange);
            }
            throw new MatchError((Object)option);
        }
        if (expression instanceof PointDistanceSeekRangeExpression) {
            PointDistanceSeekRangeExpression pointDistanceSeekRangeExpression = (PointDistanceSeekRangeExpression)expression;
            PointDistanceRange<Expression> range = pointDistanceSeekRangeExpression.range();
            Tuple2 tuple2 = new Tuple2((Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.distance()).apply(row, state)), (Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.point()).apply(row, state)));
            if (tuple2 != null) {
                Some some;
                Value distance;
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some && (distance = (Value)(some = (Some)option).value()) instanceof NumberValue) {
                    Some some2;
                    Value point;
                    NumberValue numberValue = (NumberValue)distance;
                    if (option2 instanceof Some && (point = (Value)(some2 = (Some)option2).value()) instanceof PointValue) {
                        PointValue pointValue = (PointValue)point;
                        Buffer bboxes = CollectionConverters$.MODULE$.ListHasAsScala(pointValue.getCoordinateReferenceSystem().getCalculator().boundingBox(pointValue, numberValue.doubleValue())).asScala();
                        boolean inclusive = bboxes.length() > 1 ? true : range.inclusive();
                        return (Seq)bboxes.map((Function1 & Serializable)bbox -> PropertyIndexQuery.boundingBox((int)propertyId, (PointValue)((PointValue)bbox.first()), (PointValue)((PointValue)bbox.other()), (boolean)inclusive));
                    }
                }
            }
            return Nil$.MODULE$;
        }
        if (expression instanceof PointBoundingBoxSeekRangeExpression) {
            PointBoundingBoxSeekRangeExpression pointBoundingBoxSeekRangeExpression = (PointBoundingBoxSeekRangeExpression)expression;
            PointBoundingBoxRange<Expression> range = pointBoundingBoxSeekRangeExpression.range();
            Tuple2 tuple2 = new Tuple2((Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.lowerLeft()).apply(row, state)), (Object)makeValueNeoSafe$.MODULE$.safeOrEmpty(((Expression)range.upperRight()).apply(row, state)));
            if (tuple2 != null) {
                Some some;
                Value lowerLeft;
                Option option = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (option instanceof Some && (lowerLeft = (Value)(some = (Some)option).value()) instanceof PointValue) {
                    Some some3;
                    Value upperRight;
                    PointValue pointValue = (PointValue)lowerLeft;
                    if (option3 instanceof Some && (upperRight = (Value)(some3 = (Some)option3).value()) instanceof PointValue) {
                        PointValue pointValue2 = (PointValue)upperRight;
                        if (pointValue.getCoordinateReferenceSystem().equals((Object)pointValue2.getCoordinateReferenceSystem())) {
                            CRSCalculator calculator = pointValue.getCoordinateReferenceSystem().getCalculator();
                            Buffer bboxes = CollectionConverters$.MODULE$.ListHasAsScala(calculator.computeBBoxes(pointValue, pointValue2)).asScala();
                            return (Seq)bboxes.map((Function1 & Serializable)bbox -> PropertyIndexQuery.boundingBox((int)propertyId, (PointValue)((PointValue)bbox.first()), (PointValue)((PointValue)bbox.other())));
                        }
                    }
                }
            }
            return Nil$.MODULE$;
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("Unexpected expression " + expression));
    }

    public static /* synthetic */ Seq computeExactQueries$(EntityIndexSeeker $this, QueryState state, ReadableRow row) {
        return $this.computeExactQueries(state, row);
    }

    default public Seq<scala.collection.immutable.Seq<PropertyIndexQuery.ExactPredicate>> computeExactQueries(QueryState state, ReadableRow row) {
        QueryExpression<Expression> queryExpression = this.valueExpr();
        if (queryExpression instanceof SingleQueryExpression) {
            SingleQueryExpression singleQueryExpression = (SingleQueryExpression)queryExpression;
            Expression expr = (Expression)singleQueryExpression.expression();
            Option option = makeValueNeoSafe$.MODULE$.safeOrEmpty(expr.apply(row, state));
            if (option instanceof Some) {
                Some some = (Some)option;
                Value seekValue = (Value)some.value();
                return Predef$.MODULE$.wrapRefArray((Object[])new List[]{new .colon.colon((Object)PropertyIndexQuery.exact((int)BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.propertyIds()))), (Object)seekValue), (List)Nil$.MODULE$)});
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            throw new MatchError((Object)option);
        }
        if (queryExpression instanceof ManyQueryExpression) {
            Option option;
            ManyQueryExpression manyQueryExpression = (ManyQueryExpression)queryExpression;
            Expression expr = (Expression)manyQueryExpression.expression();
            AnyValue anyValue = expr.apply(row, state);
            if (anyValue != null && !(option = IsList$.MODULE$.unapply(anyValue)).isEmpty()) {
                ListValue coll = (ListValue)option.get();
                return ((IterableOnceOps)Predef$.MODULE$.wrapRefArray((Object[])coll.asArray()).toSet().flatMap((Function1 & Serializable)seekAnyValue -> makeValueNeoSafe$.MODULE$.safeOrEmpty(seekAnyValue).map((Function1 & Serializable)value -> new .colon.colon((Object)PropertyIndexQuery.exact((int)BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.intArrayOps(this.propertyIds()))), (Object)value), (List)Nil$.MODULE$)))).toIndexedSeq();
            }
            if (anyValue == Values.NO_VALUE) {
                return Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(scala.collection.immutable.Seq.class)));
            }
            if (anyValue instanceof Value) {
                Value value = (Value)anyValue;
                throw CypherTypeException.expectedList((String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
            }
            throw CypherTypeException.expectedList((String)String.valueOf(anyValue), (String)String.valueOf(anyValue), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
        }
        if (queryExpression instanceof CompositeQueryExpression) {
            CompositeQueryExpression compositeQueryExpression = (CompositeQueryExpression)queryExpression;
            scala.collection.immutable.Seq exprs = compositeQueryExpression.inner();
            if (AssertionRunner.ASSERTIONS_ENABLED && exprs.lengthCompare(this.propertyIds().length) != 0) {
                throw new AssertionError((Object)"assertion failed");
            }
            scala.collection.immutable.Seq indexQueries = (scala.collection.immutable.Seq)((IterableOps)exprs.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(this.propertyIds()))).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    QueryExpression expr = (QueryExpression)tuple2._1();
                    int propId = tuple2._2$mcI$sp();
                    return (Seq)this.computeCompositeQueries(state, row, (QueryExpression<Expression>)expr, propId).flatMap((Function1 & Serializable)x0$2 -> {
                        PropertyIndexQuery propertyIndexQuery = x0$2;
                        if (propertyIndexQuery instanceof PropertyIndexQuery.ExactPredicate) {
                            PropertyIndexQuery.ExactPredicate exactPredicate = (PropertyIndexQuery.ExactPredicate)propertyIndexQuery;
                            return new Some((Object)exactPredicate);
                        }
                        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"Expected only exact for LockingUniqueIndexSeek");
                    });
                }
                throw new MatchError((Object)tuple2);
            });
            return SeqCombiner$.MODULE$.combine((Iterable)indexQueries);
        }
        throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)("Unexpected value " + queryExpression));
    }

    private Seq<PropertyIndexQuery> computeCompositeQueries(QueryState state, ReadableRow row, QueryExpression<Expression> queryExpression, int propertyId) {
        QueryExpression<Expression> queryExpression2 = queryExpression;
        if (queryExpression2 instanceof SingleQueryExpression) {
            SingleQueryExpression singleQueryExpression = (SingleQueryExpression)queryExpression2;
            Expression inner = (Expression)singleQueryExpression.expression();
            Option option = makeValueNeoSafe$.MODULE$.safeOrEmpty(inner.apply(row, state));
            if (option instanceof Some) {
                Some some = (Some)option;
                Value seekValue = (Value)some.value();
                return new .colon.colon((Object)PropertyIndexQuery.exact((int)propertyId, (Object)seekValue), (List)Nil$.MODULE$);
            }
            if (None$.MODULE$.equals(option)) {
                return (Seq)package$.MODULE$.Seq().empty();
            }
            throw new MatchError((Object)option);
        }
        if (queryExpression2 instanceof ManyQueryExpression) {
            scala.collection.immutable.Seq seq;
            Option option;
            ManyQueryExpression manyQueryExpression = (ManyQueryExpression)queryExpression2;
            Expression inner = (Expression)manyQueryExpression.expression();
            AnyValue anyValue = inner.apply(row, state);
            if (anyValue != null && !(option = IsList$.MODULE$.unapply(anyValue)).isEmpty()) {
                ListValue coll = (ListValue)option.get();
                seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)coll.asArray());
            } else if (anyValue == null) {
                seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
            } else {
                if (anyValue instanceof Value) {
                    Value value = (Value)anyValue;
                    throw CypherTypeException.expectedCollectionWasNot((String)String.valueOf(value), (String)value.prettyPrint(), (String)CypherTypeValueMapper.valueType((AnyValue)value));
                }
                throw CypherTypeException.expectedCollectionWasNot((String)String.valueOf(anyValue), (String)String.valueOf(anyValue), (String)CypherTypeValueMapper.valueType((AnyValue)anyValue));
            }
            scala.collection.immutable.Seq expr = seq;
            return (Seq)((SeqOps)expr.flatMap((Function1 & Serializable)e -> makeValueNeoSafe$.MODULE$.safeOrEmpty(e).map((Function1 & Serializable)value -> PropertyIndexQuery.exact((int)propertyId, (Object)value)))).distinct();
        }
        if (queryExpression2 instanceof CompositeQueryExpression) {
            throw InternalException.internalError((String)this.getClass().getSimpleName(), (String)"A CompositeQueryExpression can't be nested in a CompositeQueryExpression");
        }
        if (queryExpression2 instanceof RangeQueryExpression) {
            RangeQueryExpression rangeQueryExpression = (RangeQueryExpression)queryExpression2;
            Expression rangeWrapper = (Expression)rangeQueryExpression.expression();
            return this.computeRangeQueries(state, row, rangeWrapper, propertyId);
        }
        if (queryExpression2 instanceof ExistenceQueryExpression) {
            return new .colon.colon((Object)PropertyIndexQuery.exists((int)propertyId), (List)Nil$.MODULE$);
        }
        throw new MatchError(queryExpression2);
    }

    public static void $init$(EntityIndexSeeker $this) {
        $this.org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$_setter_$org$neo4j$cypher$internal$runtime$interpreted$pipes$EntityIndexSeeker$$BY_VALUE_$eq((MinMaxOrdering<Value>)new MinMaxOrdering(package$.MODULE$.Ordering().comparatorToOrdering((Comparator)Values.COMPARATOR)));
    }
}

