/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.parser.v5.ast.factory;

import java.io.IOException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.neo4j.cypher.internal.parser.lexer.CypherQueryAccess;
import org.neo4j.cypher.internal.parser.lexer.CypherToken;
import org.neo4j.cypher.internal.parser.lexer.UnicodeEscapeReplacementReader;
import org.neo4j.cypher.internal.parser.v5.Cypher5Lexer;
import org.neo4j.util.VisibleForTesting;

public final class Cypher5AstLexer
extends Cypher5Lexer
implements CypherQueryAccess {
    private final String inputQuery;
    private final int[] offsetTable;

    private Cypher5AstLexer(CharStream input, String inputQuery, int[] offsetTable) {
        super(input);
        this.inputQuery = inputQuery;
        this.offsetTable = offsetTable;
    }

    public void notifyListeners(LexerNoViableAltException e) {
        String text = this._input.getText(Interval.of((int)this._tokenStartCharIndex, (int)this._input.index()));
        String msg = "Unexpected query part: '" + this.getErrorDisplay(text) + "'";
        ANTLRErrorListener listener = this.getErrorListenerDispatch();
        Token dummyToken = this.getTokenFactory().create(this._tokenFactorySourcePair, -1, text, this._channel, this._tokenStartCharIndex, this._input.index(), this._tokenStartLine, this._tokenStartCharPositionInLine);
        listener.syntaxError((Recognizer)this, (Object)dummyToken, this._tokenStartLine, this._tokenStartCharPositionInLine, msg, (RecognitionException)e);
    }

    public static Cypher5AstLexer fromString(String cypher, boolean fullTokens) throws IOException {
        return Cypher5AstLexer.fromString(cypher, 4096, fullTokens);
    }

    @VisibleForTesting
    public static Cypher5AstLexer fromString(String cypher, int bufferSize, boolean fullTokens) throws IOException {
        UnicodeEscapeReplacementReader.Result read = UnicodeEscapeReplacementReader.read((String)cypher, (int)bufferSize);
        Cypher5AstLexer lexer = new Cypher5AstLexer(read.charStream(), cypher, read.offsetTable());
        lexer.setTokenFactory(CypherToken.factory((boolean)fullTokens));
        return lexer;
    }

    public String inputQuery() {
        return this.inputQuery;
    }

    public int[] offsetTable() {
        return this.offsetTable;
    }
}

