/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import org.neo4j.cloud.storage.io.ReadableChannel;

public class SeekableReadableChannel
implements SeekableByteChannel {
    private final ReadableChannel readChannel;
    private volatile boolean closed;

    public SeekableReadableChannel(ReadableChannel channel) {
        this.readChannel = channel;
    }

    public InputStream asStream() throws IOException {
        this.ensureOpen();
        return this.readChannel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        return this.readChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new NonWritableChannelException();
    }

    @Override
    public long position() throws IOException {
        this.ensureOpen();
        return this.readChannel.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        this.readChannel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        this.ensureOpen();
        return this.readChannel.size();
    }

    @Override
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("truncate(size)");
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.readChannel.close();
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }
}

