/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.helpers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Set;
import org.neo4j.cypher.internal.compiler.helpers.HistogramsFromConfigHelper;
import org.neo4j.cypher.internal.compiler.helpers.HistogramsFromConfigHelper$BucketFromConfig$2$;
import org.neo4j.cypher.internal.compiler.helpers.HistogramsFromConfigHelper$BucketFromConfigBuilder$2$;
import org.neo4j.cypher.internal.expressions.EntityType;
import org.neo4j.cypher.internal.expressions.NODE_TYPE$;
import org.neo4j.cypher.internal.expressions.RELATIONSHIP_TYPE$;
import org.neo4j.cypher.internal.planner.spi.DelegatingGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.GraphStatistics;
import org.neo4j.cypher.internal.planner.spi.histogram.Histogram;
import org.neo4j.cypher.internal.planner.spi.histogram.StandardBucket;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.LabelId$;
import org.neo4j.cypher.internal.util.NameId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.cypher.internal.util.RelTypeId$;
import org.neo4j.exceptions.InvalidArgumentException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;

public final class HistogramsFromConfigHelper$ {
    public static final HistogramsFromConfigHelper$ MODULE$ = new HistogramsFromConfigHelper$();

    public Function1<GraphStatistics, GraphStatistics> graphStatisticsDecoratorWithHistogramsFromConfig(scala.collection.immutable.Map<HistogramsFromConfigHelper.HistogramKey, scala.collection.immutable.Set<Histogram>> histogramsFromConfigWithIdsGrouped) {
        return (Function1 & Serializable)graphStatistics -> HistogramsFromConfigHelper$.graphStatisticsDecoratorWithHistogramsFromConfig$1(graphStatistics, histogramsFromConfigWithIdsGrouped);
    }

    public Option<HistogramsFromConfigHelper.HistogramKey> getHistogramKey(Histogram histogram, TransactionBoundReadTokenContext tokenContext) {
        Option option;
        EntityType entityType = histogram.nodeOrRelationship();
        if (NODE_TYPE$.MODULE$.equals(entityType)) {
            option = tokenContext.getOptLabelId(histogram.labelOrTypeName()).map((Function1)LabelId$.MODULE$);
        } else if (RELATIONSHIP_TYPE$.MODULE$.equals(entityType)) {
            option = tokenContext.getOptRelTypeId(histogram.labelOrTypeName()).map((Function1)RelTypeId$.MODULE$);
        } else {
            throw new MatchError((Object)entityType);
        }
        Option maybeLabelOrTypeId = option;
        Option maybePropertyKeyId = tokenContext.getOptPropertyKeyId(histogram.property()).map((Function1)PropertyKeyId$.MODULE$);
        return maybeLabelOrTypeId.flatMap((Function1 & Serializable)labelOrTypeId -> maybePropertyKeyId.map((Function1 & Serializable)propertyKeyId -> new HistogramsFromConfigHelper.HistogramKey(histogram.nodeOrRelationship(), (NameId)labelOrTypeId, (PropertyKeyId)propertyKeyId)));
    }

    public scala.collection.immutable.Set<Histogram> getHistogramsFromConfig(Set<Map<String, String>> bucketsFromConfig) {
        LazyRef BucketFromConfig$module = new LazyRef();
        LazyRef BucketFromConfigBuilder$module = new LazyRef();
        Iterable buckets = (Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala(bucketsFromConfig).asScala().map((Function1 & Serializable)bucket2 -> {
            public class Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1
            implements Product,
            Serializable {
                private final EntityType entityType;
                private final String labelOrRel;
                private final String property;
                private final double min;
                private final double max;
                private final double selectivity;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public EntityType entityType() {
                    return this.entityType;
                }

                public String labelOrRel() {
                    return this.labelOrRel;
                }

                public String property() {
                    return this.property;
                }

                public double min() {
                    return this.min;
                }

                public double max() {
                    return this.max;
                }

                public double selectivity() {
                    return this.selectivity;
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1 copy(EntityType entityType, String labelOrRel, String property, double min, double max, double selectivity) {
                    return new Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1(entityType, labelOrRel, property, min, max, selectivity);
                }

                public EntityType copy$default$1() {
                    return this.entityType();
                }

                public String copy$default$2() {
                    return this.labelOrRel();
                }

                public String copy$default$3() {
                    return this.property();
                }

                public double copy$default$4() {
                    return this.min();
                }

                public double copy$default$5() {
                    return this.max();
                }

                public double copy$default$6() {
                    return this.selectivity();
                }

                public String productPrefix() {
                    return "BucketFromConfig";
                }

                public int productArity() {
                    return 6;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return this.entityType();
                        }
                        case 1: {
                            return this.labelOrRel();
                        }
                        case 2: {
                            return this.property();
                        }
                        case 3: {
                            return BoxesRunTime.boxToDouble((double)this.min());
                        }
                        case 4: {
                            return BoxesRunTime.boxToDouble((double)this.max());
                        }
                        case 5: {
                            return BoxesRunTime.boxToDouble((double)this.selectivity());
                        }
                    }
                    return Statics.ioobe((int)x$1);
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1;
                }

                public String productElementName(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return "entityType";
                        }
                        case 1: {
                            return "labelOrRel";
                        }
                        case 2: {
                            return "property";
                        }
                        case 3: {
                            return "min";
                        }
                        case 4: {
                            return "max";
                        }
                        case 5: {
                            return "selectivity";
                        }
                    }
                    return (String)Statics.ioobe((int)x$1);
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.entityType()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.labelOrRel()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.property()));
                    n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.min()));
                    n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.max()));
                    n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.selectivity()));
                    return Statics.finalizeHash((int)n, (int)6);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1 var4_3 = (Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1)x$1;
                    if (this.min() != var4_3.min()) return false;
                    if (this.max() != var4_3.max()) return false;
                    if (this.selectivity() != var4_3.selectivity()) return false;
                    EntityType entityType = this.entityType();
                    EntityType entityType2 = var4_3.entityType();
                    if (entityType == null) {
                        if (entityType2 != null) {
                            return false;
                        }
                    } else if (!entityType.equals(entityType2)) return false;
                    String string = this.labelOrRel();
                    String string2 = var4_3.labelOrRel();
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    String string3 = this.property();
                    String string4 = var4_3.property();
                    if (string3 == null) {
                        if (string4 != null) {
                            return false;
                        }
                    } else if (!string3.equals(string4)) return false;
                    if (!var4_3.canEqual(this)) return false;
                    return true;
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1(EntityType entityType, String labelOrRel, String property, double min, double max, double selectivity) {
                    this.entityType = entityType;
                    this.labelOrRel = labelOrRel;
                    this.property = property;
                    this.min = min;
                    this.max = max;
                    this.selectivity = selectivity;
                    Product.$init$((Product)this);
                }
            }
            public class Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1
            implements Product,
            Serializable {
                private final String labelOrType;
                private final String property;
                private final double minIncl;
                private final double maxExcl;
                private final double selectivity;
                private final EntityType entityType;
                private final Regex stringRegex;

                public Iterator<String> productElementNames() {
                    return Product.productElementNames$((Product)this);
                }

                public String labelOrType() {
                    return this.labelOrType;
                }

                public String property() {
                    return this.property;
                }

                public double minIncl() {
                    return this.minIncl;
                }

                public double maxExcl() {
                    return this.maxExcl;
                }

                public double selectivity() {
                    return this.selectivity;
                }

                public EntityType entityType() {
                    return this.entityType;
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 withLabelOrType(String value) {
                    return this.copy(value, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 withProperty(String value) {
                    String x$1 = value;
                    String x$2 = this.copy$default$1();
                    double x$3 = this.copy$default$3();
                    double x$4 = this.copy$default$4();
                    double x$5 = this.copy$default$5();
                    EntityType x$6 = this.copy$default$6();
                    return this.copy(x$2, x$1, x$3, x$4, x$5, x$6);
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 withMinIncl(double value) {
                    double x$1 = value;
                    String x$2 = this.copy$default$1();
                    String x$3 = this.copy$default$2();
                    double x$4 = this.copy$default$4();
                    double x$5 = this.copy$default$5();
                    EntityType x$6 = this.copy$default$6();
                    return this.copy(x$2, x$3, x$1, x$4, x$5, x$6);
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 withMaxExcl(double value) {
                    double x$1 = value;
                    String x$2 = this.copy$default$1();
                    String x$3 = this.copy$default$2();
                    double x$4 = this.copy$default$3();
                    double x$5 = this.copy$default$5();
                    EntityType x$6 = this.copy$default$6();
                    return this.copy(x$2, x$3, x$4, x$1, x$5, x$6);
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 withSelectivity(double value) {
                    double x$1 = value;
                    String x$2 = this.copy$default$1();
                    String x$3 = this.copy$default$2();
                    double x$4 = this.copy$default$3();
                    double x$5 = this.copy$default$4();
                    EntityType x$6 = this.copy$default$6();
                    return this.copy(x$2, x$3, x$4, x$5, x$1, x$6);
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 withEntityType(EntityType value) {
                    EntityType x$1 = value;
                    String x$2 = this.copy$default$1();
                    String x$3 = this.copy$default$2();
                    double x$4 = this.copy$default$3();
                    double x$5 = this.copy$default$4();
                    double x$6 = this.copy$default$5();
                    return this.copy(x$2, x$3, x$4, x$5, x$6, x$1);
                }

                private Regex stringRegex() {
                    return this.stringRegex;
                }

                private Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 setLabelOrType(String value) {
                    Option option;
                    String string = value;
                    if (string != null && !(option = this.stringRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String l = (String)((LinearSeqOps)option.get()).apply(0);
                        return this.withLabelOrType(l);
                    }
                    throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"labelOrType", (String)value, java.util.List.of("ALPHANUMERIC STRING"));
                }

                private Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 setProperty(String value) {
                    Option option;
                    String string = value;
                    if (string != null && !(option = this.stringRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
                        String p = (String)((LinearSeqOps)option.get()).apply(0);
                        return this.withProperty(p);
                    }
                    throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"property", (String)value, java.util.List.of("ALPHANUMERIC STRING"));
                }

                private Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 setMin(String value) {
                    Option option = StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(value));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        double d = BoxesRunTime.unboxToDouble((Object)some.value());
                        return this.withMinIncl(d);
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"min", (String)value, java.util.List.of("DOUBLE"));
                    }
                    throw new MatchError((Object)option);
                }

                private Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 setMax(String value) {
                    Option option = StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(value));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        double d = BoxesRunTime.unboxToDouble((Object)some.value());
                        return this.withMaxExcl(d);
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"max", (String)value, java.util.List.of("DOUBLE"));
                    }
                    throw new MatchError((Object)option);
                }

                private Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 setSelectivity(String value) {
                    Some some;
                    double d;
                    Option option = StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(value));
                    if (option instanceof Some && (d = BoxesRunTime.unboxToDouble((Object)(some = (Some)option).value())) >= 0.0 && d <= 1.0) {
                        return this.withSelectivity(d);
                    }
                    throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"selectivity", (String)value, java.util.List.of("DOUBLE between 0.0 and 1.0"));
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 add(String key, String value) {
                    Tuple2 tuple2 = new Tuple2((Object)key, (Object)value);
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        if ("labelOrType".equals(string)) {
                            return this.setLabelOrType(value2);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String value3 = (String)tuple2._2();
                        if ("property".equals(string)) {
                            return this.setProperty(value3);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String value4 = (String)tuple2._2();
                        if ("min".equals(string)) {
                            return this.setMin(value4);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String value5 = (String)tuple2._2();
                        if ("max".equals(string)) {
                            return this.setMax(value5);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String value6 = (String)tuple2._2();
                        if ("selectivity".equals(string)) {
                            return this.setSelectivity(value6);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String string2 = (String)tuple2._2();
                        if ("entityType".equals(string) && "node".equals(string2)) {
                            return this.withEntityType((EntityType)NODE_TYPE$.MODULE$);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String string3 = (String)tuple2._2();
                        if ("entityType".equals(string) && "relationship".equals(string3)) {
                            return this.withEntityType((EntityType)RELATIONSHIP_TYPE$.MODULE$);
                        }
                    }
                    if (tuple2 != null) {
                        String string = (String)tuple2._1();
                        String value7 = (String)tuple2._2();
                        if ("entityType".equals(string)) {
                            throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"entityType", (String)value7, java.util.List.of("node", "relationship"));
                        }
                    }
                    throw new InternalError("Unexpected key-value pair in histogram builder from config");
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1 build() {
                    String string = this.labelOrType();
                    String string2 = "";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"labelOrType", (String)"", java.util.List.of("non-empty STRING"));
                    }
                    String string3 = this.property();
                    String string4 = "";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"property", (String)"", java.util.List.of("non-empty STRING"));
                    }
                    if (this.selectivity() == -1.0) {
                        throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"selectivity", (String)"", java.util.List.of("FLOAT between 0.0 and 1.0"));
                    }
                    if (this.minIncl() >= this.maxExcl()) {
                        throw InvalidArgumentException.invalidValueInHistogramFromConfig((String)"max", (String)Double.toString(this.maxExcl()), java.util.List.of("value larger than " + this.minIncl()));
                    }
                    return new Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfig$1(this.entityType(), this.labelOrType(), this.property(), this.minIncl(), this.maxExcl(), this.selectivity());
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 copy(String labelOrType, String property, double minIncl, double maxExcl, double selectivity, EntityType entityType) {
                    return new Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1(labelOrType, property, minIncl, maxExcl, selectivity, entityType);
                }

                public String copy$default$1() {
                    return this.labelOrType();
                }

                public String copy$default$2() {
                    return this.property();
                }

                public double copy$default$3() {
                    return this.minIncl();
                }

                public double copy$default$4() {
                    return this.maxExcl();
                }

                public double copy$default$5() {
                    return this.selectivity();
                }

                public EntityType copy$default$6() {
                    return this.entityType();
                }

                public String productPrefix() {
                    return "BucketFromConfigBuilder";
                }

                public int productArity() {
                    return 6;
                }

                public Object productElement(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return this.labelOrType();
                        }
                        case 1: {
                            return this.property();
                        }
                        case 2: {
                            return BoxesRunTime.boxToDouble((double)this.minIncl());
                        }
                        case 3: {
                            return BoxesRunTime.boxToDouble((double)this.maxExcl());
                        }
                        case 4: {
                            return BoxesRunTime.boxToDouble((double)this.selectivity());
                        }
                        case 5: {
                            return this.entityType();
                        }
                    }
                    return Statics.ioobe((int)x$1);
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1;
                }

                public String productElementName(int x$1) {
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            return "labelOrType";
                        }
                        case 1: {
                            return "property";
                        }
                        case 2: {
                            return "minIncl";
                        }
                        case 3: {
                            return "maxExcl";
                        }
                        case 4: {
                            return "selectivity";
                        }
                        case 5: {
                            return "entityType";
                        }
                    }
                    return (String)Statics.ioobe((int)x$1);
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.labelOrType()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.property()));
                    n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.minIncl()));
                    n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.maxExcl()));
                    n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.selectivity()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.entityType()));
                    return Statics.finalizeHash((int)n, (int)6);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1 var4_3 = (Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1)x$1;
                    if (this.minIncl() != var4_3.minIncl()) return false;
                    if (this.maxExcl() != var4_3.maxExcl()) return false;
                    if (this.selectivity() != var4_3.selectivity()) return false;
                    String string = this.labelOrType();
                    String string2 = var4_3.labelOrType();
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    String string3 = this.property();
                    String string4 = var4_3.property();
                    if (string3 == null) {
                        if (string4 != null) {
                            return false;
                        }
                    } else if (!string3.equals(string4)) return false;
                    EntityType entityType = this.entityType();
                    EntityType entityType2 = var4_3.entityType();
                    if (entityType == null) {
                        if (entityType2 != null) {
                            return false;
                        }
                    } else if (!entityType.equals(entityType2)) return false;
                    if (!var4_3.canEqual(this)) return false;
                    return true;
                }

                public Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1(String labelOrType, String property, double minIncl, double maxExcl, double selectivity, EntityType entityType) {
                    this.labelOrType = labelOrType;
                    this.property = property;
                    this.minIncl = minIncl;
                    this.maxExcl = maxExcl;
                    this.selectivity = selectivity;
                    this.entityType = entityType;
                    Product.$init$((Product)this);
                    this.stringRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^([a-zA-Z0-9_]+)$"));
                }
            }
            return ((Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1)CollectionConverters$.MODULE$.MapHasAsScala(bucket2).asScala().foldLeft((Object)new Org_neo4j_cypher_internal_compiler_helpers_HistogramsFromConfigHelper$BucketFromConfigBuilder$1(this.BucketFromConfigBuilder$3(BucketFromConfigBuilder$module).apply$default$1(), this.BucketFromConfigBuilder$3(BucketFromConfigBuilder$module).apply$default$2(), this.BucketFromConfigBuilder$3(BucketFromConfigBuilder$module).apply$default$3(), this.BucketFromConfigBuilder$3(BucketFromConfigBuilder$module).apply$default$4(), this.BucketFromConfigBuilder$3(BucketFromConfigBuilder$module).apply$default$5(), this.BucketFromConfigBuilder$3(BucketFromConfigBuilder$module).apply$default$6()), (Function2 & Serializable)(builder, bucket) -> builder.add((String)bucket._1(), (String)bucket._2()))).build();
        });
        return ((IterableOnceOps)buckets.groupBy((Function1 & Serializable)configBucket -> new Tuple3((Object)configBucket.entityType(), (Object)configBucket.labelOrRel(), (Object)configBucket.property())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple3 tuple3 = (Tuple3)tuple2._1();
                Iterable buckets = (Iterable)tuple2._2();
                if (tuple3 != null) {
                    EntityType entityType = (EntityType)tuple3._1();
                    String labelOrRel = (String)tuple3._2();
                    String property = (String)tuple3._3();
                    scala.collection.immutable.Set standardBuckets = ((IterableOnceOps)buckets.map((Function1 & Serializable)b -> new StandardBucket(b.min(), b.max(), b.selectivity()))).toSet();
                    return new Histogram(entityType, labelOrRel, property, standardBuckets);
                }
            }
            throw new MatchError((Object)tuple2);
        })).toSet();
    }

    private static final GraphStatistics graphStatisticsDecoratorWithHistogramsFromConfig$1(GraphStatistics graphStatistics, scala.collection.immutable.Map histogramsFromConfigWithIdsGrouped$1) {
        return new DelegatingGraphStatistics(graphStatistics, histogramsFromConfigWithIdsGrouped$1){
            private final scala.collection.immutable.Map histogramsFromConfigWithIdsGrouped$1;

            public scala.collection.immutable.Set<Histogram> getHistograms(scala.collection.immutable.Set<LabelId> labels, PropertyKeyId propertyKey) {
                scala.collection.immutable.Set applicableHistogramsFromConfig = (scala.collection.immutable.Set)labels.flatMap((Function1 & Serializable)labelId -> (scala.collection.immutable.Set)$this.histogramsFromConfigWithIdsGrouped$1.getOrElse((Object)new HistogramsFromConfigHelper.HistogramKey((EntityType)NODE_TYPE$.MODULE$, (NameId)labelId, propertyKey), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty()));
                return (scala.collection.immutable.Set)super.getHistograms(labels, propertyKey).$plus$plus((IterableOnce)applicableHistogramsFromConfig);
            }

            public scala.collection.immutable.Set<Histogram> getHistograms(RelTypeId typeId, PropertyKeyId propertyKey) {
                scala.collection.immutable.Set applicableHistogramsFromConfig = (scala.collection.immutable.Set)this.histogramsFromConfigWithIdsGrouped$1.getOrElse((Object)new HistogramsFromConfigHelper.HistogramKey((EntityType)RELATIONSHIP_TYPE$.MODULE$, (NameId)typeId, propertyKey), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
                return (scala.collection.immutable.Set)super.getHistograms(typeId, propertyKey).$plus$plus((IterableOnce)applicableHistogramsFromConfig);
            }
            {
                this.histogramsFromConfigWithIdsGrouped$1 = histogramsFromConfigWithIdsGrouped$1;
                super(graphStatistics$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getHistograms$1(org.neo4j.cypher.internal.compiler.helpers.HistogramsFromConfigHelper$$anon$1 org.neo4j.cypher.internal.util.PropertyKeyId org.neo4j.cypher.internal.util.LabelId ), $anonfun$getHistograms$2(), $anonfun$getHistograms$3()}, serializedLambda);
            }
        };
    }

    private static final /* synthetic */ HistogramsFromConfigHelper$BucketFromConfig$2$ BucketFromConfig$lzycompute$1(LazyRef BucketFromConfig$module$1) {
        HistogramsFromConfigHelper$BucketFromConfig$2$ histogramsFromConfigHelper$BucketFromConfig$2$;
        LazyRef lazyRef = BucketFromConfig$module$1;
        synchronized (lazyRef) {
            histogramsFromConfigHelper$BucketFromConfig$2$ = BucketFromConfig$module$1.initialized() ? (HistogramsFromConfigHelper$BucketFromConfig$2$)BucketFromConfig$module$1.value() : (HistogramsFromConfigHelper$BucketFromConfig$2$)BucketFromConfig$module$1.initialize((Object)new HistogramsFromConfigHelper$BucketFromConfig$2$());
        }
        return histogramsFromConfigHelper$BucketFromConfig$2$;
    }

    private final HistogramsFromConfigHelper$BucketFromConfig$2$ BucketFromConfig$3(LazyRef BucketFromConfig$module$1) {
        if (BucketFromConfig$module$1.initialized()) {
            return (HistogramsFromConfigHelper$BucketFromConfig$2$)BucketFromConfig$module$1.value();
        }
        return HistogramsFromConfigHelper$.BucketFromConfig$lzycompute$1(BucketFromConfig$module$1);
    }

    private static final /* synthetic */ HistogramsFromConfigHelper$BucketFromConfigBuilder$2$ BucketFromConfigBuilder$lzycompute$1(LazyRef BucketFromConfigBuilder$module$1) {
        HistogramsFromConfigHelper$BucketFromConfigBuilder$2$ histogramsFromConfigHelper$BucketFromConfigBuilder$2$;
        LazyRef lazyRef = BucketFromConfigBuilder$module$1;
        synchronized (lazyRef) {
            histogramsFromConfigHelper$BucketFromConfigBuilder$2$ = BucketFromConfigBuilder$module$1.initialized() ? (HistogramsFromConfigHelper$BucketFromConfigBuilder$2$)BucketFromConfigBuilder$module$1.value() : (HistogramsFromConfigHelper$BucketFromConfigBuilder$2$)BucketFromConfigBuilder$module$1.initialize((Object)new HistogramsFromConfigHelper$BucketFromConfigBuilder$2$());
        }
        return histogramsFromConfigHelper$BucketFromConfigBuilder$2$;
    }

    private final HistogramsFromConfigHelper$BucketFromConfigBuilder$2$ BucketFromConfigBuilder$3(LazyRef BucketFromConfigBuilder$module$1) {
        if (BucketFromConfigBuilder$module$1.initialized()) {
            return (HistogramsFromConfigHelper$BucketFromConfigBuilder$2$)BucketFromConfigBuilder$module$1.value();
        }
        return HistogramsFromConfigHelper$.BucketFromConfigBuilder$lzycompute$1(BucketFromConfigBuilder$module$1);
    }

    private HistogramsFromConfigHelper$() {
    }
}

