/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.base.Preconditions;
import org.apache.arrow.flight.FlightProducer;

public interface BackpressureStrategy {
    public void register(FlightProducer.ServerStreamListener var1);

    public WaitResult waitForListener(long var1);

    public static class CallbackBackpressureStrategy
    implements BackpressureStrategy {
        private final Object lock = new Object();
        private FlightProducer.ServerStreamListener listener;

        @Override
        public void register(FlightProducer.ServerStreamListener listener) {
            this.listener = listener;
            listener.setOnReadyHandler(this::onReady);
            listener.setOnCancelHandler(this::onCancel);
        }

        @Override
        public WaitResult waitForListener(long timeout) {
            Preconditions.checkNotNull((Object)this.listener);
            long remainingTimeout = timeout;
            long startTime = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                while (!this.listener.isReady() && !this.listener.isCancelled()) {
                    try {
                        this.lock.wait(remainingTimeout);
                        if (timeout != 0L && (remainingTimeout = startTime + timeout - System.currentTimeMillis()) <= 0L) {
                            return WaitResult.TIMEOUT;
                        }
                        if (this.shouldContinueWaiting(this.listener, remainingTimeout)) continue;
                        return WaitResult.OTHER;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return WaitResult.OTHER;
                    }
                }
                if (this.listener.isReady()) {
                    return WaitResult.READY;
                }
                if (this.listener.isCancelled()) {
                    return WaitResult.CANCELLED;
                }
                if (System.currentTimeMillis() > startTime + timeout) {
                    return WaitResult.TIMEOUT;
                }
                throw new RuntimeException("Invalid state when waiting for listener.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interruptWait() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        protected boolean shouldContinueWaiting(FlightProducer.ServerStreamListener listener, long remainingTimeout) {
            return true;
        }

        protected void readyCallback() {
        }

        protected void cancelCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onReady() {
            Object object = this.lock;
            synchronized (object) {
                this.readyCallback();
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelCallback();
                this.lock.notifyAll();
            }
        }
    }

    public static enum WaitResult {
        READY,
        CANCELLED,
        TIMEOUT,
        OTHER;

    }
}

