/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.arrow.flight.impl.Flight;

public class Location {
    private final URI uri;

    public Location(String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public Location(URI uri) {
        Objects.requireNonNull(uri);
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public SocketAddress toSocketAddress() {
        switch (this.uri.getScheme()) {
            case "grpc": 
            case "grpc+tls": 
            case "grpc+tcp": {
                return new InetSocketAddress(this.uri.getHost(), this.uri.getPort());
            }
            case "grpc+unix": {
                try {
                    return Class.forName("io.netty.channel.unix.DomainSocketAddress").asSubclass(SocketAddress.class).getConstructor(String.class).newInstance(this.uri.getPath());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }
        }
        return null;
    }

    Flight.Location toProtocol() {
        return Flight.Location.newBuilder().setUri(this.uri.toString()).build();
    }

    public static Location reuseConnection() {
        try {
            return new Location(new URI("arrow-flight-reuse-connection", "", "", "", null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Location forGrpcInsecure(String host, int port) {
        try {
            return new Location(new URI("grpc+tcp", null, host, port, null, null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Location forGrpcTls(String host, int port) {
        try {
            return new Location(new URI("grpc+tls", null, host, port, null, null, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Location forGrpcDomainSocket(String path) {
        try {
            return new Location(new URI("grpc+unix", null, path, null));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return "Location{uri=" + String.valueOf(this.uri) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return this.uri.equals(location.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }
}

