/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.arrow.flight.impl.Flight;

public class SetSessionOptionsResult {
    private final Map<String, Error> errors;

    public SetSessionOptionsResult(Map<String, Error> errors) {
        this.errors = Collections.unmodifiableMap(new HashMap<String, Error>(errors));
    }

    SetSessionOptionsResult(Flight.SetSessionOptionsResult proto) {
        this.errors = Collections.unmodifiableMap(proto.getErrors().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Error((Flight.SetSessionOptionsResult.Error)e.getValue()))));
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public Map<String, Error> getErrors() {
        return this.errors;
    }

    Flight.SetSessionOptionsResult toProtocol() {
        Flight.SetSessionOptionsResult.Builder b = Flight.SetSessionOptionsResult.newBuilder();
        b.putAllErrors(this.errors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Error)e.getValue()).toProtocol())));
        return b.build();
    }

    public ByteBuffer serialize() {
        return ByteBuffer.wrap(this.toProtocol().toByteArray());
    }

    public static SetSessionOptionsResult deserialize(ByteBuffer serialized) throws IOException {
        return new SetSessionOptionsResult(Flight.SetSessionOptionsResult.parseFrom(serialized));
    }

    public static class Error {
        public ErrorValue value;

        public Error(ErrorValue value) {
            this.value = value;
        }

        Error(Flight.SetSessionOptionsResult.Error e) {
            this.value = ErrorValue.fromProtocol(e.getValue());
        }

        Flight.SetSessionOptionsResult.Error toProtocol() {
            Flight.SetSessionOptionsResult.Error.Builder b = Flight.SetSessionOptionsResult.Error.newBuilder();
            b.setValue(this.value.toProtocol());
            return b.build();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error that = (Error)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static enum ErrorValue {
        UNSPECIFIED,
        INVALID_NAME,
        INVALID_VALUE,
        ERROR;


        static ErrorValue fromProtocol(Flight.SetSessionOptionsResult.ErrorValue s) {
            return ErrorValue.values()[s.getNumber()];
        }

        Flight.SetSessionOptionsResult.ErrorValue toProtocol() {
            return Flight.SetSessionOptionsResult.ErrorValue.values()[this.ordinal()];
        }
    }
}

