/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;

public class UnsupportedLogVersionException
extends RuntimeException {
    private final byte kernelVersion;

    UnsupportedLogVersionException(byte kernelVersion, String message) {
        super(message);
        this.kernelVersion = kernelVersion;
    }

    UnsupportedLogVersionException(byte kernelVersion, String message, Throwable cause) {
        super(message, cause);
        this.kernelVersion = kernelVersion;
    }

    public static UnsupportedLogVersionException unsupported(BinarySupportedKernelVersions binarySupportedKernelVersions, byte versionByte) {
        String msg = binarySupportedKernelVersions.latestSupportedIsLessThan(versionByte) ? String.format("Log file contains entries with prefix %d, and the highest supported Kernel Version is %s. This indicates that the log files originates from a newer version of neo4j, which we don't support downgrading from.", versionByte, binarySupportedKernelVersions) : String.format("Log file contains entries with prefix %d, and the lowest supported Kernel Version is %s. This indicates that the log files originates from an older version of neo4j, which we don't support migrations from.", versionByte, KernelVersion.EARLIEST);
        return new UnsupportedLogVersionException(versionByte, msg);
    }

    public byte getKernelVersion() {
        return this.kernelVersion;
    }
}

