/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.enveloped;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.Checksum;
import org.neo4j.io.fs.ChecksumMismatchException;
import org.neo4j.io.fs.ChecksumWriter;
import org.neo4j.io.fs.ReadPastEndException;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEnvelopeHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.TailUtils;
import org.neo4j.kernel.impl.transaction.log.enveloped.IncompleteEnvelopeReadException;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidEndOfFileReadException;
import org.neo4j.kernel.impl.transaction.log.enveloped.InvalidLogEnvelopeReadException;
import org.neo4j.kernel.impl.transaction.log.enveloped.LogBinarySearch;
import org.neo4j.kernel.impl.transaction.log.enveloped.SegmentBinarySearch;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.Preconditions;

public class EnvelopeReadChannel
implements ReadableLogChannel {
    private static final long UNSPECIFIED_SEGMENT = -1L;
    private static final byte CHECKSUM_SIZE = 4;
    private static final byte PAYLOAD_CHECKSUM_OFFSET_FROM_START = 27;
    private final Checksum checksum = (Checksum)ChecksumWriter.CHECKSUM_FACTORY.get();
    private final LogVersionBridge bridge;
    private final ScopedBuffer scopedBuffer;
    private final boolean raw;
    private final ByteBuffer buffer;
    private final int segmentBlockSize;
    private final int totalSegments;
    private final ByteBuffer checksumView;
    private final int segmentShift;
    private final int segmentMask;
    private LogVersionedStoreChannel channel;
    private LogHeader logHeader;
    private boolean enforceChecksumChain;
    protected int currentChecksum;
    protected int previousChecksum;
    protected long currentSegment;
    protected LogEnvelopeHeader.EnvelopeType payloadType;
    protected long currentIndex = -1L;
    protected long currentTerm = -1L;
    protected byte currentContentType = (byte)-1;
    protected byte payloadVersion;
    protected int payloadStartOffset;
    protected int payloadEndOffset;
    private volatile boolean closed;

    public EnvelopeReadChannel(LogVersionedStoreChannel startingChannel, int segmentBlockSize, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw) throws IOException {
        this(startingChannel, segmentBlockSize, -1, bridge, raw, (ScopedBuffer)new NativeScopedBuffer(segmentBlockSize, ByteOrder.LITTLE_ENDIAN, memoryTracker));
    }

    public EnvelopeReadChannel(LogVersionedStoreChannel startingChannel, int segmentBlockSize, int totalSegments, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw) throws IOException {
        this(startingChannel, segmentBlockSize, totalSegments, bridge, raw, (ScopedBuffer)new NativeScopedBuffer(segmentBlockSize, ByteOrder.LITTLE_ENDIAN, memoryTracker));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvelopeReadChannel(LogVersionedStoreChannel startingChannel, int segmentBlockSize, int totalSegments, LogVersionBridge bridge, boolean raw, ScopedBuffer scopedBuffer) throws IOException {
        this.channel = Objects.requireNonNull(startingChannel);
        Preconditions.requirePowerOfTwo((long)segmentBlockSize);
        this.segmentBlockSize = segmentBlockSize;
        this.totalSegments = totalSegments;
        this.segmentShift = 31 - Integer.numberOfLeadingZeros(segmentBlockSize);
        this.segmentMask = segmentBlockSize - 1;
        this.bridge = Objects.requireNonNull(bridge);
        this.raw = raw;
        boolean successfulInitialization = false;
        this.scopedBuffer = scopedBuffer;
        try {
            this.buffer = scopedBuffer.getBuffer();
            this.checksumView = this.buffer.duplicate().order(this.buffer.order());
            long startPosition = this.channel.position();
            this.readAndValidateFileHeader();
            if (startPosition < (long)segmentBlockSize) {
                startPosition = segmentBlockSize;
            }
            LogPositionMarker positionMarker = new LogPositionMarker();
            positionMarker.mark(this.channel.getLogVersion(), startPosition);
            this.setLogPosition(positionMarker);
            successfulInitialization = true;
        }
        finally {
            if (!successfulInitialization) {
                scopedBuffer.close();
            }
        }
    }

    public long alignWithStartEntry() throws IOException {
        try {
            if (this.payloadType == null) {
                this.readEnvelopeHeader();
            } else {
                this.buffer.position(this.payloadStartOffset);
            }
            if (this.payloadType != LogEnvelopeHeader.EnvelopeType.FULL && this.payloadType != LogEnvelopeHeader.EnvelopeType.BEGIN) {
                this.goToNextEntry();
            }
            return this.position() - 31L;
        }
        catch (ReadPastEndException e) {
            this.buffer.position(this.payloadEndOffset);
            return this.position();
        }
    }

    public long entryIndex() {
        return this.currentIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogPosition firstEntryPosition() throws IOException {
        long currentPosition = this.position();
        try {
            this.position(this.logHeader().getStartPosition().getByteOffset());
            long pos = this.alignWithStartEntry();
            LogPosition logPosition = new LogPosition(this.getLogVersion(), pos);
            return logPosition;
        }
        finally {
            this.position(currentPosition);
        }
    }

    public long currentTerm() {
        return this.currentTerm;
    }

    @Override
    public long getLogVersion() {
        return this.channel.getLogVersion();
    }

    @Override
    public LogFormat getLogFormatVersion() {
        return this.channel.getLogFormatVersion();
    }

    public long position() {
        return this.currentSegment * (long)this.segmentBlockSize + (long)this.buffer.position();
    }

    @Override
    public void resetToPosition(long byteOffset) throws IOException {
        this.currentSegment = -1L;
        this.position(byteOffset);
    }

    public void position(long byteOffset) throws IOException {
        Preconditions.requireNonNegative((long)byteOffset);
        LogPositionMarker positionMarker = new LogPositionMarker();
        positionMarker.mark(this.channel.getLogVersion(), byteOffset);
        this.setLogPosition(positionMarker);
    }

    @Override
    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.channel.getLogVersion(), this.position());
        return positionMarker;
    }

    @Override
    public LogPosition getCurrentLogPosition() throws IOException {
        return new LogPosition(this.channel.getLogVersion(), this.position());
    }

    @Override
    public void setLogPosition(LogPositionMarker positionMarker) throws IOException {
        if (positionMarker.getLogVersion() != this.channel.getLogVersion()) {
            throw new IllegalArgumentException("Trying to set position with version %d while channel have version %d".formatted(positionMarker.getLogVersion(), this.channel.getLogVersion()));
        }
        long byteOffset = positionMarker.getByteOffset();
        long newSegment = byteOffset >> this.segmentShift;
        int newBufferOffset = this.getSegmentOffset(byteOffset);
        if (newSegment == 0L) {
            throw new IOException("Invalid position " + String.valueOf(positionMarker));
        }
        if (newSegment == this.currentSegment) {
            if (newBufferOffset < this.payloadStartOffset || newBufferOffset > this.payloadEndOffset) {
                this.readAllEnvelopesUpToIncluding(newBufferOffset, false);
            }
        } else {
            this.loadSegmentIntoBuffer(newSegment);
            if (newBufferOffset != 0 || newSegment == 1L) {
                this.readAllEnvelopesUpToIncluding(newBufferOffset, false);
            } else {
                this.payloadType = null;
                this.enforceChecksumChain = false;
            }
        }
        Preconditions.checkState((newBufferOffset == 0 || newBufferOffset <= this.payloadEndOffset ? 1 : 0) != 0, (String)"Invalid end of payload.");
        this.buffer.position(Math.max(newBufferOffset, this.payloadStartOffset));
    }

    public int temporaryFindPreviousChecksumBeforePosition(long byteOffset) throws IOException {
        long newSegment = byteOffset >> this.segmentShift;
        int newBufferOffset = this.getSegmentOffset(byteOffset);
        if (newSegment == 0L) {
            throw new IOException("Invalid position " + byteOffset);
        }
        if (newBufferOffset == 0 && newSegment != 1L) {
            --newSegment;
            newBufferOffset = this.segmentBlockSize;
        }
        if (newSegment != this.currentSegment) {
            this.loadSegmentIntoBuffer(newSegment);
        }
        this.readAllEnvelopesUpToIncluding(newBufferOffset, true);
        Preconditions.checkState((newBufferOffset == 0 || newBufferOffset <= this.payloadEndOffset ? 1 : 0) != 0, (String)"Invalid end of payload.");
        this.buffer.position(Math.max(newBufferOffset, this.payloadStartOffset));
        return this.currentChecksum;
    }

    public void beginChecksum() {
    }

    public void setPositionUnsafe(long byteOffset) throws IOException {
        long newSegment = byteOffset >> this.segmentShift;
        int newBufferOffset = this.getSegmentOffset(byteOffset);
        if (newSegment != this.currentSegment) {
            this.loadSegmentIntoBuffer(newSegment);
        }
        this.buffer.position(newBufferOffset);
        this.payloadType = null;
        this.enforceChecksumChain = false;
        this.readEnvelopeHeader();
    }

    public long goToEntry(long entryIndex) throws IOException {
        if (entryIndex < this.logHeader.getLastAppendIndex()) {
            throw new IllegalArgumentException("Invalid entry index " + entryIndex + " is in a previous log file");
        }
        SegmentBinarySearch segmentBinarySearch = new SegmentBinarySearch(this, this.totalSegments, this.segmentBlockSize);
        long segmentPosition = LogBinarySearch.binarySearch(segmentBinarySearch, entryIndex);
        if (segmentPosition != -1L && segmentPosition != this.position()) {
            this.position(segmentPosition);
        }
        while (this.currentIndex < entryIndex) {
            this.goToNextEntry();
        }
        return this.position() - 31L;
    }

    public int endChecksumAndValidate() {
        return this.currentChecksum;
    }

    public int getChecksum() {
        return this.currentChecksum;
    }

    public int getPreviousChecksum() {
        return this.previousChecksum;
    }

    @Override
    public byte markAndGetVersion(LogPositionMarker marker) throws IOException {
        this.getCurrentLogPosition(marker);
        if (this.checkForEndOfEnvelope()) {
            this.readEnvelopeHeader();
        }
        Preconditions.checkState((this.payloadVersion != -1 ? 1 : 0) != 0, (String)"Could not find a valid envelope header.");
        if (!marker.isMarkerInLog(this.channel.getLogVersion())) {
            marker.mark(this.channel.getLogVersion(), this.position() - 31L);
        }
        return this.payloadVersion;
    }

    @Override
    public boolean rewindAfterMarkAndGetVersion() {
        return false;
    }

    public byte get() throws IOException {
        this.ensureDataExists(1);
        return this.buffer.get();
    }

    public short getShort() throws IOException {
        this.ensureDataExists(2);
        return this.buffer.getShort();
    }

    public int getInt() throws IOException {
        this.ensureDataExists(4);
        return this.buffer.getInt();
    }

    public long getLong() throws IOException {
        this.ensureDataExists(8);
        return this.buffer.getLong();
    }

    public float getFloat() throws IOException {
        this.ensureDataExists(4);
        return this.buffer.getFloat();
    }

    public double getDouble() throws IOException {
        this.ensureDataExists(8);
        return this.buffer.getDouble();
    }

    public void get(byte[] bytes, int length) throws IOException {
        assert (length <= bytes.length);
        try {
            int chunkSize;
            for (int bytesRead = 0; bytesRead < length; bytesRead += chunkSize) {
                if (this.checkForEndOfEnvelope()) {
                    this.readEnvelopeHeader();
                }
                chunkSize = Math.min(this.payloadEndOffset - this.buffer.position(), length - bytesRead);
                this.ensureDataExists(chunkSize);
                this.buffer.get(bytes, bytesRead, chunkSize);
            }
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
    }

    public byte getVersion() throws IOException {
        if (this.checkForEndOfEnvelope()) {
            this.readEnvelopeHeader();
        }
        return this.payloadVersion;
    }

    public long getAppendIndex() throws IOException {
        return this.entryIndex();
    }

    public long goToNextEntry() throws IOException {
        do {
            this.goToNextEnvelope();
        } while (this.payloadType != LogEnvelopeHeader.EnvelopeType.FULL && this.payloadType != LogEnvelopeHeader.EnvelopeType.BEGIN);
        return this.position() - 31L;
    }

    public long goToNextEnvelope() throws IOException {
        this.skipToNextEnvelope();
        this.readEnvelopeHeader();
        return this.position() - 31L;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.channel.close();
            this.scopedBuffer.close();
            this.channel = null;
            this.closed = true;
        }
    }

    public LogHeader logHeader() {
        return this.logHeader;
    }

    LogVersionedStoreChannel channel() {
        return this.channel;
    }

    private void readAllEnvelopesUpToIncluding(int bufferOffset, boolean forceReadingEvenIfAtEnd) throws IOException {
        assert (this.currentSegment != 0L);
        this.payloadType = null;
        this.enforceChecksumChain = false;
        this.payloadVersion = (byte)-1;
        this.buffer.position(0);
        this.payloadStartOffset = 0;
        this.payloadEndOffset = 0;
        if (bufferOffset == this.buffer.limit() && !forceReadingEvenIfAtEnd) {
            this.buffer.position(bufferOffset);
            this.payloadStartOffset = bufferOffset;
            this.payloadEndOffset = bufferOffset;
            return;
        }
        if (this.currentSegment == 1L) {
            this.consumeStartOffsetEnvelopeIfPresent();
            if (this.logHeader != null) {
                this.currentChecksum = this.previousChecksum = this.logHeader.getPreviousLogFileChecksum();
                this.enforceChecksumChain = true;
            }
            if (bufferOffset <= this.buffer.position()) {
                return;
            }
        }
        while (this.payloadEndOffset < bufferOffset) {
            this.readEnvelopeHeader();
            this.skipToNextEnvelope();
        }
    }

    private void consumeStartOffsetEnvelopeIfPresent() throws IOException {
        assert (this.buffer.position() == 0) : "buffer was not positioned at 0 when started checking for START_OFFSET";
        this.buffer.getInt();
        LogEnvelopeHeader.EnvelopeType type = LogEnvelopeHeader.EnvelopeType.of(this.buffer.get());
        if (type == LogEnvelopeHeader.EnvelopeType.START_OFFSET) {
            int offsetLength = this.buffer.getInt();
            assert (offsetLength > 0) : "START_OFFSET payload length should be bigger than 0";
            this.buffer.position(31);
            this.enforceZeros(offsetLength);
            assert (this.buffer.position() == 31 + offsetLength) : "buffer should have been positioned after START_OFFSET envelope";
            this.payloadStartOffset = this.buffer.position();
            this.payloadEndOffset = this.buffer.position();
        } else {
            this.buffer.position(0);
        }
    }

    private void skipToNextEnvelope() throws IOException {
        try {
            this.buffer.position(this.payloadEndOffset);
        }
        catch (IllegalArgumentException e) {
            this.buffer.position(this.buffer.limit());
            TailUtils.checkTail(this, new LogPosition(this.channel.getLogVersion(), this.currentSegment * (long)this.segmentBlockSize + (long)this.payloadStartOffset), e);
            throw new IncompleteEnvelopeReadException("Could not go to end of envelope", e);
        }
    }

    private void ensureDataExists(int requestedNumberOfBytes) throws IOException {
        try {
            if (this.checkForEndOfEnvelope()) {
                this.readEnvelopeHeader();
            }
            this.bufferCheck(requestedNumberOfBytes);
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
    }

    private void handleClosedChannelException(ClosedChannelException e) throws ClosedChannelException {
        if (this.channel == null || !this.channel.isOpen()) {
            throw new IllegalStateException("This log channel has been closed", e);
        }
        throw e;
    }

    private void bufferCheck(int requestedNumberOfBytes) throws IOException {
        if (this.buffer.remaining() < requestedNumberOfBytes) {
            throw new IncompleteEnvelopeReadException("Entry underflow. %d bytes was requested but only %d are available.".formatted(requestedNumberOfBytes, this.buffer.remaining()));
        }
    }

    private boolean checkForEndOfEnvelope() {
        assert (this.buffer.position() <= this.payloadEndOffset) : "Should not read past envelope";
        return this.buffer.position() == this.payloadEndOffset;
    }

    private void enforceTerminalZeros() throws IOException {
        this.enforceZeros(this.buffer.remaining());
    }

    private void enforceZeros(int length) throws IOException {
        Preconditions.checkState((length <= this.buffer.remaining() ? 1 : 0) != 0, (String)"Tried to enforce more zeros (%d) than the buffer's remaining size (%d).", (Object[])new Object[]{length, this.buffer.remaining()});
        while (length >= 8) {
            long value = this.buffer.getLong();
            if (value != 0L) {
                this.buffer.position(this.buffer.position() - 8);
                break;
            }
            length -= 8;
        }
        while (length > 0) {
            byte value = this.buffer.get();
            if (value != 0) {
                this.buffer.position(this.buffer.position() - 1);
                this.printExcessData();
            }
            --length;
        }
    }

    private void printExcessData() throws InvalidLogEnvelopeReadException {
        long position = this.position();
        int remaining = Math.min(this.buffer.remaining(), 1024);
        byte[] excess = new byte[remaining];
        this.buffer.get(excess);
        throw new InvalidLogEnvelopeReadException("Unexpected data found at end of buffer at position " + position + ". Expecting only zeros at this point. Found: " + Arrays.toString(excess));
    }

    protected void readEnvelopeHeader() throws IOException {
        LogEnvelopeHeader.EnvelopeType nextEnvelopeType;
        int nextEnvelopeChecksum;
        block14: {
            int remaining;
            while (true) {
                if (this.buffer.remaining() <= 31) {
                    if (this.buffer.capacity() - this.buffer.position() > 31) {
                        this.checkIfIncompleteEnvelopeHeader();
                    } else {
                        this.enforceTerminalZeros();
                    }
                    this.nextSegment(true);
                }
                nextEnvelopeChecksum = this.buffer.getInt();
                nextEnvelopeType = LogEnvelopeHeader.EnvelopeType.of(this.buffer.get());
                if (nextEnvelopeType == LogEnvelopeHeader.EnvelopeType.START_OFFSET) {
                    this.consumeStartOffsetEnvelopeIfValid();
                    continue;
                }
                if (nextEnvelopeType != LogEnvelopeHeader.EnvelopeType.ZERO) break block14;
                if (nextEnvelopeChecksum != 0) {
                    LogPosition currentLogPosition = this.getCurrentLogPosition();
                    TailUtils.checkTail(this, currentLogPosition, null);
                    throw new IncompleteEnvelopeReadException("Unexpected data found at " + String.valueOf(new LogPosition(currentLogPosition.getLogVersion(), currentLogPosition.getByteOffset() - 4L - 1L)) + " Found: " + nextEnvelopeChecksum);
                }
                remaining = this.buffer.remaining();
                this.enforceTerminalZeros();
                if (remaining >= 39) break;
            }
            this.buffer.position(this.buffer.position() - remaining - 5);
            throw ReadPastEndException.INSTANCE;
        }
        int nextPayloadLength = this.buffer.getInt();
        long nextPayloadIndex = this.buffer.getLong();
        byte nextPayloadVersion = this.buffer.get();
        int previousEnvelopeChecksumFromHeader = this.buffer.getInt();
        long nextTerm = this.buffer.getLong();
        byte nextContentType = this.buffer.get();
        this.payloadType = nextEnvelopeType;
        this.payloadVersion = nextPayloadVersion;
        this.currentIndex = nextPayloadIndex;
        this.currentTerm = nextTerm;
        this.currentContentType = nextContentType;
        this.payloadStartOffset = this.buffer.position();
        this.payloadEndOffset = this.payloadStartOffset + nextPayloadLength;
        if (this.payloadEndOffset > this.segmentBlockSize) {
            throw new InvalidLogEnvelopeReadException("Envelope span segment boundary: start=%d, length=%d, segmentBlockSize=%d".formatted(this.payloadStartOffset, nextPayloadLength, this.segmentBlockSize));
        }
        if (this.enforceChecksumChain) {
            if (this.currentChecksum != previousEnvelopeChecksumFromHeader) {
                if (nextTerm == 0L && nextContentType == 0) {
                    LogPosition currentLogPosition = this.getCurrentLogPosition();
                    try {
                        TailUtils.checkTail(this, currentLogPosition, null);
                        throw new IncompleteEnvelopeReadException("Found incomplete envelope header, incomplete at previousChecksum " + String.valueOf(new LogPosition(currentLogPosition.getLogVersion(), currentLogPosition.getByteOffset() - 8L - 1L)) + " Found: " + previousEnvelopeChecksumFromHeader);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                throw new ChecksumMismatchException("Envelope checksum chain is broken. Previous checksum '%d', expected: '%d'.", (long)this.currentChecksum, (long)previousEnvelopeChecksumFromHeader);
            }
        } else {
            this.enforceChecksumChain = true;
        }
        this.currentChecksum = nextEnvelopeChecksum;
        this.previousChecksum = previousEnvelopeChecksumFromHeader;
        this.checksumView.limit(this.payloadEndOffset).position(this.payloadStartOffset - 27);
        this.checksum.reset();
        this.checksum.update(this.checksumView);
        int readChecksum = (int)this.checksum.getValue();
        if (readChecksum != nextEnvelopeChecksum) {
            this.throwOnMismatchingChecksum(nextEnvelopeChecksum, readChecksum);
        }
    }

    private void consumeStartOffsetEnvelopeIfValid() throws IOException {
        int alreadyRead = 5;
        if (this.currentSegment != 1L || this.buffer.position() != alreadyRead) {
            throw new InvalidLogEnvelopeReadException(LogEnvelopeHeader.EnvelopeType.START_OFFSET, this.currentSegment, this.buffer.position() - alreadyRead);
        }
        this.buffer.position(0);
        this.consumeStartOffsetEnvelopeIfPresent();
    }

    private void throwOnMismatchingChecksum(int nextEnvelopeChecksum, int readChecksum) throws IOException {
        ChecksumMismatchException e = new ChecksumMismatchException((long)nextEnvelopeChecksum, (long)readChecksum);
        if (this.buffer.limit() >= this.payloadEndOffset) {
            this.buffer.position(this.payloadEndOffset);
            try {
                TailUtils.checkTail(this, this.getCurrentLogPosition(), null);
            }
            catch (IllegalStateException exception) {
                throw e;
            }
        }
        throw new IncompleteEnvelopeReadException((Throwable)e);
    }

    private void checkIfIncompleteEnvelopeHeader() throws IOException {
        assert (this.buffer.remaining() <= 31);
        try {
            this.enforceTerminalZeros();
        }
        catch (InvalidLogEnvelopeReadException e) {
            TailUtils.checkTail(this, this.getCurrentLogPosition(), e);
            throw new IncompleteEnvelopeReadException("Found incomplete envelope header", e);
        }
    }

    private void nextSegment(boolean enforceChannelIntegrityForce) throws IOException {
        int read;
        if (this.channel.size() == this.channel.position()) {
            do {
                this.goToNextFileOrThrow(enforceChannelIntegrityForce);
            } while (this.buffer.position() == this.buffer.limit() && this.channel.size() == this.channel.position());
            read = this.loadSegmentIntoBuffer(1L);
        } else {
            read = this.loadSegmentIntoBuffer(this.currentSegment + 1L);
            if (read == -1) {
                --this.currentSegment;
                this.goToNextFileOrThrow(enforceChannelIntegrityForce);
                read = this.loadSegmentIntoBuffer(1L);
            }
        }
        if (read < 31) {
            if (read < 1) {
                throw ReadPastEndException.INSTANCE;
            }
            byte[] excess = new byte[read];
            this.buffer.get(excess);
            throw new IncompleteEnvelopeReadException("Unexpected data found at start of buffer - expecting a valid header. Found: " + Arrays.toString(excess));
        }
    }

    private void goToNextFileOrThrow(boolean enforceChannelIntegrityChecks) throws IOException {
        LogVersionedStoreChannel nextChannel = this.bridge.next(this.channel, this.raw);
        assert (nextChannel != null);
        if (nextChannel == this.channel) {
            if (this.payloadType == LogEnvelopeHeader.EnvelopeType.BEGIN || this.payloadType == LogEnvelopeHeader.EnvelopeType.MIDDLE) {
                throw new InvalidEndOfFileReadException("Log file with version %d ended with an incomplete record type(%s) and no following log file could be found.".formatted(this.channel.getLogVersion(), this.payloadType.name()));
            }
            throw ReadPastEndException.INSTANCE;
        }
        this.setNextChannel(nextChannel, enforceChannelIntegrityChecks);
    }

    public void setNextChannel(LogVersionedStoreChannel nextChannel, boolean enforceChannelIntegrityChecks) throws IOException {
        this.channel = nextChannel;
        if (!enforceChannelIntegrityChecks) {
            this.enforceChecksumChain = false;
            this.payloadType = null;
        }
        this.readAndValidateFileHeader();
    }

    private void readAndValidateFileHeader() throws IOException {
        int read = this.loadSegmentIntoBuffer(0L);
        if (read < this.segmentBlockSize) {
            return;
        }
        this.logHeader = LogFormat.parseHeader((ByteBuffer)this.buffer, (boolean)true, null);
        if (this.logHeader == null) {
            return;
        }
        if (!this.enforceChecksumChain) {
            Preconditions.checkState((this.payloadType == null ? 1 : 0) != 0, (String)"Can not override checksum in the middle of a payload");
            this.currentChecksum = this.previousChecksum = this.logHeader.getPreviousLogFileChecksum();
        }
        this.enforceChecksumChain = true;
        Preconditions.checkState((this.segmentBlockSize == this.logHeader.getSegmentBlockSize() ? 1 : 0) != 0, (String)"Changing segmentBlockSize not supported");
        Preconditions.checkState((LogFormat.V10.getVersionByte() >= this.logHeader.getLogFormatVersion().getVersionByte() ? 1 : 0) != 0, (String)"Envelopes are not supported in old versions");
        Preconditions.checkState((this.currentChecksum == this.logHeader.getPreviousLogFileChecksum() ? 1 : 0) != 0, (String)("Checksum chain broken. " + this.currentChecksum + " " + this.logHeader.getPreviousLogFileChecksum()));
        this.enforceZeros(this.segmentBlockSize - this.buffer.position());
    }

    private int loadSegmentIntoBuffer(long newSegment) throws IOException {
        this.buffer.clear();
        this.channel.position(newSegment * (long)this.segmentBlockSize);
        int totalRead = 0;
        while (this.buffer.hasRemaining()) {
            int read = this.channel.read(this.buffer);
            if (read == -1) {
                if (totalRead != 0) break;
                totalRead = -1;
                break;
            }
            totalRead += read;
        }
        this.buffer.flip();
        this.currentSegment = newSegment;
        this.payloadStartOffset = 0;
        this.payloadEndOffset = 0;
        return totalRead;
    }

    public int read(ByteBuffer dst) throws IOException {
        int length = dst.remaining();
        try {
            int chunkSize;
            for (int bytesRead = 0; bytesRead < length; bytesRead += chunkSize) {
                if (this.checkForEndOfEnvelope()) {
                    this.readEnvelopeHeader();
                }
                chunkSize = Math.min(this.payloadEndOffset - this.buffer.position(), length - bytesRead);
                dst.put(dst.position(), this.buffer, this.buffer.position(), chunkSize);
                dst.position(dst.position() + chunkSize);
                this.buffer.position(this.buffer.position() + chunkSize);
            }
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
        return length;
    }

    public int directRead(ByteBuffer dst) throws IOException {
        int length = dst.remaining();
        try {
            int chunkSize;
            this.payloadType = LogEnvelopeHeader.EnvelopeType.ZERO;
            for (int bytesRead = 0; bytesRead < length; bytesRead += chunkSize) {
                if (this.buffer.position() == this.buffer.limit()) {
                    this.nextSegment(true);
                }
                chunkSize = Math.min(this.buffer.remaining(), length - bytesRead);
                dst.put(dst.position(), this.buffer, this.buffer.position(), chunkSize);
                dst.position(dst.position() + chunkSize);
                this.buffer.position(this.buffer.position() + chunkSize);
            }
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
        return length;
    }

    public void reReadSegment() throws IOException {
        LogPositionMarker logPositionMarker = new LogPositionMarker();
        LogPositionMarker currentLogPosition = this.getCurrentLogPosition(logPositionMarker);
        this.currentSegment = -1L;
        this.setLogPosition(currentLogPosition);
    }

    public void goToNextSegment() throws IOException {
        this.enforceChecksumChain = false;
        this.nextSegment(false);
        long position = this.goToNextEnvelope();
        this.enforceChecksumChain = true;
        this.buffer.position(this.getSegmentOffset(position));
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getSegmentOffset(long position) {
        return (int)position & this.segmentMask;
    }

    public String toString() {
        return "EnvelopeReadChannel{, previousChecksum=" + this.previousChecksum + ", checksumView=" + String.valueOf(this.checksumView) + ", currentSegment=" + this.currentSegment + ", payloadType=" + String.valueOf((Object)this.payloadType) + ", currentIndex=" + this.currentIndex + ", currentTerm=" + this.currentTerm + ", currentContentType=" + this.currentContentType + ", payloadVersion=" + this.payloadVersion + ", payloadStartOffset=" + this.payloadStartOffset + ", payloadEndOffset=" + this.payloadEndOffset + ", logHeader=" + String.valueOf(this.logHeader) + ", closed=" + this.closed + "}";
    }
}

