/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.fabric.stream.FragmentResult;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.Records;
import org.neo4j.fabric.stream.summary.PlanlessSummary;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.scheduler.CallableExecutor;

public class RemoteBatchExecutor {
    private final CallableExecutor executor;
    private final Function<Record, FragmentResult> fragmentExecutor;
    private final int bufferSize;
    private final int concurrency;

    public RemoteBatchExecutor(CallableExecutor executor, Function<Record, FragmentResult> fragmentExecutor, int bufferSize, int concurrency) {
        this.executor = executor;
        this.fragmentExecutor = fragmentExecutor;
        this.bufferSize = bufferSize;
        this.concurrency = concurrency;
    }

    FragmentResult execute(List<Record> batchInput, boolean unitInner) {
        if (batchInput.isEmpty()) {
            throw new IllegalArgumentException("batchInput is empty");
        }
        AtomicBoolean streamingAborted = new AtomicBoolean(false);
        ArrayBlockingQueue<RemoteStreamEvent> queue = new ArrayBlockingQueue<RemoteStreamEvent>(this.bufferSize);
        List<Future<FragmentResult>> futures = batchInput.stream().map(record -> this.executor.submit(() -> {
            FragmentResult fragmentResult = this.fragmentExecutor.apply((Record)record);
            this.startStreaming((BlockingQueue<RemoteStreamEvent>)queue, streamingAborted, fragmentResult, (Record)record, unitInner);
            return fragmentResult;
        })).toList();
        List<FragmentResult> allResults = this.getAllResults(futures, failure -> this.startStreaming(queue, streamingAborted, new FailureResult((RuntimeException)failure), null, unitInner));
        Supplier<PlanlessSummary> combinedSummaries = () -> allResults.stream().map(FragmentResult::consume).reduce(PlanlessSummary::merge).orElse(null);
        return new RemoteBatch(batchInput.size(), combinedSummaries, queue, streamingAborted);
    }

    private List<FragmentResult> getAllResults(List<Future<FragmentResult>> futures, Consumer<RuntimeException> delayedFailureHandler) {
        ArrayList<FragmentResult> results = new ArrayList<FragmentResult>();
        for (Future<FragmentResult> future : futures) {
            try {
                results.add(future.get());
            }
            catch (ExecutionException e) {
                RuntimeException cause = (RuntimeException)e.getCause();
                if (RemoteBatchExecutor.conclusiveException(cause)) {
                    throw cause;
                }
                delayedFailureHandler.accept(cause);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    int batchSize() {
        return this.concurrency;
    }

    private void startStreaming(BlockingQueue<RemoteStreamEvent> queue, AtomicBoolean streamingAborted, FragmentResult fragmentResult, Record inputRecord, boolean unitInner) {
        this.executor.execute((Runnable)new RemoteStreamWorker(queue, streamingAborted, fragmentResult, inputRecord, unitInner));
    }

    private static void handleCollectedErrors(List<RuntimeException> failures) {
        if (failures.isEmpty()) {
            return;
        }
        throw failures.stream().filter(RemoteBatchExecutor::conclusiveException).findAny().orElseGet(failures::getFirst);
    }

    private static boolean conclusiveException(Exception e) {
        Status.HasStatus exceptionWithStatus;
        return e instanceof Status.HasStatus && (exceptionWithStatus = (Status.HasStatus)e).status() != Status.Transaction.Terminated;
    }

    private static class RemoteBatch
    implements FragmentResult {
        private final BlockingQueue<RemoteStreamEvent> queue;
        private final AtomicBoolean streamingAborted;
        private final Supplier<PlanlessSummary> combinedSummaries;
        private int activeRemoteStreams;
        private final List<RuntimeException> failures = new ArrayList<RuntimeException>();

        private RemoteBatch(int activeRemoteStream, Supplier<PlanlessSummary> combinedSummaries, BlockingQueue<RemoteStreamEvent> queue, AtomicBoolean streamingAborted) {
            this.queue = queue;
            this.streamingAborted = streamingAborted;
            this.activeRemoteStreams = activeRemoteStream;
            this.combinedSummaries = combinedSummaries;
        }

        @Override
        public List<String> columns() {
            return List.of();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Record next() {
            do lbl-1000:
            // 3 sources

            {
                try {
                    event = this.queue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                Objects.requireNonNull(event);
                var3_4 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RemoteStreamEvent.Data.class, RemoteStreamEvent.Failure.class, RemoteStreamEvent.StreamExhausted.class}, (Object)var2_2, var3_4)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        data = (RemoteStreamEvent.Data)var2_2;
                        return data.record;
                    }
                    case 1: {
                        failure = (RemoteStreamEvent.Failure)var2_2;
                        this.failures.add(failure.e);
                        --this.activeRemoteStreams;
                        if (this.activeRemoteStreams != 0) ** GOTO lbl-1000
                        this.handleCollectedErrors();
                        return null;
                    }
                    case 2: 
                }
                exhaustedEvent = (RemoteStreamEvent.StreamExhausted)var2_2;
                --this.activeRemoteStreams;
            } while (this.activeRemoteStreams != 0);
            this.handleCollectedErrors();
            return null;
        }

        @Override
        public PlanlessSummary consume() {
            this.streamingAborted.set(true);
            return this.combinedSummaries.get();
        }

        @Override
        public QueryExecutionType executionType() {
            throw new UnsupportedOperationException();
        }

        private void handleCollectedErrors() {
            RemoteBatchExecutor.handleCollectedErrors(this.failures);
        }
    }

    private static class RemoteStreamWorker
    implements Runnable {
        private final BlockingQueue<RemoteStreamEvent> queue;
        private final AtomicBoolean streamingAborted;
        private final FragmentResult fragmentResult;
        private final Record inputRecord;
        private final boolean unitInner;

        private RemoteStreamWorker(BlockingQueue<RemoteStreamEvent> queue, AtomicBoolean streamingAborted, FragmentResult fragmentResult, Record inputRecord, boolean unitInner) {
            this.queue = queue;
            this.streamingAborted = streamingAborted;
            this.fragmentResult = fragmentResult;
            this.inputRecord = inputRecord;
            this.unitInner = unitInner;
        }

        @Override
        public void run() {
            while (!this.streamingAborted.get()) {
                Record record;
                try {
                    record = this.fragmentResult.next();
                }
                catch (RuntimeException e) {
                    this.enqueue(new RemoteStreamEvent.Failure(e));
                    return;
                }
                if (record == null) {
                    if (this.unitInner) {
                        this.enqueue(new RemoteStreamEvent.Data(this.inputRecord));
                    }
                    this.enqueue(new RemoteStreamEvent.StreamExhausted());
                    return;
                }
                this.enqueue(new RemoteStreamEvent.Data(Records.join(this.inputRecord, record)));
            }
        }

        private void enqueue(RemoteStreamEvent event) {
            try {
                while (!this.queue.offer(event, 100L, TimeUnit.MICROSECONDS)) {
                    if (!this.streamingAborted.get()) continue;
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record FailureResult(RuntimeException failure) implements FragmentResult
    {
        @Override
        public List<String> columns() {
            return List.of();
        }

        @Override
        public Record next() {
            throw this.failure;
        }

        @Override
        public PlanlessSummary consume() {
            return null;
        }

        @Override
        public QueryExecutionType executionType() {
            return null;
        }
    }

    private static sealed interface RemoteStreamEvent {

        public record Failure(RuntimeException e) implements RemoteStreamEvent
        {
        }

        public record StreamExhausted() implements RemoteStreamEvent
        {
        }

        public record Data(Record record) implements RemoteStreamEvent
        {
        }
    }
}

