/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.util.concurrent.OutOfOrderSequence;
import org.neo4j.util.concurrent.SequenceArray;

public class ArrayQueueOutOfOrderSequence
implements OutOfOrderSequence {
    private final SequenceArray outOfOrderQueue;
    private final AtomicReference<OutOfOrderSequence.NumberWithMeta> highestGapFreeNumber;
    private final AtomicLong highestEverSeen;
    private final AtomicReference<OutOfOrderSequence.ReverseSnapshot> reverseSnapshot;

    public ArrayQueueOutOfOrderSequence(long startingNumber, int initialArraySize, OutOfOrderSequence.Meta initialMeta) {
        this.highestGapFreeNumber = new AtomicReference<OutOfOrderSequence.NumberWithMeta>(new OutOfOrderSequence.NumberWithMeta(startingNumber, initialMeta));
        this.highestEverSeen = new AtomicLong(startingNumber);
        this.outOfOrderQueue = new SequenceArray(Numbers.ceilingPowerOfTwo((int)initialArraySize));
        this.reverseSnapshot = new AtomicReference<OutOfOrderSequence.ReverseSnapshot>(new OutOfOrderSequence.ReverseSnapshot(startingNumber, startingNumber, ArrayUtils.EMPTY_LONG_ARRAY));
    }

    @Override
    public synchronized boolean offer(long number, OutOfOrderSequence.Meta meta) {
        this.highestEverSeen.setRelease(Math.max(this.highestEverSeen.getAcquire(), number));
        OutOfOrderSequence.NumberWithMeta localGapFree = this.highestGapFreeNumber.getAcquire();
        if (localGapFree.number() + 1L == number) {
            this.highestGapFreeNumber.setRelease(this.outOfOrderQueue.pollHighestGapFree(number, meta));
            this.reverseSnapshot.setRelease(null);
            return true;
        }
        if (number <= localGapFree.number()) {
            throw new IllegalStateException("Was offered " + number + ", but highest gap-free is " + String.valueOf(this.highestGapFreeNumber) + " and was only expecting values higher than that");
        }
        this.outOfOrderQueue.offer(localGapFree.number(), number, meta);
        this.reverseSnapshot.setRelease(null);
        return false;
    }

    @Override
    public long highestEverSeen() {
        return this.highestEverSeen.getAcquire();
    }

    @Override
    public OutOfOrderSequence.NumberWithMeta get() {
        return this.highestGapFreeNumber.getAcquire();
    }

    @Override
    public long getHighestGapFreeNumber() {
        return this.highestGapFreeNumber.getAcquire().number();
    }

    @Override
    public synchronized void set(long number, OutOfOrderSequence.Meta meta) {
        this.highestEverSeen.setRelease(number);
        this.highestGapFreeNumber.setRelease(new OutOfOrderSequence.NumberWithMeta(number, meta));
        this.outOfOrderQueue.clear();
    }

    @Override
    public synchronized OutOfOrderSequence.Snapshot snapshot() {
        return new OutOfOrderSequence.Snapshot(this.highestGapFreeNumber.getAcquire().number(), this.outOfOrderQueue.snapshot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutOfOrderSequence.ReverseSnapshot reverseSnapshot() {
        OutOfOrderSequence.ReverseSnapshot rs = this.reverseSnapshot.getAcquire();
        if (rs != null) {
            return rs;
        }
        ArrayQueueOutOfOrderSequence arrayQueueOutOfOrderSequence = this;
        synchronized (arrayQueueOutOfOrderSequence) {
            rs = this.reverseSnapshot.getAcquire();
            if (rs != null) {
                return rs;
            }
            rs = this.createReverseSnapshot();
            this.reverseSnapshot.setRelease(rs);
            return rs;
        }
    }

    private OutOfOrderSequence.ReverseSnapshot createReverseSnapshot() {
        long gapFree = this.highestGapFreeNumber.getAcquire().number();
        long everSeen = this.highestEverSeen.getAcquire();
        if (everSeen == gapFree) {
            return new OutOfOrderSequence.ReverseSnapshot(gapFree, everSeen, ArrayUtils.EMPTY_LONG_ARRAY);
        }
        long[] missingNumbers = this.outOfOrderQueue.missingItems(gapFree);
        return new OutOfOrderSequence.ReverseSnapshot(gapFree, everSeen, missingNumbers);
    }

    public synchronized String toString() {
        return String.format("out-of-order-sequence:%d %d [%s]", this.highestEverSeen.getAcquire(), this.highestGapFreeNumber.getAcquire().number(), this.outOfOrderQueue);
    }
}

