/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.state;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.marshal.ChannelMarshal;
import org.neo4j.io.state.SimpleFileStorage;

public class ForcingFileStorage<T>
extends SimpleFileStorage<T> {
    public ForcingFileStorage(FileSystemAbstraction fileSystem, Path path, ChannelMarshal<T> marshal) {
        super(fileSystem, path, marshal);
    }

    @Override
    public void writeState(T state) throws IOException {
        super.writeState(state);
        try (StoreChannel channel = this.fileSystem.write(this.path);){
            channel.force(true);
        }
    }
}

