/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import apoc.coll.SetBackedList;
import apoc.util.Util;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class Graph {
    @UserAggregationFunction(value="apoc.agg.graph")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns all distinct `NODE` and `RELATIONSHIP` values collected into a `MAP` with the keys `nodes` and `relationships`.")
    public GraphAggregation graphCypher5() {
        return new GraphAggregation();
    }

    @Deprecated
    @UserAggregationFunction(name="apoc.agg.graph", deprecatedBy="Cypher's `COLLECT {}` expression.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns all distinct `NODE` and `RELATIONSHIP` values collected into a `MAP` with the keys `nodes` and `relationships`.")
    public GraphAggregation graph() {
        return new GraphAggregation();
    }

    public static class GraphAggregation {
        private Set<Node> nodes = new HashSet<Node>();
        private Set<Relationship> rels = new HashSet<Relationship>();
        private Set<Relationship> plainRels = new HashSet<Relationship>();

        @UserAggregationUpdate
        public void aggregate(@Name(value="path", description="A path to return nodes and relationships from.") Object element) {
            this.consume(element);
        }

        public void consume(@Name(value="path") Object element) {
            if (element instanceof Node) {
                this.nodes.add((Node)element);
            }
            if (element instanceof Relationship) {
                this.plainRels.add((Relationship)element);
            }
            if (element instanceof Path) {
                Path path = (Path)element;
                for (Node node : path.nodes()) {
                    this.nodes.add(node);
                }
                for (Relationship rel : path.relationships()) {
                    this.rels.add(rel);
                }
            }
            if (element instanceof Map) {
                ((Map)element).values().forEach(this::consume);
            }
            if (element instanceof Iterable) {
                ((Iterable)element).forEach(this::consume);
            }
        }

        @UserAggregationResult
        public Map<String, Object> result() {
            if (!this.plainRels.isEmpty()) {
                for (Relationship rel : this.plainRels) {
                    this.nodes.add(rel.getStartNode());
                    this.nodes.add(rel.getEndNode());
                }
                this.rels.addAll(this.plainRels);
            }
            return Util.map("nodes", new SetBackedList<Node>(this.nodes), "relationships", new SetBackedList<Relationship>(this.rels));
        }
    }
}

