/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import apoc.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class MaxAndMinItems {
    @UserAggregationFunction(value="apoc.agg.maxItems")
    @Description(value="Returns a `MAP` `{items: LIST<ANY>, value: ANY}` where the `value` key is the maximum value present, and `items` represent all items with the same value. The size of the list of items can be limited to a given max size.")
    public MaxItemsFunction maxItems() {
        return new MaxItemsFunction();
    }

    @UserAggregationFunction(value="apoc.agg.minItems")
    @Description(value="Returns a `MAP` `{items: LIST<ANY>, value: ANY}` where the `value` key is the minimum value present, and `items` represent all items with the same value. The size of the list of items can be limited to a given max size.")
    public MinItemsFunction minItems() {
        return new MinItemsFunction();
    }

    public static class MaxItemsFunction {
        private final List<Object> items = new ArrayList<Object>();
        private Comparable value;

        private MaxItemsFunction() {
        }

        @UserAggregationUpdate
        public void maxOrMinItems(@Name(value="item", description="A value to be aggregated.") Object item, @Name(value="value", description="The value from which the max is selected.") Object inputValue, @Name(value="groupLimit", defaultValue="-1", description="The limit on the number of items returned.") Long groupLimitParam) {
            boolean noGroupLimit;
            int groupLimit = groupLimitParam.intValue();
            boolean bl = noGroupLimit = groupLimit < 0;
            if (item != null && inputValue != null) {
                int result;
                int n = result = this.value == null ? -1 : this.value.compareTo(inputValue);
                if (result == 0) {
                    if (noGroupLimit || this.items.size() < groupLimit) {
                        this.items.add(item);
                    }
                } else if (result < 0) {
                    this.items.clear();
                    this.items.add(item);
                    this.value = (Comparable)inputValue;
                }
            }
        }

        @UserAggregationResult
        public Object result() {
            return Util.map("items", this.items, "value", this.value);
        }
    }

    public static class MinItemsFunction {
        private final List<Object> items = new ArrayList<Object>();
        private Comparable value;

        private MinItemsFunction() {
        }

        @UserAggregationUpdate
        public void maxOrMinItems(@Name(value="item", description="A value to be aggregated.") Object item, @Name(value="value", description="The value from which the min is selected.") Object inputValue, @Name(value="groupLimit", defaultValue="-1", description="The limit on the number of items returned.") Long groupLimitParam) {
            boolean noGroupLimit;
            int groupLimit = groupLimitParam.intValue();
            boolean bl = noGroupLimit = groupLimit < 0;
            if (item != null && inputValue != null) {
                int result;
                int n = result = this.value == null ? 1 : this.value.compareTo(inputValue);
                if (result == 0) {
                    if (noGroupLimit || this.items.size() < groupLimit) {
                        this.items.add(item);
                    }
                } else if (result >= 0) {
                    this.items.clear();
                    this.items.add(item);
                    this.value = (Comparable)inputValue;
                }
            }
        }

        @UserAggregationResult
        public Object result() {
            return Util.map("items", this.items, "value", this.value);
        }
    }
}

