/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.HdrHistogram.DoubleHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramUtil;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class Percentiles {
    @UserAggregationFunction(value="apoc.agg.percentiles")
    @Description(value="Returns the given percentiles over the range of numerical values in the given collection.")
    public PercentilesFunction percentiles() {
        return new PercentilesFunction();
    }

    public static class PercentilesFunction {
        private Histogram values = new Histogram(3);
        private DoubleHistogram doubles;
        private List<Double> percentiles = Arrays.asList(0.5, 0.75, 0.9, 0.95, 0.9, 0.99);

        @UserAggregationUpdate
        public void aggregate(@Name(value="value", description="A value to be aggregated.") Number value, @Name(value="percentiles", defaultValue="[0.5,0.75,0.9,0.95,0.99]", description="The percentiles from which the values are obtained.") List<Double> percentiles) {
            if (value != null) {
                if (this.doubles != null) {
                    this.doubles.recordValue(value.doubleValue());
                } else if (value instanceof Double || value instanceof Float) {
                    this.doubles = HistogramUtil.toDoubleHistogram(this.values, 5);
                    this.doubles.recordValue(value.doubleValue());
                    this.values = null;
                } else {
                    this.values.recordValue(value.longValue());
                }
            }
            this.percentiles = percentiles;
        }

        @UserAggregationResult
        public List<Number> result() {
            long totalCount = this.values != null ? this.values.getTotalCount() : this.doubles.getTotalCount();
            boolean empty = totalCount == 0L;
            ArrayList<Number> result = new ArrayList<Number>(this.percentiles.size());
            for (Double percentile : this.percentiles) {
                if (percentile == null || empty) {
                    result.add(null);
                    continue;
                }
                if (this.values != null) {
                    result.add(this.values.getValueAtPercentile(percentile * 100.0));
                    continue;
                }
                result.add(this.doubles.getValueAtPercentile(percentile * 100.0));
            }
            return result;
        }
    }
}

