/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.util.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Cover {
    @Context
    public Transaction tx;

    @Procedure(value="apoc.algo.cover")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Returns all `RELATIONSHIP` values connecting the given set of `NODE` values.")
    public Stream<AlgoCoverRelationshipResult> coverCypher5(@Name(value="nodes", description="The nodes to look for connected relationships on.") Object nodes) {
        Set<Node> nodeSet = Util.nodeStream((InternalTransaction)this.tx, nodes).collect(Collectors.toSet());
        return Cover.coverNodes(nodeSet).map(AlgoCoverRelationshipResult::new);
    }

    @Deprecated
    @Procedure(name="apoc.algo.cover", deprecatedBy="Cypher's `MATCH` and `IN` clauses.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Returns all `RELATIONSHIP` values connecting the given set of `NODE` values.")
    public Stream<AlgoCoverRelationshipResult> cover(@Name(value="nodes", description="The nodes to look for connected relationships on.") Object nodes) {
        Set<Node> nodeSet = Util.nodeStream((InternalTransaction)this.tx, nodes).collect(Collectors.toSet());
        return Cover.coverNodes(nodeSet).map(AlgoCoverRelationshipResult::new);
    }

    public static Stream<Relationship> coverNodes(Collection<Node> nodes) {
        HashSet<Node> nodeSet = new HashSet<Node>(nodes);
        return nodes.stream().flatMap(n -> StreamSupport.stream(n.getRelationships(Direction.OUTGOING).spliterator(), false).filter(r -> nodeSet.contains(r.getEndNode())));
    }

    public record AlgoCoverRelationshipResult(@Description(value="The relationships connected to the given nodes.") Relationship rel) {
    }
}

