/*
 * Decompiled with CFR 0.152.
 */
package apoc.bitwise;

import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class BitwiseOperations {
    @UserFunction(value="apoc.bitwise.op")
    @Description(value="Returns the result of the bitwise operation")
    public Long op(@Name(value="a", description="The lefthand side value of the bitwise operation.") Long a, @Name(value="operator", description="The type of bitwise operation to perform.") String operator, @Name(value="b", description="The righthand side value of the bitwise operation.") Long b) throws Exception {
        if (a == null || operator == null || operator.isEmpty()) {
            return null;
        }
        if (!operator.equals("~") && b == null) {
            return null;
        }
        switch (operator.toLowerCase()) {
            case "&": 
            case "and": {
                return a & b;
            }
            case "|": 
            case "or": {
                return a | b;
            }
            case "^": 
            case "xor": {
                return a ^ b;
            }
            case "~": 
            case "not": {
                return a ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case ">>": 
            case "right shift": {
                return a >> (int)b.longValue();
            }
            case ">>>": 
            case "right shift unsigned": {
                return a >>> (int)b.longValue();
            }
            case "<<": 
            case "left shift": {
                return a << (int)b.longValue();
            }
        }
        throw new Exception("Invalid bitwise operator : '" + operator + "'");
    }
}

