/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;

class Combinations
implements Iterable<int[]> {
    private final int n;
    private final int k;

    public Combinations(int n, int k) {
        Combinations.checkBinomial(n, k);
        this.n = n;
        this.k = k;
    }

    @Override
    public Iterator<int[]> iterator() {
        if (this.k == 0 || this.k == this.n) {
            return new SingletonIterator(IntStream.range(0, this.k).toArray());
        }
        return new LexicographicIterator(this.n, this.k);
    }

    private static void checkBinomial(int n, int k) {
        if (n < k) {
            throw new IllegalArgumentException("must have n >= k for binomial coefficient (n, k), got k = %d, n = %d".formatted(k, n));
        }
        if (n < 0) {
            throw new IllegalArgumentException("must have n >= 0 for binomial coefficient (n, k), got n = " + n);
        }
    }

    private static class SingletonIterator
    implements Iterator<int[]> {
        private final int[] singleton;
        private boolean more = true;

        SingletonIterator(int[] singleton) {
            this.singleton = singleton;
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public int[] next() {
            if (this.more) {
                this.more = false;
                return this.singleton;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class LexicographicIterator
    implements Iterator<int[]> {
        private final int k;
        private final int[] c;
        private boolean more = true;
        private int j;

        LexicographicIterator(int n, int k) {
            this.k = k;
            this.c = new int[k + 3];
            if (k == 0 || k >= n) {
                this.more = false;
                return;
            }
            for (int i = 1; i <= k; ++i) {
                this.c[i] = i - 1;
            }
            this.c[k + 1] = n;
            this.c[k + 2] = 0;
            this.j = k;
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public int[] next() {
            if (!this.more) {
                throw new NoSuchElementException();
            }
            int[] ret = new int[this.k];
            System.arraycopy(this.c, 1, ret, 0, this.k);
            int x = 0;
            if (this.j > 0) {
                this.c[this.j] = x = this.j;
                --this.j;
                return ret;
            }
            if (this.c[1] + 1 < this.c[2]) {
                this.c[1] = this.c[1] + 1;
                return ret;
            }
            this.j = 2;
            boolean stepDone = false;
            while (!stepDone) {
                this.c[this.j - 1] = this.j - 2;
                x = this.c[this.j] + 1;
                if (x == this.c[this.j + 1]) {
                    ++this.j;
                    continue;
                }
                stepDone = true;
            }
            if (this.j > this.k) {
                this.more = false;
                return ret;
            }
            this.c[this.j] = x;
            --this.j;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

