/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Pools;
import apoc.cypher.CypherUtils;
import apoc.cypher.RunManyResultSpliterator;
import apoc.result.CypherStatementMapResult;
import apoc.util.MapUtil;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.io.StringReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Cypher {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public Pools pools;
    @Context
    public ProcedureCallContext procedureCallContext;
    private static final Pattern shellControl = Pattern.compile("^:?\\b(begin|commit|rollback)\\b", 2);

    @NotThreadSafe
    @Procedure(value="apoc.cypher.run")
    @Description(value="Runs a dynamically constructed read-only statement with the given parameters.")
    public Stream<CypherStatementMapResult> run(@Name(value="statement", description="The Cypher statement to run.") String statement, @Name(value="params", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return CypherUtils.runCypherQuery(this.tx, statement, params, this.procedureCallContext);
    }

    @Procedure(name="apoc.cypher.runMany", mode=Mode.WRITE)
    @Description(value="Runs each semicolon separated statement and returns a summary of the statement outcomes.")
    public Stream<RowResult> runMany(@Name(value="statement", description="The Cypher statements to run, semicolon separated (;).") String cypher, @Name(value="params", description="The parameters for the given Cypher statements.") Map<String, Object> params, @Name(value="config", defaultValue="{}", description="{ statistics = true :: BOOLEAN }") Map<String, Object> config) {
        boolean addStatistics = Util.toBoolean(config.getOrDefault("statistics", true));
        return Iterators.stream(new Scanner(new StringReader(cypher)).useDelimiter(";\r?\n")).map(Cypher::removeShellControlCommands).filter(s -> !s.isBlank()).flatMap(s -> this.streamInNewTx((String)s, params, addStatistics));
    }

    private Stream<RowResult> streamInNewTx(String cypher, Map<String, Object> params, boolean stats) {
        try (Transaction innerTx = this.db.beginTx();){
            RunManyResultSpliterator results = new RunManyResultSpliterator(innerTx.execute(Util.prefixQueryWithCheck(this.procedureCallContext, cypher), params), stats);
            return (Stream)((Stream)StreamSupport.stream(results, false).onClose(results::close)).onClose(() -> ((Transaction)innerTx).commit());
        }
    }

    @NotThreadSafe
    @Procedure(name="apoc.cypher.runManyReadOnly", mode=Mode.READ)
    @Description(value="Runs each semicolon separated read-only statement and returns a summary of the statement outcomes.")
    public Stream<RowResult> runManyReadOnly(@Name(value="statement", description="The Cypher statements to run, semicolon separated (;).") String cypher, @Name(value="params", description="The parameters for the given Cypher statements.") Map<String, Object> params, @Name(value="config", defaultValue="{}", description="{ statistics = true :: BOOLEAN }") Map<String, Object> config) {
        return this.runMany(cypher, params, config);
    }

    private static String removeShellControlCommands(String stmt) {
        Matcher matcher = shellControl.matcher(stmt.trim());
        if (matcher.find()) {
            return Cypher.removeShellControlCommands(matcher.replaceAll(""));
        }
        return stmt;
    }

    protected static Map<String, Object> toMap(QueryStatistics stats, long time, long rows) {
        Map<String, Object> map = MapUtil.map("rows", rows, "time", time);
        map.putAll(Cypher.toMap(stats));
        return map;
    }

    public static Map<String, Object> toMap(QueryStatistics stats) {
        return MapUtil.map("nodesCreated", stats.getNodesCreated(), "nodesDeleted", stats.getNodesDeleted(), "labelsAdded", stats.getLabelsAdded(), "labelsRemoved", stats.getLabelsRemoved(), "relationshipsCreated", stats.getRelationshipsCreated(), "relationshipsDeleted", stats.getRelationshipsDeleted(), "propertiesSet", stats.getPropertiesSet(), "constraintsAdded", stats.getConstraintsAdded(), "constraintsRemoved", stats.getConstraintsRemoved(), "indexesAdded", stats.getIndexesAdded(), "indexesRemoved", stats.getIndexesRemoved());
    }

    @Procedure(name="apoc.cypher.doIt", mode=Mode.WRITE)
    @Description(value="Runs a dynamically constructed statement with the given parameters. This procedure allows for both read and write statements.")
    public Stream<CypherStatementMapResult> doIt(@Name(value="statement", description="The Cypher statement to run.") String statement, @Name(value="params", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return CypherUtils.runCypherQuery(this.tx, statement, params, this.procedureCallContext);
    }

    @Procedure(name="apoc.cypher.runWrite", mode=Mode.WRITE)
    @Description(value="Alias for `apoc.cypher.doIt`.")
    public Stream<CypherStatementMapResult> runWrite(@Name(value="statement", description="The Cypher statement to run.") String statement, @Name(value="params", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return this.doIt(statement, params);
    }

    @Procedure(name="apoc.cypher.runSchema", mode=Mode.SCHEMA)
    @Description(value="Runs the given query schema statement with the given parameters.")
    public Stream<CypherStatementMapResult> runSchema(@Name(value="statement", description="The Cypher schema statement to run.") String statement, @Name(value="params", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return CypherUtils.runCypherQuery(this.tx, statement, params, this.procedureCallContext);
    }

    @NotThreadSafe
    @Procedure(value="apoc.when")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="This procedure will run the read-only `ifQuery` if the conditional has evaluated to true, otherwise the `elseQuery` will run.")
    public Stream<CaseMapResult> whenCypher5(@Name(value="condition", description="The predicate deciding if to run the `ifQuery`or not.") boolean condition, @Name(value="ifQuery", description="The Cypher statement to run if the condition is true.") String ifQuery, @Name(value="elseQuery", defaultValue="", description="The Cypher statement to run if the condition is false.") String elseQuery, @Name(value="params", defaultValue="{}", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return this.when(condition, ifQuery, elseQuery, params);
    }

    @NotThreadSafe
    @Deprecated
    @Procedure(value="apoc.when", deprecatedBy="Cypher's conditional queries; WHEN ... THEN.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="This procedure will run the read-only `ifQuery` if the conditional has evaluated to true, otherwise the `elseQuery` will run.")
    public Stream<CaseMapResult> when(@Name(value="condition", description="The predicate deciding if to run the `ifQuery`or not.") boolean condition, @Name(value="ifQuery", description="The Cypher statement to run if the condition is true.") String ifQuery, @Name(value="elseQuery", defaultValue="", description="The Cypher statement to run if the condition is false.") String elseQuery, @Name(value="params", defaultValue="{}", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        String targetQuery;
        if (params == null) {
            params = Collections.emptyMap();
        }
        String string = targetQuery = condition ? ifQuery : elseQuery;
        if (targetQuery.isEmpty()) {
            return Stream.of(new CaseMapResult(Collections.emptyMap()));
        }
        String query = Util.prefixQueryWithCheck(this.procedureCallContext, CypherUtils.withParamMapping(targetQuery, params.keySet()));
        return this.tx.execute(query, params).stream().map(CaseMapResult::new);
    }

    @Procedure(value="apoc.do.when", mode=Mode.WRITE)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Runs the given read/write `ifQuery` if the conditional has evaluated to true, otherwise the `elseQuery` will run.")
    public Stream<CaseMapResult> doWhenCypher5(@Name(value="condition", description="The predicate that determines whether to execute the `ifQuery`.") boolean condition, @Name(value="ifQuery", description="The Cypher statement to run if the condition is true.") String ifQuery, @Name(value="elseQuery", description="The Cypher statement to run if the condition is false.") String elseQuery, @Name(value="params", defaultValue="{}", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return this.when(condition, ifQuery, elseQuery, params);
    }

    @Deprecated
    @Procedure(value="apoc.do.when", mode=Mode.WRITE, deprecatedBy="Cypher's conditional queries; WHEN ... THEN.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Runs the given read/write `ifQuery` if the conditional has evaluated to true, otherwise the `elseQuery` will run.")
    public Stream<CaseMapResult> doWhen(@Name(value="condition", description="The predicate that determines whether to execute the `ifQuery`.") boolean condition, @Name(value="ifQuery", description="The Cypher statement to run if the condition is true.") String ifQuery, @Name(value="elseQuery", description="The Cypher statement to run if the condition is false.") String elseQuery, @Name(value="params", defaultValue="{}", description="The parameters for the given Cypher statement.") Map<String, Object> params) {
        return this.when(condition, ifQuery, elseQuery, params);
    }

    @NotThreadSafe
    @Procedure(value="apoc.case")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="For each pair of conditional and read-only queries in the given `LIST<ANY>`, this procedure will run the first query for which the conditional is evaluated to true. If none of the conditionals are true, the `ELSE` query will run instead.")
    public Stream<CaseMapResult> whenCaseCypher5(@Name(value="conditionals", description="A list of conditionals, where each conditional is a pair: the first element is a predicate, and the second is a Cypher query to be executed based on that predicate.") List<Object> conditionals, @Name(value="elseQuery", defaultValue="", description="A Cypher query to evaluate if all conditionals evaluate to false.") String elseQuery, @Name(value="params", defaultValue="{}", description="A map of parameters to be used in the executed Cypher query.") Map<String, Object> params) {
        return this.whenCase(conditionals, elseQuery, params);
    }

    @NotThreadSafe
    @Deprecated
    @Procedure(value="apoc.case", deprecatedBy="Cypher's conditional queries; WHEN ... THEN.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="For each pair of conditional and read-only queries in the given `LIST<ANY>`, this procedure will run the first query for which the conditional is evaluated to true. If none of the conditionals are true, the `ELSE` query will run instead.")
    public Stream<CaseMapResult> whenCase(@Name(value="conditionals", description="A list of conditionals, where each conditional is a pair: the first element is a predicate, and the second is a Cypher query to be executed based on that predicate.") List<Object> conditionals, @Name(value="elseQuery", defaultValue="", description="A Cypher query to evaluate if all conditionals evaluate to false.") String elseQuery, @Name(value="params", defaultValue="{}", description="A map of parameters to be used in the executed Cypher query.") Map<String, Object> params) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        if (conditionals.size() % 2 != 0) {
            throw new IllegalArgumentException("Conditionals must be an even-sized collection of boolean, query entries");
        }
        Iterator<Object> caseItr = conditionals.iterator();
        while (caseItr.hasNext()) {
            boolean condition = (Boolean)caseItr.next();
            String ifQuery = (String)caseItr.next();
            if (!condition) continue;
            String query = Util.prefixQueryWithCheck(this.procedureCallContext, CypherUtils.withParamMapping(ifQuery, params.keySet()));
            return this.tx.execute(query, params).stream().map(CaseMapResult::new);
        }
        if (elseQuery.isEmpty()) {
            return Stream.of(new CaseMapResult(Collections.emptyMap()));
        }
        String query = Util.prefixQueryWithCheck(this.procedureCallContext, CypherUtils.withParamMapping(elseQuery, params.keySet()));
        return this.tx.execute(query, params).stream().map(CaseMapResult::new);
    }

    @Procedure(name="apoc.do.case", mode=Mode.WRITE)
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="For each pair of conditional queries in the given `LIST<ANY>`, this procedure will run the first query for which the conditional is evaluated to true.\nIf none of the conditionals are true, the `ELSE` query will run instead.")
    public Stream<CaseMapResult> doWhenCaseCypher5(@Name(value="conditionals", description="A list of conditionals, where each conditional is a pair: the first element is a predicate, and the second is a Cypher query to be executed based on that predicate.") List<Object> conditionals, @Name(value="elseQuery", defaultValue="", description="A Cypher query to evaluate if all conditionals evaluate to false.") String elseQuery, @Name(value="params", defaultValue="{}", description="A map of parameters to be used in the executed Cypher query.") Map<String, Object> params) {
        return this.whenCase(conditionals, elseQuery, params);
    }

    @Deprecated
    @Procedure(name="apoc.do.case", mode=Mode.WRITE, deprecatedBy="Cypher's conditional queries; WHEN ... THEN.")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="For each pair of conditional queries in the given `LIST<ANY>`, this procedure will run the first query for which the conditional is evaluated to true.\nIf none of the conditionals are true, the `ELSE` query will run instead.")
    public Stream<CaseMapResult> doWhenCase(@Name(value="conditionals", description="A list of conditionals, where each conditional is a pair: the first element is a predicate, and the second is a Cypher query to be executed based on that predicate.") List<Object> conditionals, @Name(value="elseQuery", defaultValue="", description="A Cypher query to evaluate if all conditionals evaluate to false.") String elseQuery, @Name(value="params", defaultValue="{}", description="A map of parameters to be used in the executed Cypher query.") Map<String, Object> params) {
        return this.whenCase(conditionals, elseQuery, params);
    }

    public record CaseMapResult(@Description(value="The result returned from the evaluated Cypher query.") Map<String, Object> value) {
        public static final CaseMapResult EMPTY = new CaseMapResult(Collections.emptyMap());

        public static CaseMapResult empty() {
            return EMPTY;
        }
    }

    public record RowResult(@Description(value="The row number of the run Cypher statement.") long row, @Description(value="The result returned from the Cypher statement.") Map<String, Object> result) {
    }
}

