/*
 * Decompiled with CFR 0.152.
 */
package apoc.cypher;

import apoc.Pools;
import apoc.result.CypherStatementMapResult;
import apoc.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.QueryLanguage;
import org.neo4j.kernel.api.procedure.QueryLanguageScope;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class Timeboxed {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public Pools pools;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public ProcedureCallContext procedureCallContext;
    private static final Map<String, Object> POISON = Collections.singletonMap("__magic", "POISON");

    @NotThreadSafe
    @Procedure(value="apoc.cypher.runTimeboxed")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_5})
    @Description(value="Terminates a Cypher statement if it has not finished before the set timeout (ms).")
    public Stream<CypherStatementMapResult> runTimeboxedCypher5(@Name(value="statement", description="The Cypher statement to run.") String cypher, @Name(value="params", description="The parameters for the given Cypher statement.") Map<String, Object> params, @Name(value="timeout", description="The maximum time, in milliseconds, the statement can run for.") long timeout) {
        return this.runTimeboxed(cypher, params, timeout, new HashMap<String, Object>());
    }

    @NotThreadSafe
    @Procedure(value="apoc.cypher.runTimeboxed")
    @QueryLanguageScope(scope={QueryLanguage.CYPHER_25})
    @Description(value="Terminates a Cypher statement if it has not finished before the set timeout (ms).")
    public Stream<CypherStatementMapResult> runTimeboxed(@Name(value="statement", description="The Cypher statement to run.") String cypher, @Name(value="params", description="The parameters for the given Cypher statement.") Map<String, Object> params, final @Name(value="timeout", description="The maximum time, in milliseconds, the statement can run for.") long timeout, @Name(value="config", defaultValue="{}", description="{ failOnError = false :: BOOLEAN, appendStatusRow = false :: BOOLEAN }") Map<String, Object> config) {
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
        AtomicReference txAtomic = new AtomicReference();
        final boolean failOnError = Util.toBoolean(config.get("failOnError"));
        boolean appendStatusRow = Util.toBoolean(config.get("appendStatusRow"));
        this.pools.getDefaultExecutorService().submit(() -> {
            Map<String, Object> map;
            try (Transaction innerTx = this.db.beginTx();){
                Map map2;
                txAtomic.set(innerTx);
                Result result = innerTx.execute(Util.prefixQueryWithCheck(this.procedureCallContext, cypher), params == null ? Collections.EMPTY_MAP : params);
                while (result.hasNext()) {
                    if (Util.transactionIsTerminated(this.terminationGuard)) {
                        ((Transaction)txAtomic.get()).close();
                        this.offerToQueue(queue, POISON, timeout);
                        return;
                    }
                    map2 = result.next();
                    this.offerToQueue(queue, map2, timeout);
                }
                if (appendStatusRow) {
                    map2 = this.statusMap(true, false, null);
                    this.offerToQueue(queue, map2, timeout);
                }
                innerTx.commit();
            }
            catch (TransactionTerminatedException e) {
                this.log.warn("query " + cypher + " has been terminated");
                if (appendStatusRow || failOnError) {
                    map = this.statusMap(false, true, null);
                    this.offerToQueue(queue, map, timeout);
                }
            }
            catch (QueryExecutionException e) {
                if (appendStatusRow || failOnError) {
                    map = this.statusMap(false, false, e.getMessage());
                    this.offerToQueue(queue, map, timeout);
                }
            }
            finally {
                this.offerToQueue(queue, POISON, timeout);
                txAtomic.set(null);
            }
        });
        this.pools.getScheduledExecutorService().schedule(() -> {
            Transaction tx = (Transaction)txAtomic.get();
            if (tx == null) {
                this.log.debug("tx is null, either the other transaction finished gracefully or has not yet been start.");
            } else {
                if (appendStatusRow || failOnError) {
                    Map<String, Object> map = this.statusMap(false, true, null);
                    this.offerToQueue(queue, map, timeout);
                }
                tx.terminate();
                this.offerToQueue(queue, POISON, timeout);
                this.log.warn("terminating transaction, putting POISON onto queue");
            }
        }, timeout, TimeUnit.MILLISECONDS);
        Iterator<Map<String, Object>> queueConsumer = new Iterator<Map<String, Object>>(){
            Map<String, Object> nextElement = null;
            boolean hasFinished = false;

            @Override
            public boolean hasNext() {
                if (this.hasFinished) {
                    return false;
                }
                try {
                    this.nextElement = (Map)queue.poll(timeout, TimeUnit.MILLISECONDS);
                    if (this.nextElement == null) {
                        this.nextElement = (Map)queue.poll(100L, TimeUnit.MILLISECONDS);
                        if (this.nextElement == null) {
                            Timeboxed.this.log.warn("Empty queue, aborting.");
                            if (failOnError) {
                                throw new RuntimeException("The query has been terminated.");
                            }
                            this.hasFinished = true;
                        }
                    }
                    if (failOnError && this.nextElement.get("wasSuccessful").equals(Boolean.FALSE)) {
                        if (this.nextElement.get("failedWithError").equals(Boolean.TRUE)) {
                            throw new RuntimeException("The inner query errored with: " + String.valueOf(this.nextElement.get("error")));
                        }
                        if (this.nextElement.get("wasTerminated").equals(Boolean.TRUE)) {
                            throw new RuntimeException("The query has been terminated.");
                        }
                    } else {
                        this.hasFinished = POISON.equals(this.nextElement);
                    }
                    return !this.hasFinished;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Map<String, Object> next() {
                return this.nextElement;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(queueConsumer, 16), false).map(CypherStatementMapResult::new);
    }

    private Map<String, Object> statusMap(boolean successful, boolean terminated, String errorMessage) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("wasSuccessful", successful ? Boolean.TRUE : Boolean.FALSE);
        map.put("wasTerminated", terminated ? Boolean.TRUE : Boolean.FALSE);
        map.put("failedWithError", errorMessage == null ? Boolean.FALSE : Boolean.TRUE);
        map.put("error", errorMessage);
        return map;
    }

    private void offerToQueue(BlockingQueue<Map<String, Object>> queue, Map<String, Object> map, long timeout) {
        try {
            boolean hasBeenAdded = queue.offer(map, timeout, TimeUnit.MILLISECONDS);
            if (!hasBeenAdded) {
                throw new IllegalStateException("couldn't add a value to a queue of size " + queue.size() + ". Either increase capacity or fix consumption of the queue");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

