/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.export.csv.CsvHeaderField;
import apoc.export.csv.CsvLoaderConfig;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Entity;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.PointValue;

public class CsvPropertyConverter {
    public static boolean addPropertyToGraphEntity(Entity entity, CsvHeaderField field, Object value, CsvLoaderConfig config) {
        if (field.isIgnore() || value == null) {
            return false;
        }
        if (field.isArray()) {
            boolean isEmptyCell;
            List list = (List)value;
            boolean listContainingNull = list.stream().anyMatch(Objects::isNull);
            boolean bl = isEmptyCell = config.isIgnoreEmptyCellArray() && list.equals(Collections.singletonList(""));
            if (listContainingNull || isEmptyCell) {
                return false;
            }
            Object[] prototype = CsvPropertyConverter.getPrototypeFor(field.getType().toUpperCase());
            Object[] array = list.toArray(prototype);
            entity.setProperty(field.getName(), (Object)array);
        } else {
            if (config.isIgnoreBlankString() && value instanceof String && StringUtils.isBlank((String)value)) {
                return false;
            }
            entity.setProperty(field.getName(), value);
        }
        return true;
    }

    static Object[] getPrototypeFor(String type) {
        switch (type) {
            case "INT": 
            case "LONG": {
                return new Long[0];
            }
            case "FLOAT": 
            case "DOUBLE": {
                return new Double[0];
            }
            case "BOOLEAN": {
                return new Boolean[0];
            }
            case "BYTE": {
                return new Byte[0];
            }
            case "SHORT": {
                return new Short[0];
            }
            case "CHAR": {
                return new Character[0];
            }
            case "STRING": {
                return new String[0];
            }
            case "DATETIME": {
                return new ZonedDateTime[0];
            }
            case "LOCALTIME": {
                return new LocalTime[0];
            }
            case "LOCALDATETIME": {
                return new LocalDateTime[0];
            }
            case "POINT": {
                return new PointValue[0];
            }
            case "TIME": {
                return new OffsetTime[0];
            }
            case "DATE": {
                return new LocalDate[0];
            }
            case "DURATION": {
                return new DurationValue[0];
            }
        }
        throw new IllegalStateException("Type " + type + " not supported.");
    }
}

