/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.formatter.CypherFormat;
import apoc.export.cypher.formatter.CypherFormatter;
import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;

public class MultiStatementCypherSubGraphExporter {
    private final SubGraph graph;
    private final Map<String, Set<String>> uniqueConstraints = new HashMap<String, Set<String>>();
    private Set<String> indexNames = new LinkedHashSet<String>();
    private Set<String> indexedProperties = new LinkedHashSet<String>();
    private Long artificialUniqueNodes = 0L;
    private Long artificialUniqueRels = 0L;
    private ExportFormat exportFormat;
    private CypherFormatter cypherFormat;
    private ExportConfig exportConfig;
    private GraphDatabaseService db;

    public MultiStatementCypherSubGraphExporter(SubGraph graph, ExportConfig config, GraphDatabaseService db) {
        this.graph = graph;
        this.exportFormat = config.getFormat();
        this.exportConfig = config;
        this.cypherFormat = config.getCypherFormat().getFormatter();
        this.db = db;
        this.gatherUniqueConstraints();
    }

    public void export(ExportConfig config, Reporter reporter, ExportFileManager cypherFileManager) {
        int batchSize = config.getBatchSize();
        ExportConfig.OptimizationType useOptimizations = config.getOptimizationType();
        PrintWriter schemaWriter = cypherFileManager.getPrintWriter("schema");
        PrintWriter nodesWriter = cypherFileManager.getPrintWriter("nodes");
        PrintWriter relationshipsWriter = cypherFileManager.getPrintWriter("relationships");
        PrintWriter cleanupWriter = cypherFileManager.getPrintWriter("cleanup");
        switch (useOptimizations) {
            case NONE: {
                this.exportNodes(nodesWriter, reporter, batchSize);
                this.exportSchema(schemaWriter, config);
                this.exportRelationships(relationshipsWriter, reporter, batchSize);
                break;
            }
            default: {
                this.artificialUniqueNodes = this.artificialUniqueNodes + this.countArtificialUniqueNodes(this.graph.getNodes());
                if (this.exportConfig.isMultipleRelationshipsWithType()) {
                    this.artificialUniqueRels = this.artificialUniqueRels + StreamSupport.stream(this.graph.getRelationships().spliterator(), false).count();
                }
                this.exportSchema(schemaWriter, config);
                reporter.update(0L, 0L, 0L);
                this.exportNodesUnwindBatch(nodesWriter, reporter);
                this.exportRelationshipsUnwindBatch(relationshipsWriter, reporter);
            }
        }
        if (cypherFileManager.separatedFiles().booleanValue()) {
            nodesWriter.close();
            schemaWriter.close();
            relationshipsWriter.close();
        }
        this.exportCleanUp(cleanupWriter, batchSize);
        cleanupWriter.close();
        reporter.done();
    }

    public void exportOnlySchema(ExportFileManager cypherFileManager, ProgressReporter reporter, ExportConfig config) {
        PrintWriter schemaWriter = cypherFileManager.getPrintWriter("schema");
        this.exportSchema(schemaWriter, config);
        schemaWriter.close();
        reporter.done();
    }

    private boolean hasNodes() {
        try (ResourceIterable<Node> nodes = this.graph.getNodes();){
            boolean bl = nodes.iterator().hasNext();
            return bl;
        }
    }

    private void exportNodes(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.hasNodes()) {
            this.begin(out);
            this.appendNodes(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private void exportNodesUnwindBatch(PrintWriter out, Reporter reporter) {
        if (this.hasNodes()) {
            try (ResourceIterable<Node> nodes = this.graph.getNodes();){
                this.cypherFormat.statementForNodes((Iterable<Node>)nodes, this.uniqueConstraints, this.exportConfig, out, reporter, this.db);
            }
            out.flush();
        }
    }

    private long appendNodes(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Node node : this.graph.getNodes()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendNode(out, node, reporter);
        }
        return count;
    }

    private void appendNode(PrintWriter out, Node node, Reporter reporter) {
        this.artificialUniqueNodes = this.artificialUniqueNodes + this.countArtificialUniqueNodes(node);
        String cypher = this.cypherFormat.statementForNode(node, this.uniqueConstraints, this.indexedProperties, this.indexNames);
        if (Util.isNotNullOrEmpty(cypher)) {
            out.println(cypher);
            reporter.update(1L, 0L, Iterables.count(node.getPropertyKeys()));
        }
    }

    private boolean hasRels() {
        try (ResourceIterable<Relationship> rels = this.graph.getRelationships();){
            boolean bl = rels.iterator().hasNext();
            return bl;
        }
    }

    private void exportRelationships(PrintWriter out, Reporter reporter, int batchSize) {
        if (this.hasRels()) {
            this.begin(out);
            this.appendRelationships(out, batchSize, reporter);
            this.commit(out);
            out.flush();
        }
    }

    private void exportRelationshipsUnwindBatch(PrintWriter out, Reporter reporter) {
        if (this.hasRels()) {
            try (ResourceIterable<Relationship> rels = this.graph.getRelationships();){
                this.cypherFormat.statementForRelationships((Iterable<Relationship>)rels, this.uniqueConstraints, this.exportConfig, out, reporter, this.db);
            }
            out.flush();
        }
    }

    private long appendRelationships(PrintWriter out, int batchSize, Reporter reporter) {
        long count = 0L;
        for (Relationship rel : this.graph.getRelationships()) {
            if (count > 0L && count % (long)batchSize == 0L) {
                this.restart(out);
            }
            ++count;
            this.appendRelationship(out, rel, reporter);
        }
        return count;
    }

    private void appendRelationship(PrintWriter out, Relationship rel, Reporter reporter) {
        String cypher;
        boolean updateFormat;
        boolean bl = updateFormat = this.exportConfig.getCypherFormat().equals((Object)CypherFormat.UPDATE_ALL) || this.exportConfig.getCypherFormat().equals((Object)CypherFormat.UPDATE_STRUCTURE);
        if (this.exportConfig.isMultipleRelationshipsWithType() && updateFormat) {
            this.artificialUniqueRels = this.artificialUniqueRels + this.countArtificialUniqueRels(rel);
        }
        if ((cypher = this.cypherFormat.statementForRelationship(rel, this.uniqueConstraints, this.indexedProperties, this.exportConfig)) != null && !"".equals(cypher)) {
            out.println(cypher);
            reporter.update(0L, 1L, Iterables.count(rel.getPropertyKeys()));
        }
    }

    private void exportSchema(PrintWriter out, ExportConfig config) {
        String cypher;
        ArrayList<String> indexesAndConstraints = new ArrayList<String>();
        indexesAndConstraints.addAll(this.exportIndexes());
        indexesAndConstraints.addAll(this.exportConstraints());
        if (indexesAndConstraints.isEmpty() && this.artificialUniqueNodes == 0L) {
            return;
        }
        this.begin(out);
        for (String index : indexesAndConstraints) {
            out.println(index);
        }
        if (this.artificialUniqueNodes > 0L && (cypher = this.cypherFormat.statementForCreateConstraint("UNIQUE_IMPORT_NAME", "UNIQUE IMPORT LABEL", Collections.singleton("UNIQUE IMPORT ID"), ConstraintType.UNIQUENESS, config.ifNotExists())) != null && !"".equals(cypher)) {
            out.println(cypher);
        }
        this.commit(out);
        if (this.graph.getIndexes().iterator().hasNext()) {
            out.print(this.exportFormat.indexAwait(this.exportConfig.getAwaitForIndexes()));
        }
        this.schemaAwait(out);
        out.flush();
    }

    private List<String> exportIndexes() {
        return StreamSupport.stream(this.graph.getIndexes().spliterator(), false).map(index -> {
            String name = index.getName();
            IndexType indexType = index.getIndexType();
            boolean isNodeIndex = index.isNodeIndex();
            if (indexType == IndexType.LOOKUP) {
                return "";
            }
            Iterable props = index.getPropertyKeys();
            List<String> tokenNames = isNodeIndex ? Iterables.stream(index.getLabels()).map(Label::name).collect(Collectors.toList()) : Iterables.stream(index.getRelationshipTypes()).map(RelationshipType::name).collect(Collectors.toList());
            boolean inGraph = this.tokensInGraph(tokenNames);
            if (!inGraph) {
                return null;
            }
            if (index.isConstraintIndex()) {
                return null;
            }
            if (indexType == IndexType.FULLTEXT) {
                if (isNodeIndex) {
                    return this.cypherFormat.statementForNodeFullTextIndex(name, index.getLabels(), props);
                }
                return this.cypherFormat.statementForRelationshipFullTextIndex(name, index.getRelationshipTypes(), props);
            }
            Object idxName = this.exportConfig.shouldSaveIndexNames() ? " " + name : "";
            String tokenName = tokenNames.get(0);
            boolean ifNotExist = this.exportConfig.ifNotExists();
            if (isNodeIndex) {
                return this.cypherFormat.statementForNodeIndex(indexType.toString(), tokenName, props, ifNotExist, (String)idxName);
            }
            return this.cypherFormat.statementForIndexRelationship(indexType.toString(), tokenName, props, ifNotExist, (String)idxName);
        }).filter(StringUtils::isNotBlank).sorted().collect(Collectors.toList());
    }

    private boolean tokensInGraph(List<String> tokens) {
        return StreamSupport.stream(this.graph.getIndexes().spliterator(), false).anyMatch(indexDefinition -> {
            if (indexDefinition.isRelationshipIndex()) {
                List typeNames = StreamSupport.stream(indexDefinition.getRelationshipTypes().spliterator(), false).map(RelationshipType::name).collect(Collectors.toList());
                return typeNames.containsAll(tokens);
            }
            List labelNames = StreamSupport.stream(indexDefinition.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toList());
            return labelNames.containsAll(tokens);
        });
    }

    private List<String> exportConstraints() {
        return StreamSupport.stream(this.graph.getConstraints().spliterator(), false).map(constraint -> {
            String name = constraint.getName();
            ConstraintType type = constraint.getConstraintType();
            String label = Util.isNodeCategory(type) ? constraint.getLabel().name() : constraint.getRelationshipType().name();
            Iterable props = constraint.getPropertyKeys();
            return this.cypherFormat.statementForCreateConstraint(name, label, props, type, this.exportConfig.ifNotExists());
        }).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private void exportCleanUp(PrintWriter out, int batchSize) {
        String cypher;
        if (this.artificialUniqueNodes > 0L) {
            while (this.artificialUniqueNodes > 0L) {
                cypher = this.cypherFormat.statementForCleanUpNodes(batchSize);
                this.begin(out);
                if (cypher != null && !"".equals(cypher)) {
                    out.println(cypher);
                }
                this.commit(out);
                this.artificialUniqueNodes = this.artificialUniqueNodes - (long)batchSize;
            }
            this.begin(out);
            cypher = this.cypherFormat.statementForDropConstraint("UNIQUE_IMPORT_NAME");
            if (cypher != null && !"".equals(cypher)) {
                out.println(cypher);
            }
            this.commit(out);
        }
        if (this.artificialUniqueRels > 0L) {
            while (this.artificialUniqueRels > 0L) {
                cypher = this.cypherFormat.statementForCleanUpRelationships(batchSize);
                this.begin(out);
                if (cypher != null && !"".equals(cypher)) {
                    out.println(cypher);
                }
                this.commit(out);
                this.artificialUniqueRels = this.artificialUniqueRels - (long)batchSize;
            }
        }
        out.flush();
    }

    public void begin(PrintWriter out) {
        out.print(this.exportFormat.begin());
    }

    private void schemaAwait(PrintWriter out) {
        out.print(this.exportFormat.schemaAwait());
    }

    private void restart(PrintWriter out) {
        this.commit(out);
        this.begin(out);
    }

    public void commit(PrintWriter out) {
        out.print(this.exportFormat.commit());
    }

    private void gatherUniqueConstraints() {
        for (IndexDefinition indexDefinition : this.graph.getIndexes()) {
            if (!indexDefinition.isNodeIndex() || indexDefinition.getIndexType() == IndexType.LOOKUP) continue;
            Set label = StreamSupport.stream(indexDefinition.getLabels().spliterator(), false).map(Label::name).collect(Collectors.toSet());
            Set props = StreamSupport.stream(indexDefinition.getPropertyKeys().spliterator(), false).collect(Collectors.toSet());
            this.indexNames.add(indexDefinition.getName());
            this.indexedProperties.addAll(props);
            if (!indexDefinition.isConstraintIndex()) continue;
            this.uniqueConstraints.compute(String.join((CharSequence)":", label), (k, v) -> v == null || v.size() > props.size() ? props : v);
        }
    }

    private long countArtificialUniqueNodes(Node node) {
        return this.getArtificialUniqueNodes(node, 0L);
    }

    private long countArtificialUniqueRels(Relationship rel) {
        return this.getArtificialUniqueRels(rel, 0L);
    }

    public long countArtificialUniqueNodes(ResourceIterable<Node> n) {
        long artificialUniques = 0L;
        for (Node node : n) {
            artificialUniques = this.getArtificialUniqueNodes(node, artificialUniques);
        }
        return artificialUniques;
    }

    public long countArtificialUniqueRels(Iterable<Relationship> r) {
        long artificialUniques = 0L;
        for (Relationship rel : r) {
            artificialUniques = this.getArtificialUniqueRels(rel, artificialUniques);
        }
        return artificialUniques;
    }

    private long getArtificialUniqueNodes(Node node, long artificialUniques) {
        Iterator labels = node.getLabels().iterator();
        boolean uniqueFound = false;
        while (labels.hasNext() && !uniqueFound) {
            Label next = (Label)labels.next();
            String labelName = next.name();
            uniqueFound = CypherFormatterUtils.isUniqueLabelFound(node, this.uniqueConstraints, labelName);
        }
        if (!uniqueFound) {
            ++artificialUniques;
        }
        return artificialUniques;
    }

    private long getArtificialUniqueRels(Relationship rel, long artificialUniques) {
        if (!CypherFormatterUtils.isUniqueRelationship(rel)) {
            ++artificialUniques;
        }
        return artificialUniques;
    }
}

